/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations.ddl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.ddl.CreateOperation;
import org.apache.flink.util.Preconditions;

public class CreateCatalogOperation
implements CreateOperation {
    private final String catalogName;
    private final Map<String, String> properties;

    public CreateCatalogOperation(String catalogName, Map<String, String> properties) {
        this.catalogName = (String)Preconditions.checkNotNull((Object)catalogName);
        this.properties = (Map)Preconditions.checkNotNull(properties);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public String asSummaryString() {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("catalogName", this.catalogName);
        params.put("properties", this.properties);
        return OperationUtils.formatWithChildren("CREATE CATALOG", params, Collections.emptyList(), Operation::asSummaryString);
    }
}

