/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.internal;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.WatermarkSpec;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.TimestampKind;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public class CatalogTableSchemaResolver {
    private final Parser parser;
    private final boolean isStreamingMode;

    public CatalogTableSchemaResolver(Parser parser, boolean isStreamingMode) {
        this.parser = parser;
        this.isStreamingMode = isStreamingMode;
    }

    public TableSchema resolve(TableSchema tableSchema) {
        String rowtime;
        if (!tableSchema.getWatermarkSpecs().isEmpty()) {
            rowtime = ((WatermarkSpec)tableSchema.getWatermarkSpecs().get(0)).getRowtimeAttribute();
            if (rowtime.contains(".")) {
                throw new ValidationException(String.format("Nested field '%s' as rowtime attribute is not supported right now.", rowtime));
            }
        } else {
            rowtime = null;
        }
        String[] fieldNames = tableSchema.getFieldNames();
        DataType[] fieldTypes = tableSchema.getFieldDataTypes();
        TableSchema.Builder builder = TableSchema.builder();
        for (int i = 0; i < tableSchema.getFieldCount(); ++i) {
            TableColumn tableColumn = (TableColumn)tableSchema.getTableColumns().get(i);
            DataType fieldType = fieldTypes[i];
            if (tableColumn.isGenerated() && this.isProctime(fieldType = this.resolveExpressionDataType((String)tableColumn.getExpr().get(), tableSchema)) && fieldNames[i].equals(rowtime)) {
                throw new TableException("Watermark can not be defined for a processing time attribute column.");
            }
            if (this.isStreamingMode && fieldNames[i].equals(rowtime)) {
                TimestampType originalType = (TimestampType)fieldType.getLogicalType();
                TimestampType rowtimeType = new TimestampType(originalType.isNullable(), TimestampKind.ROWTIME, originalType.getPrecision());
                fieldType = TypeConversions.fromLogicalToDataType((LogicalType)rowtimeType);
            }
            if (tableColumn.isGenerated()) {
                builder.field(fieldNames[i], fieldType, (String)tableColumn.getExpr().get());
                continue;
            }
            builder.field(fieldNames[i], fieldType);
        }
        tableSchema.getWatermarkSpecs().forEach(arg_0 -> ((TableSchema.Builder)builder).watermark(arg_0));
        tableSchema.getPrimaryKey().ifPresent(pk -> builder.primaryKey(pk.getName(), pk.getColumns().toArray(new String[0])));
        return builder.build();
    }

    private boolean isProctime(DataType exprType) {
        return LogicalTypeChecks.hasFamily((LogicalType)exprType.getLogicalType(), (LogicalTypeFamily)LogicalTypeFamily.TIMESTAMP) && LogicalTypeChecks.isProctimeAttribute((LogicalType)exprType.getLogicalType());
    }

    private DataType resolveExpressionDataType(String expr, TableSchema tableSchema) {
        ResolvedExpression resolvedExpr = this.parser.parseSqlExpression(expr, tableSchema);
        if (resolvedExpr == null) {
            throw new ValidationException("Could not resolve field expression: " + expr);
        }
        return resolvedExpr.getOutputDataType();
    }
}

