/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public class EnvironmentSettings {
    public static final String STREAMING_MODE = "streaming-mode";
    public static final String CLASS_NAME = "class-name";
    public static final String DEFAULT_BUILTIN_CATALOG = "default_catalog";
    public static final String DEFAULT_BUILTIN_DATABASE = "default_database";
    private final String plannerClass;
    private final String executorClass;
    private final String builtInCatalogName;
    private final String builtInDatabaseName;
    private final boolean isStreamingMode;

    private EnvironmentSettings(@Nullable String plannerClass, @Nullable String executorClass, String builtInCatalogName, String builtInDatabaseName, boolean isStreamingMode) {
        this.plannerClass = plannerClass;
        this.executorClass = executorClass;
        this.builtInCatalogName = builtInCatalogName;
        this.builtInDatabaseName = builtInDatabaseName;
        this.isStreamingMode = isStreamingMode;
    }

    public static Builder newInstance() {
        return new Builder();
    }

    public String getBuiltInCatalogName() {
        return this.builtInCatalogName;
    }

    public String getBuiltInDatabaseName() {
        return this.builtInDatabaseName;
    }

    public boolean isStreamingMode() {
        return this.isStreamingMode;
    }

    @Internal
    public Map<String, String> toPlannerProperties() {
        HashMap<String, String> properties = new HashMap<String, String>(this.toCommonProperties());
        if (this.plannerClass != null) {
            properties.put(CLASS_NAME, this.plannerClass);
        }
        return properties;
    }

    @Internal
    public Map<String, String> toExecutorProperties() {
        HashMap<String, String> properties = new HashMap<String, String>(this.toCommonProperties());
        if (this.executorClass != null) {
            properties.put(CLASS_NAME, this.executorClass);
        }
        return properties;
    }

    private Map<String, String> toCommonProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(STREAMING_MODE, Boolean.toString(this.isStreamingMode));
        return properties;
    }

    public static class Builder {
        private static final String OLD_PLANNER_FACTORY = "org.apache.flink.table.planner.StreamPlannerFactory";
        private static final String OLD_EXECUTOR_FACTORY = "org.apache.flink.table.executor.StreamExecutorFactory";
        private static final String BLINK_PLANNER_FACTORY = "org.apache.flink.table.planner.delegation.BlinkPlannerFactory";
        private static final String BLINK_EXECUTOR_FACTORY = "org.apache.flink.table.planner.delegation.BlinkExecutorFactory";
        private String plannerClass = "org.apache.flink.table.planner.delegation.BlinkPlannerFactory";
        private String executorClass = "org.apache.flink.table.planner.delegation.BlinkExecutorFactory";
        private String builtInCatalogName = "default_catalog";
        private String builtInDatabaseName = "default_database";
        private boolean isStreamingMode = true;

        public Builder useOldPlanner() {
            this.plannerClass = OLD_PLANNER_FACTORY;
            this.executorClass = OLD_EXECUTOR_FACTORY;
            return this;
        }

        public Builder useBlinkPlanner() {
            this.plannerClass = BLINK_PLANNER_FACTORY;
            this.executorClass = BLINK_EXECUTOR_FACTORY;
            return this;
        }

        public Builder useAnyPlanner() {
            this.plannerClass = null;
            this.executorClass = null;
            return this;
        }

        public Builder inBatchMode() {
            this.isStreamingMode = false;
            return this;
        }

        public Builder inStreamingMode() {
            this.isStreamingMode = true;
            return this;
        }

        public Builder withBuiltInCatalogName(String builtInCatalogName) {
            this.builtInCatalogName = builtInCatalogName;
            return this;
        }

        public Builder withBuiltInDatabaseName(String builtInDatabaseName) {
            this.builtInDatabaseName = builtInDatabaseName;
            return this;
        }

        public EnvironmentSettings build() {
            return new EnvironmentSettings(this.plannerClass, this.executorClass, this.builtInCatalogName, this.builtInDatabaseName, this.isStreamingMode);
        }
    }
}

