/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.rpc.model.MethodDescriptor;
import org.apache.dubbo.rpc.model.Pack;
import org.apache.dubbo.rpc.model.PackableMethod;
import org.apache.dubbo.rpc.model.ServiceDescriptor;
import org.apache.dubbo.rpc.model.StubServiceDescriptor;
import org.apache.dubbo.rpc.model.UnPack;

public class StubMethodDescriptor
implements MethodDescriptor,
PackableMethod {
    private static final Logger logger = LoggerFactory.getLogger(StubMethodDescriptor.class);
    private final ServiceDescriptor serviceDescriptor;
    private final ConcurrentMap<String, Object> attributeMap = new ConcurrentHashMap<String, Object>();
    private final String methodName;
    private final String[] compatibleParamSignatures;
    private final Class<?>[] parameterClasses;
    private final Class<?> returnClass;
    private final Type[] returnTypes;
    private final String paramDesc;
    private final MethodDescriptor.RpcType rpcType;
    private final Pack requestPack;
    private final Pack responsePack;
    private final UnPack requestUnpack;
    private final UnPack responseUnpack;

    public StubMethodDescriptor(String methodName, Class<?> requestClass, Class<?> responseClass, StubServiceDescriptor serviceDescriptor, MethodDescriptor.RpcType rpcType, Pack requestPack, Pack responsePack, UnPack requestUnpack, UnPack responseUnpack) {
        this.methodName = methodName;
        this.serviceDescriptor = serviceDescriptor;
        this.rpcType = rpcType;
        this.requestPack = requestPack;
        this.responsePack = responsePack;
        this.responseUnpack = responseUnpack;
        this.requestUnpack = requestUnpack;
        this.parameterClasses = new Class[]{requestClass};
        this.returnClass = responseClass;
        this.paramDesc = ReflectUtils.getDesc(this.parameterClasses);
        this.compatibleParamSignatures = (String[])Stream.of(this.parameterClasses).map(Class::getName).toArray(String[]::new);
        this.returnTypes = new Type[]{responseClass, responseClass};
        serviceDescriptor.addMethod(this);
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getParamDesc() {
        return this.paramDesc;
    }

    @Override
    public String[] getCompatibleParamSignatures() {
        return this.compatibleParamSignatures;
    }

    @Override
    public Class<?>[] getParameterClasses() {
        return this.parameterClasses;
    }

    @Override
    public Class<?> getReturnClass() {
        return this.returnClass;
    }

    @Override
    public Type[] getReturnTypes() {
        return this.returnTypes;
    }

    @Override
    public MethodDescriptor.RpcType getRpcType() {
        return this.rpcType;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public Method getMethod() {
        return null;
    }

    @Override
    public void addAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    @Override
    public Pack getRequestPack() {
        return this.requestPack;
    }

    @Override
    public Pack getResponsePack() {
        return this.responsePack;
    }

    @Override
    public UnPack getResponseUnpack() {
        return this.responseUnpack;
    }

    @Override
    public UnPack getRequestUnpack() {
        return this.requestUnpack;
    }
}

