/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.dq.utils;

import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.data.quality.utils.ParserUtils;
import org.apache.dolphinscheduler.plugin.datasource.api.utils.DataSourceUtils;
import org.apache.dolphinscheduler.plugin.task.api.DataQualityTaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.enums.dp.ExecuteSqlType;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.MapUtils;
import org.apache.dolphinscheduler.plugin.task.dq.exception.DataQualityException;
import org.apache.dolphinscheduler.plugin.task.dq.rule.entity.DqRuleExecuteSql;
import org.apache.dolphinscheduler.plugin.task.dq.rule.entity.DqRuleInputEntry;
import org.apache.dolphinscheduler.plugin.task.dq.rule.parameter.BaseConfig;
import org.apache.dolphinscheduler.plugin.task.dq.rule.parameter.EnvConfig;
import org.apache.dolphinscheduler.plugin.task.dq.rule.parser.MappingColumn;
import org.apache.dolphinscheduler.plugin.task.dq.utils.Md5Utils;
import org.apache.dolphinscheduler.spi.datasource.BaseConnectionParam;
import org.apache.dolphinscheduler.spi.datasource.ConnectionParam;
import org.apache.dolphinscheduler.spi.enums.DbType;

public class RuleParserUtils {
    private static final String AND_SRC_FILTER = "AND (${src_filter})";
    private static final String WHERE_SRC_FILTER = "WHERE (${src_filter})";
    private static final String AND_TARGET_FILTER = "AND (${target_filter})";
    private static final String WHERE_TARGET_FILTER = "WHERE (${target_filter})";

    private RuleParserUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<BaseConfig> getReaderConfigList(Map<String, String> inputParameterValue, DataQualityTaskExecutionContext dataQualityTaskExecutionContext) throws DataQualityException {
        String outputTable;
        HashMap<String, Object> config;
        ArrayList<BaseConfig> readerConfigList = new ArrayList<BaseConfig>();
        if (StringUtils.isNotEmpty((CharSequence)dataQualityTaskExecutionContext.getSourceConnectorType())) {
            BaseConnectionParam sourceDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)DbType.of((int)dataQualityTaskExecutionContext.getSourceType()), (String)dataQualityTaskExecutionContext.getSourceConnectionParams());
            BaseConfig sourceBaseConfig = new BaseConfig();
            sourceBaseConfig.setType(dataQualityTaskExecutionContext.getSourceConnectorType());
            config = new HashMap<String, Object>();
            if (sourceDataSource != null) {
                config.put("database", sourceDataSource.getDatabase());
                config.put("table", inputParameterValue.get("src_table"));
                config.put("url", DataSourceUtils.getJdbcUrl((DbType)DbType.of((int)dataQualityTaskExecutionContext.getSourceType()), (ConnectionParam)sourceDataSource));
                config.put("user", sourceDataSource.getUser());
                config.put("password", ParserUtils.encode((String)sourceDataSource.getPassword()));
                config.put("driver", DataSourceUtils.getDatasourceDriver((DbType)DbType.of((int)dataQualityTaskExecutionContext.getSourceType())));
                outputTable = sourceDataSource.getDatabase() + "_" + inputParameterValue.get("src_table");
                config.put("output_table", outputTable);
                inputParameterValue.put("src_table", outputTable);
            }
            sourceBaseConfig.setConfig(config);
            readerConfigList.add(sourceBaseConfig);
        }
        if (StringUtils.isNotEmpty((CharSequence)dataQualityTaskExecutionContext.getTargetConnectorType())) {
            BaseConnectionParam targetDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)DbType.of((int)dataQualityTaskExecutionContext.getTargetType()), (String)dataQualityTaskExecutionContext.getTargetConnectionParams());
            BaseConfig targetBaseConfig = new BaseConfig();
            targetBaseConfig.setType(dataQualityTaskExecutionContext.getTargetConnectorType());
            config = new HashMap();
            if (targetDataSource != null) {
                config.put("database", targetDataSource.getDatabase());
                config.put("table", inputParameterValue.get("target_table"));
                config.put("url", DataSourceUtils.getJdbcUrl((DbType)DbType.of((int)dataQualityTaskExecutionContext.getTargetType()), (ConnectionParam)targetDataSource));
                config.put("user", targetDataSource.getUser());
                config.put("password", ParserUtils.encode((String)targetDataSource.getPassword()));
                config.put("driver", DataSourceUtils.getDatasourceDriver((DbType)DbType.of((int)dataQualityTaskExecutionContext.getTargetType())));
                outputTable = targetDataSource.getDatabase() + "_" + inputParameterValue.get("target_table");
                config.put("output_table", outputTable);
                inputParameterValue.put("target_table", outputTable);
            }
            targetBaseConfig.setConfig(config);
            readerConfigList.add(targetBaseConfig);
        }
        return readerConfigList;
    }

    public static int replaceExecuteSqlPlaceholder(List<DqRuleExecuteSql> executeSqlList, int index, Map<String, String> inputParameterValueResult, List<BaseConfig> transformerConfigList) {
        List<DqRuleExecuteSql> midExecuteSqlDefinitionList = RuleParserUtils.getExecuteSqlListByType(executeSqlList, ExecuteSqlType.MIDDLE);
        List<DqRuleExecuteSql> statisticsExecuteSqlDefinitionList = RuleParserUtils.getExecuteSqlListByType(executeSqlList, ExecuteSqlType.STATISTICS);
        RuleParserUtils.checkAndReplace(midExecuteSqlDefinitionList, inputParameterValueResult.get("src_filter"), AND_SRC_FILTER);
        RuleParserUtils.checkAndReplace(midExecuteSqlDefinitionList, inputParameterValueResult.get("src_filter"), WHERE_SRC_FILTER);
        RuleParserUtils.checkAndReplace(statisticsExecuteSqlDefinitionList, inputParameterValueResult.get("src_filter"), AND_SRC_FILTER);
        RuleParserUtils.checkAndReplace(statisticsExecuteSqlDefinitionList, inputParameterValueResult.get("src_filter"), WHERE_SRC_FILTER);
        RuleParserUtils.checkAndReplace(midExecuteSqlDefinitionList, inputParameterValueResult.get("target_filter"), AND_TARGET_FILTER);
        RuleParserUtils.checkAndReplace(midExecuteSqlDefinitionList, inputParameterValueResult.get("target_filter"), WHERE_TARGET_FILTER);
        RuleParserUtils.checkAndReplace(statisticsExecuteSqlDefinitionList, inputParameterValueResult.get("target_filter"), AND_TARGET_FILTER);
        RuleParserUtils.checkAndReplace(statisticsExecuteSqlDefinitionList, inputParameterValueResult.get("target_filter"), WHERE_TARGET_FILTER);
        if (CollectionUtils.isNotEmpty(midExecuteSqlDefinitionList)) {
            for (DqRuleExecuteSql executeSqlDefinition : midExecuteSqlDefinitionList) {
                index = RuleParserUtils.setTransformerConfig(index, inputParameterValueResult, transformerConfigList, executeSqlDefinition);
            }
        }
        if (CollectionUtils.isNotEmpty(statisticsExecuteSqlDefinitionList)) {
            for (DqRuleExecuteSql executeSqlDefinition : statisticsExecuteSqlDefinitionList) {
                index = RuleParserUtils.setTransformerConfig(index, inputParameterValueResult, transformerConfigList, executeSqlDefinition);
            }
        }
        return index;
    }

    private static int setTransformerConfig(int index, Map<String, String> inputParameterValueResult, List<BaseConfig> transformerConfigList, DqRuleExecuteSql executeSqlDefinition) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("index", index++);
        config.put("sql", ParameterUtils.convertParameterPlaceholders((String)executeSqlDefinition.getSql(), inputParameterValueResult));
        config.put("output_table", executeSqlDefinition.getTableAlias());
        BaseConfig transformerConfig = new BaseConfig("sql", config);
        transformerConfigList.add(transformerConfig);
        return index;
    }

    public static List<BaseConfig> getSingleTableCustomSqlTransformerConfigList(int index, Map<String, String> inputParameterValueResult) {
        ArrayList<BaseConfig> list = new ArrayList<BaseConfig>();
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("index", index + 1);
        config.put("sql", ParameterUtils.convertParameterPlaceholders((String)inputParameterValueResult.get("statistics_execute_sql"), inputParameterValueResult));
        config.put("output_table", inputParameterValueResult.get("src_table"));
        inputParameterValueResult.put("statistics_table", inputParameterValueResult.get("src_table"));
        BaseConfig transformerConfig = new BaseConfig("sql", config);
        list.add(transformerConfig);
        return list;
    }

    private static String getCoalesceString(String table, String column) {
        return "coalesce(" + table + "." + column + ", '')";
    }

    private static String getSrcColumnIsNullStr(String table, List<String> columns) {
        CharSequence[] columnList = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            String column = columns.get(i);
            columnList[i] = table + "." + column + " IS NULL";
        }
        return String.join((CharSequence)" AND ", columnList);
    }

    public static Map<String, String> getInputParameterMapFromEntryList(List<DqRuleInputEntry> defaultInputEntryList) {
        HashMap<String, String> defaultInputParameterValue = new HashMap<String, String>();
        for (DqRuleInputEntry inputEntry : defaultInputEntryList) {
            defaultInputParameterValue.put(inputEntry.getField(), inputEntry.getValue());
        }
        return defaultInputParameterValue;
    }

    public static List<BaseConfig> getWriterConfigList(String sql, DataQualityTaskExecutionContext dataQualityTaskExecutionContext) throws DataQualityException {
        ArrayList<BaseConfig> writerConfigList = new ArrayList<BaseConfig>();
        if (StringUtils.isNotEmpty((CharSequence)dataQualityTaskExecutionContext.getWriterConnectorType())) {
            BaseConnectionParam writerDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)DbType.of((int)dataQualityTaskExecutionContext.getWriterType()), (String)dataQualityTaskExecutionContext.getWriterConnectionParams());
            BaseConfig writerConfig = new BaseConfig();
            writerConfig.setType(dataQualityTaskExecutionContext.getWriterConnectorType());
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (writerDataSource != null) {
                config.put("database", writerDataSource.getDatabase());
                config.put("table", dataQualityTaskExecutionContext.getWriterTable());
                config.put("url", DataSourceUtils.getJdbcUrl((DbType)DbType.of((int)dataQualityTaskExecutionContext.getWriterType()), (ConnectionParam)writerDataSource));
                config.put("user", writerDataSource.getUser());
                config.put("password", ParserUtils.encode((String)writerDataSource.getPassword()));
                config.put("driver", DataSourceUtils.getDatasourceDriver((DbType)DbType.of((int)dataQualityTaskExecutionContext.getWriterType())));
                config.put("sql", sql);
            }
            writerConfig.setConfig(config);
            writerConfigList.add(writerConfig);
        }
        return writerConfigList;
    }

    public static void addStatisticsValueTableReaderConfig(List<BaseConfig> readerConfigList, DataQualityTaskExecutionContext dataQualityTaskExecutionContext) {
        if (dataQualityTaskExecutionContext.isComparisonNeedStatisticsValueTable()) {
            List<BaseConfig> statisticsBaseConfigList = RuleParserUtils.getStatisticsValueConfigReaderList(dataQualityTaskExecutionContext);
            readerConfigList.addAll(statisticsBaseConfigList);
        }
    }

    public static List<BaseConfig> getStatisticsValueConfigWriterList(String sql, Map<String, String> inputParameterValueResult, DataQualityTaskExecutionContext dataQualityTaskExecutionContext) throws DataQualityException {
        ArrayList<BaseConfig> writerConfigList = new ArrayList<BaseConfig>();
        if (StringUtils.isNotEmpty((CharSequence)dataQualityTaskExecutionContext.getStatisticsValueConnectorType())) {
            BaseConfig writerConfig = RuleParserUtils.getStatisticsValueConfig(dataQualityTaskExecutionContext);
            if (writerConfig != null) {
                writerConfig.getConfig().put("sql", ParameterUtils.convertParameterPlaceholders((String)sql, inputParameterValueResult));
            }
            writerConfigList.add(writerConfig);
        }
        return writerConfigList;
    }

    public static List<BaseConfig> getStatisticsValueConfigReaderList(DataQualityTaskExecutionContext dataQualityTaskExecutionContext) throws DataQualityException {
        ArrayList<BaseConfig> readerConfigList = new ArrayList<BaseConfig>();
        if (StringUtils.isNotEmpty((CharSequence)dataQualityTaskExecutionContext.getStatisticsValueConnectorType())) {
            BaseConfig readerConfig = RuleParserUtils.getStatisticsValueConfig(dataQualityTaskExecutionContext);
            if (readerConfig != null) {
                readerConfig.getConfig().put("output_table", dataQualityTaskExecutionContext.getStatisticsValueTable());
            }
            readerConfigList.add(readerConfig);
        }
        return readerConfigList;
    }

    public static BaseConfig getStatisticsValueConfig(DataQualityTaskExecutionContext dataQualityTaskExecutionContext) throws DataQualityException {
        BaseConfig baseConfig = null;
        if (StringUtils.isNotEmpty((CharSequence)dataQualityTaskExecutionContext.getStatisticsValueConnectorType())) {
            BaseConnectionParam writerDataSource = (BaseConnectionParam)DataSourceUtils.buildConnectionParams((DbType)DbType.of((int)dataQualityTaskExecutionContext.getStatisticsValueType()), (String)dataQualityTaskExecutionContext.getStatisticsValueWriterConnectionParams());
            baseConfig = new BaseConfig();
            baseConfig.setType(dataQualityTaskExecutionContext.getStatisticsValueConnectorType());
            HashMap<String, Object> config = new HashMap<String, Object>();
            if (writerDataSource != null) {
                config.put("database", writerDataSource.getDatabase());
                config.put("table", dataQualityTaskExecutionContext.getStatisticsValueTable());
                config.put("url", DataSourceUtils.getJdbcUrl((DbType)DbType.of((int)dataQualityTaskExecutionContext.getStatisticsValueType()), (ConnectionParam)writerDataSource));
                config.put("user", writerDataSource.getUser());
                config.put("password", ParserUtils.encode((String)writerDataSource.getPassword()));
                config.put("driver", DataSourceUtils.getDatasourceDriver((DbType)DbType.of((int)dataQualityTaskExecutionContext.getWriterType())));
            }
            baseConfig.setConfig(config);
        }
        return baseConfig;
    }

    public static String getOnClause(List<MappingColumn> mappingColumnList, Map<String, String> inputParameterValueResult) {
        CharSequence[] columnList = new String[mappingColumnList.size()];
        for (int i = 0; i < mappingColumnList.size(); ++i) {
            MappingColumn column = mappingColumnList.get(i);
            columnList[i] = RuleParserUtils.getCoalesceString(inputParameterValueResult.get("src_table"), column.getSrcField()) + column.getOperator() + RuleParserUtils.getCoalesceString(inputParameterValueResult.get("target_table"), column.getTargetField());
        }
        return String.join((CharSequence)" AND ", columnList);
    }

    public static String getWhereClause(List<MappingColumn> mappingColumnList, Map<String, String> inputParameterValueResult) {
        String srcColumnNotNull = "( NOT (" + RuleParserUtils.getSrcColumnIsNullStr(inputParameterValueResult.get("src_table"), RuleParserUtils.getSrcColumnList(mappingColumnList)) + " ))";
        String targetColumnIsNull = "( " + RuleParserUtils.getSrcColumnIsNullStr(inputParameterValueResult.get("target_table"), RuleParserUtils.getTargetColumnList(mappingColumnList)) + " )";
        return srcColumnNotNull + " AND " + targetColumnIsNull;
    }

    public static List<BaseConfig> getWriterConfigList(int index, Map<String, String> inputParameterValueResult, List<BaseConfig> transformerConfigList, DataQualityTaskExecutionContext dataQualityTaskExecutionContext, String writerSql) throws DataQualityException {
        List<DqRuleExecuteSql> comparisonExecuteSqlList = RuleParserUtils.getExecuteSqlListByType(JSONUtils.toList((String)dataQualityTaskExecutionContext.getExecuteSqlList(), DqRuleExecuteSql.class), ExecuteSqlType.COMPARISON);
        if (CollectionUtils.isNotEmpty(comparisonExecuteSqlList)) {
            DqRuleExecuteSql comparisonSql = comparisonExecuteSqlList.get(0);
            inputParameterValueResult.put("comparison_table", comparisonSql.getTableAlias());
            RuleParserUtils.checkAndReplace(comparisonExecuteSqlList, inputParameterValueResult.get("src_filter"), AND_SRC_FILTER);
            RuleParserUtils.checkAndReplace(comparisonExecuteSqlList, inputParameterValueResult.get("src_filter"), WHERE_SRC_FILTER);
            RuleParserUtils.checkAndReplace(comparisonExecuteSqlList, inputParameterValueResult.get("target_filter"), AND_TARGET_FILTER);
            RuleParserUtils.checkAndReplace(comparisonExecuteSqlList, inputParameterValueResult.get("target_filter"), WHERE_TARGET_FILTER);
            for (DqRuleExecuteSql executeSqlDefinition : comparisonExecuteSqlList) {
                index = RuleParserUtils.setTransformerConfig(index, inputParameterValueResult, transformerConfigList, executeSqlDefinition);
            }
        }
        return RuleParserUtils.getWriterConfigList(ParameterUtils.convertParameterPlaceholders((String)writerSql, inputParameterValueResult), dataQualityTaskExecutionContext);
    }

    public static List<BaseConfig> getAllWriterConfigList(Map<String, String> inputParameterValue, DataQualityTaskExecutionContext context, int index, List<BaseConfig> transformerConfigList, String writerSql, String statisticsValueWriterSql) {
        List<BaseConfig> writerConfigList = RuleParserUtils.getWriterConfigList(index, inputParameterValue, transformerConfigList, context, writerSql);
        writerConfigList.addAll(RuleParserUtils.getStatisticsValueConfigWriterList(statisticsValueWriterSql, inputParameterValue, context));
        BaseConfig errorOutputWriter = RuleParserUtils.getErrorOutputWriter(inputParameterValue, context);
        if (errorOutputWriter != null) {
            writerConfigList.add(errorOutputWriter);
        }
        return writerConfigList;
    }

    public static List<DqRuleExecuteSql> getExecuteSqlListByType(List<DqRuleExecuteSql> allExecuteSqlList, ExecuteSqlType executeSqlType) {
        if (CollectionUtils.isEmpty(allExecuteSqlList)) {
            return allExecuteSqlList;
        }
        return allExecuteSqlList.stream().filter(x -> ExecuteSqlType.of((Integer)x.getType()) == executeSqlType).collect(Collectors.toList());
    }

    private static void checkAndReplace(List<DqRuleExecuteSql> list, String checkValue, String replaceSrc) {
        if (StringUtils.isEmpty((CharSequence)checkValue) && CollectionUtils.isNotEmpty(list)) {
            for (DqRuleExecuteSql executeSqlDefinition : list) {
                String sql = executeSqlDefinition.getSql();
                sql = sql.replace(replaceSrc, "");
                executeSqlDefinition.setSql(sql);
            }
        }
    }

    public static List<MappingColumn> getMappingColumnList(String mappingColumns) {
        ArrayNode mappingColumnList = JSONUtils.parseArray((String)mappingColumns);
        ArrayList<MappingColumn> list = new ArrayList<MappingColumn>();
        mappingColumnList.forEach(item -> {
            MappingColumn column = new MappingColumn(String.valueOf(item.get("src_field")).replace("\"", ""), String.valueOf(item.get("operator")).replace("\"", " "), String.valueOf(item.get("target_field")).replace("\"", ""));
            list.add(column);
        });
        return list;
    }

    public static List<String> getSrcColumnList(List<MappingColumn> mappingColumns) {
        ArrayList<String> list = new ArrayList<String>();
        mappingColumns.forEach(item -> list.add(item.getSrcField()));
        return list;
    }

    public static List<String> getTargetColumnList(List<MappingColumn> mappingColumns) {
        ArrayList<String> list = new ArrayList<String>();
        mappingColumns.forEach(item -> list.add(item.getTargetField()));
        return list;
    }

    public static EnvConfig getEnvConfig() {
        EnvConfig envConfig = new EnvConfig();
        envConfig.setType("batch");
        return envConfig;
    }

    public static BaseConfig getErrorOutputWriter(Map<String, String> inputParameterValueResult, DataQualityTaskExecutionContext dataQualityTaskExecutionContext) {
        List dqRuleExecuteSqlList = JSONUtils.toList((String)dataQualityTaskExecutionContext.getExecuteSqlList(), DqRuleExecuteSql.class);
        DqRuleExecuteSql errorOutputSql = null;
        if (CollectionUtils.isEmpty((Collection)dqRuleExecuteSqlList)) {
            return null;
        }
        for (DqRuleExecuteSql executeSql : dqRuleExecuteSqlList) {
            if (!executeSql.isErrorOutputSql()) continue;
            errorOutputSql = executeSql;
            break;
        }
        BaseConfig baseConfig = null;
        if (StringUtils.isNotEmpty((CharSequence)inputParameterValueResult.get("error_output_path")) && errorOutputSql != null) {
            baseConfig = new BaseConfig();
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("path", inputParameterValueResult.get("error_output_path"));
            config.put("input_table", errorOutputSql.getTableAlias());
            baseConfig.setConfig(config);
            baseConfig.setType("hdfs_file");
        }
        return baseConfig;
    }

    public static String generateUniqueCode(Map<String, String> inputParameterValue) {
        if (MapUtils.isEmpty(inputParameterValue)) {
            return "-1";
        }
        HashMap<String, String> newInputParameterValue = new HashMap<String, String>(inputParameterValue);
        newInputParameterValue.remove("rule_type");
        newInputParameterValue.remove("rule_name");
        newInputParameterValue.remove("create_time");
        newInputParameterValue.remove("update_time");
        newInputParameterValue.remove("process_definition_id");
        newInputParameterValue.remove("process_instance_id");
        newInputParameterValue.remove("task_instance_id");
        newInputParameterValue.remove("check_type");
        newInputParameterValue.remove("operator");
        newInputParameterValue.remove("threshold");
        newInputParameterValue.remove("failure_strategy");
        newInputParameterValue.remove("data_time");
        newInputParameterValue.remove("error_output_path");
        newInputParameterValue.remove("comparison_type");
        newInputParameterValue.remove("comparison_name");
        newInputParameterValue.remove("comparison_table");
        newInputParameterValue.remove("system.biz.curdate");
        newInputParameterValue.remove("system.biz.date");
        newInputParameterValue.remove("system.datetime");
        StringBuilder sb = new StringBuilder();
        for (String value : newInputParameterValue.values()) {
            sb.append(value);
        }
        return Md5Utils.getMd5(sb.toString(), true);
    }
}

