/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.obs;

import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.internal.ServiceException;
import com.obs.services.model.DeleteObjectsRequest;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObjectMetadata;
import com.obs.services.model.ObsObject;
import com.obs.services.model.PutObjectRequest;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.ResUploadType;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperate;
import org.apache.dolphinscheduler.spi.enums.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObsStorageOperator
implements Closeable,
StorageOperate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObsStorageOperator.class);
    private String accessKeyId;
    private String accessKeySecret;
    private String bucketName;
    private String endPoint;
    private ObsClient obsClient;

    public void init() {
        this.accessKeyId = this.readObsAccessKeyID();
        this.accessKeySecret = this.readObsAccessKeySecret();
        this.endPoint = this.readObsEndPoint();
        this.bucketName = this.readObsBucketName();
        this.obsClient = this.buildObsClient();
        this.ensureBucketSuccessfullyCreated(this.bucketName);
    }

    protected String readObsAccessKeyID() {
        return PropertyUtils.getString((String)"resource.huawei.cloud.access.key.id");
    }

    protected String readObsAccessKeySecret() {
        return PropertyUtils.getString((String)"resource.huawei.cloud.access.key.secret");
    }

    protected String readObsBucketName() {
        return PropertyUtils.getString((String)"resource.huawei.cloud.obs.bucket.name");
    }

    protected String readObsEndPoint() {
        return PropertyUtils.getString((String)"resource.huawei.cloud.obs.endpoint");
    }

    @Override
    public void close() throws IOException {
        this.obsClient.close();
    }

    public void createTenantDirIfNotExists(String tenantCode) throws Exception {
        this.mkdir(tenantCode, this.getObsResDir(tenantCode));
        this.mkdir(tenantCode, this.getObsUdfDir(tenantCode));
    }

    public String getResDir(String tenantCode) {
        return this.getObsResDir(tenantCode) + "/";
    }

    public String getUdfDir(String tenantCode) {
        return this.getObsUdfDir(tenantCode) + "/";
    }

    public boolean mkdir(String tenantCode, String path) throws IOException {
        String key = path + "/";
        if (!this.obsClient.doesObjectExist(this.bucketName, key)) {
            this.createObsPrefix(this.bucketName, key);
        }
        return true;
    }

    protected void createObsPrefix(String bucketName, String key) {
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(Long.valueOf(0L));
        ByteArrayInputStream emptyContent = new ByteArrayInputStream(new byte[0]);
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, (InputStream)emptyContent);
        this.obsClient.putObject(putObjectRequest);
    }

    public String getResourceFullName(String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return String.format("%s/%s", this.getObsResDir(tenantCode), fileName);
    }

    public String getFileName(ResourceType resourceType, String tenantCode, String fileName) {
        if (fileName.startsWith("/")) {
            fileName = fileName.replaceFirst("/", "");
        }
        return this.getDir(resourceType, tenantCode) + fileName;
    }

    public boolean delete(String fullName, List<String> childrenPathList, boolean recursive) throws IOException {
        childrenPathList.add(fullName);
        DeleteObjectsRequest deleteObjectsRequest = new DeleteObjectsRequest(this.bucketName);
        for (String deleteKys : childrenPathList) {
            deleteObjectsRequest.addKeyAndVersion(deleteKys);
        }
        try {
            this.obsClient.deleteObjects(deleteObjectsRequest);
        }
        catch (Exception e) {
            log.error("delete objects error", (Throwable)e);
            return false;
        }
        return true;
    }

    public void download(String srcFilePath, String dstFilePath, boolean overwrite) throws IOException {
        File dstFile = new File(dstFilePath);
        if (dstFile.isDirectory()) {
            Files.delete(dstFile.toPath());
        } else {
            FileUtils.createDirectoryWith755((Path)dstFile.getParentFile().toPath());
        }
        ObsObject obsObject = this.obsClient.getObject(this.bucketName, srcFilePath);
        try (InputStream obsInputStream = obsObject.getObjectContent();
             FileOutputStream fos = new FileOutputStream(dstFilePath);){
            int readLen;
            byte[] readBuf = new byte[1024];
            while ((readLen = obsInputStream.read(readBuf)) > 0) {
                fos.write(readBuf, 0, readLen);
            }
        }
        catch (ObsException e) {
            throw new IOException(e);
        }
        catch (FileNotFoundException e) {
            log.error("cannot find the destination file {}", (Object)dstFilePath);
            throw e;
        }
    }

    public boolean exists(String fileName) throws IOException {
        return this.obsClient.doesObjectExist(this.bucketName, fileName);
    }

    public boolean delete(String filePath, boolean recursive) throws IOException {
        try {
            this.obsClient.deleteObject(this.bucketName, filePath);
            return true;
        }
        catch (ObsException e) {
            log.error("fail to delete the object, the resource path is {}", (Object)filePath, (Object)e);
            return false;
        }
    }

    public boolean copy(String srcPath, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        this.obsClient.copyObject(this.bucketName, srcPath, this.bucketName, dstPath);
        if (deleteSource) {
            this.obsClient.deleteObject(this.bucketName, srcPath);
        }
        return true;
    }

    public String getDir(ResourceType resourceType, String tenantCode) {
        switch (resourceType) {
            case UDF: {
                return this.getUdfDir(tenantCode);
            }
            case FILE: {
                return this.getResDir(tenantCode);
            }
            case ALL: {
                return this.getObsDataBasePath();
            }
        }
        return "";
    }

    public boolean upload(String tenantCode, String srcFile, String dstPath, boolean deleteSource, boolean overwrite) throws IOException {
        try {
            this.obsClient.putObject(this.bucketName, dstPath, new File(srcFile));
            if (deleteSource) {
                Files.delete(Paths.get(srcFile, new String[0]));
            }
            return true;
        }
        catch (ObsException e) {
            log.error("upload failed, the bucketName is {}, the filePath is {}", new Object[]{this.bucketName, dstPath, e});
            return false;
        }
    }

    public List<String> vimFile(String tenantCode, String filePath, int skipLineNums, int limit) throws IOException {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            log.error("file path:{} is empty", (Object)filePath);
            return Collections.emptyList();
        }
        ObsObject obsObject = this.obsClient.getObject(this.bucketName, filePath);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(obsObject.getObjectContent()));){
            Stream<String> stream = bufferedReader.lines().skip(skipLineNums).limit(limit);
            List<String> list = stream.collect(Collectors.toList());
            return list;
        }
    }

    public ResUploadType returnStorageType() {
        return ResUploadType.OBS;
    }

    public List<StorageEntity> listFilesStatusRecursively(String path, String defaultPath, String tenantCode, ResourceType type) {
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        LinkedList<StorageEntity> foldersToFetch = new LinkedList<StorageEntity>();
        StorageEntity initialEntity = null;
        try {
            initialEntity = this.getFileStatus(path, defaultPath, tenantCode, type);
        }
        catch (Exception e) {
            log.error("error while listing files status recursively, path: {}", (Object)path, (Object)e);
            return storageEntityList;
        }
        foldersToFetch.add(initialEntity);
        while (!foldersToFetch.isEmpty()) {
            String pathToExplore = ((StorageEntity)foldersToFetch.pop()).getFullName();
            try {
                List<StorageEntity> tempList = this.listFilesStatus(pathToExplore, defaultPath, tenantCode, type);
                for (StorageEntity temp : tempList) {
                    if (!temp.isDirectory()) continue;
                    foldersToFetch.add(temp);
                }
                storageEntityList.addAll(tempList);
            }
            catch (Exception e) {
                log.error("error while listing files stat:wus recursively, path: {}", (Object)pathToExplore, (Object)e);
            }
        }
        return storageEntityList;
    }

    public List<StorageEntity> listFilesStatus(String path, String defaultPath, String tenantCode, ResourceType type) throws Exception {
        ArrayList<StorageEntity> storageEntityList = new ArrayList<StorageEntity>();
        ListObjectsRequest request = new ListObjectsRequest();
        request.setBucketName(this.bucketName);
        request.setPrefix(path);
        request.setDelimiter("/");
        ObjectListing result = null;
        try {
            result = this.obsClient.listObjects(request);
        }
        catch (Exception e) {
            throw new ServiceException("Get ObsClient file list exception", (Throwable)e);
        }
        while (result != null) {
            String nextMarker = result.getNextMarker();
            List objects = result.getObjects();
            for (ObsObject object : objects) {
                if (object.getObjectKey().endsWith("/")) continue;
                String[] aliasArr = object.getObjectKey().split("/");
                String alias = aliasArr[aliasArr.length - 1];
                String fileName = StringUtils.difference((String)defaultPath, (String)object.getObjectKey());
                StorageEntity entity = new StorageEntity();
                ObjectMetadata metadata = object.getMetadata();
                entity.setAlias(alias);
                entity.setFileName(fileName);
                entity.setFullName(object.getObjectKey());
                entity.setDirectory(false);
                entity.setUserName(tenantCode);
                entity.setType(type);
                entity.setSize(metadata.getContentLength().longValue());
                entity.setCreateTime(metadata.getLastModified());
                entity.setUpdateTime(metadata.getLastModified());
                entity.setPfullName(path);
                storageEntityList.add(entity);
            }
            for (String commonPrefix : result.getCommonPrefixes()) {
                String suffix = StringUtils.difference((String)path, (String)commonPrefix);
                String fileName = StringUtils.difference((String)defaultPath, (String)commonPrefix);
                StorageEntity entity = new StorageEntity();
                entity.setAlias(suffix);
                entity.setFileName(fileName);
                entity.setFullName(commonPrefix);
                entity.setDirectory(true);
                entity.setUserName(tenantCode);
                entity.setType(type);
                entity.setSize(0L);
                entity.setCreateTime(null);
                entity.setUpdateTime(null);
                entity.setPfullName(path);
                storageEntityList.add(entity);
            }
            if (!StringUtils.isNotBlank((CharSequence)nextMarker)) break;
            request.setMarker(nextMarker);
            try {
                result = this.obsClient.listObjects(request);
            }
            catch (Exception e) {
                throw new ServiceException("Get ObsClient file list exception", (Throwable)e);
            }
        }
        return storageEntityList;
    }

    public StorageEntity getFileStatus(String path, String defaultPath, String tenantCode, ResourceType type) throws Exception {
        ObsObject object;
        if (path.endsWith("/")) {
            String alias = this.findDirAlias(path);
            String fileName = StringUtils.difference((String)defaultPath, (String)path);
            StorageEntity entity = new StorageEntity();
            entity.setAlias(alias);
            entity.setFileName(fileName);
            entity.setFullName(path);
            entity.setDirectory(true);
            entity.setUserName(tenantCode);
            entity.setType(type);
            entity.setSize(0L);
            return entity;
        }
        GetObjectRequest request = new GetObjectRequest();
        request.setBucketName(this.bucketName);
        request.setObjectKey(path);
        try {
            object = this.obsClient.getObject(request);
        }
        catch (Exception e) {
            throw new ServiceException("Get ObsClient file list exception", (Throwable)e);
        }
        String[] aliasArr = object.getObjectKey().split("/");
        String alias = aliasArr[aliasArr.length - 1];
        String fileName = StringUtils.difference((String)defaultPath, (String)object.getObjectKey());
        StorageEntity entity = new StorageEntity();
        ObjectMetadata metadata = object.getMetadata();
        entity.setAlias(alias);
        entity.setFileName(fileName);
        entity.setFullName(object.getObjectKey());
        entity.setDirectory(false);
        entity.setUserName(tenantCode);
        entity.setType(type);
        entity.setSize(metadata.getContentLength().longValue());
        entity.setCreateTime(metadata.getLastModified());
        entity.setUpdateTime(metadata.getLastModified());
        return entity;
    }

    public void deleteTenant(String tenantCode) throws Exception {
        this.deleteTenantCode(tenantCode);
    }

    public String getObsResDir(String tenantCode) {
        return String.format("%s/resources", this.getObsTenantDir(tenantCode));
    }

    public String getObsUdfDir(String tenantCode) {
        return String.format("%s/udfs", this.getObsTenantDir(tenantCode));
    }

    public String getObsTenantDir(String tenantCode) {
        return String.format("%s/%s", this.getObsDataBasePath(), tenantCode);
    }

    public String getObsDataBasePath() {
        if ("/".equals(RESOURCE_UPLOAD_PATH)) {
            return "";
        }
        return RESOURCE_UPLOAD_PATH.replaceFirst("/", "");
    }

    protected void deleteTenantCode(String tenantCode) {
        this.deleteDir(this.getResDir(tenantCode));
        this.deleteDir(this.getUdfDir(tenantCode));
    }

    public void ensureBucketSuccessfullyCreated(String bucketName) {
        if (StringUtils.isBlank((CharSequence)bucketName)) {
            throw new IllegalArgumentException("resource.alibaba.cloud.obs.bucket.name is empty");
        }
        boolean existsBucket = this.obsClient.headBucket(bucketName);
        if (!existsBucket) {
            throw new IllegalArgumentException("bucketName: " + bucketName + " is not exists, you need to create them by yourself");
        }
        log.info("bucketName: {} has been found", (Object)bucketName);
    }

    protected void deleteDir(String directoryName) {
        if (this.obsClient.doesObjectExist(this.bucketName, directoryName)) {
            this.obsClient.deleteObject(this.bucketName, directoryName);
        }
    }

    protected ObsClient buildObsClient() {
        return new ObsClient(this.accessKeyId, this.accessKeySecret, this.endPoint);
    }

    private String findDirAlias(String dirPath) {
        if (!dirPath.endsWith("/")) {
            return dirPath;
        }
        Path path = Paths.get(dirPath, new String[0]);
        return path.getName(path.getNameCount() - 1) + "/";
    }

    @Generated
    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    @Generated
    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    @Generated
    public String getBucketName() {
        return this.bucketName;
    }

    @Generated
    public String getEndPoint() {
        return this.endPoint;
    }

    @Generated
    public ObsClient getObsClient() {
        return this.obsClient;
    }

    @Generated
    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    @Generated
    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    @Generated
    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    @Generated
    public void setEndPoint(String endPoint) {
        this.endPoint = endPoint;
    }

    @Generated
    public void setObsClient(ObsClient obsClient) {
        this.obsClient = obsClient;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObsStorageOperator)) {
            return false;
        }
        ObsStorageOperator other = (ObsStorageOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$accessKeyId = this.getAccessKeyId();
        String other$accessKeyId = other.getAccessKeyId();
        if (this$accessKeyId == null ? other$accessKeyId != null : !this$accessKeyId.equals(other$accessKeyId)) {
            return false;
        }
        String this$accessKeySecret = this.getAccessKeySecret();
        String other$accessKeySecret = other.getAccessKeySecret();
        if (this$accessKeySecret == null ? other$accessKeySecret != null : !this$accessKeySecret.equals(other$accessKeySecret)) {
            return false;
        }
        String this$bucketName = this.getBucketName();
        String other$bucketName = other.getBucketName();
        if (this$bucketName == null ? other$bucketName != null : !this$bucketName.equals(other$bucketName)) {
            return false;
        }
        String this$endPoint = this.getEndPoint();
        String other$endPoint = other.getEndPoint();
        if (this$endPoint == null ? other$endPoint != null : !this$endPoint.equals(other$endPoint)) {
            return false;
        }
        ObsClient this$obsClient = this.getObsClient();
        ObsClient other$obsClient = other.getObsClient();
        return !(this$obsClient == null ? other$obsClient != null : !this$obsClient.equals(other$obsClient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ObsStorageOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $accessKeyId = this.getAccessKeyId();
        result = result * 59 + ($accessKeyId == null ? 43 : $accessKeyId.hashCode());
        String $accessKeySecret = this.getAccessKeySecret();
        result = result * 59 + ($accessKeySecret == null ? 43 : $accessKeySecret.hashCode());
        String $bucketName = this.getBucketName();
        result = result * 59 + ($bucketName == null ? 43 : $bucketName.hashCode());
        String $endPoint = this.getEndPoint();
        result = result * 59 + ($endPoint == null ? 43 : $endPoint.hashCode());
        ObsClient $obsClient = this.getObsClient();
        result = result * 59 + ($obsClient == null ? 43 : $obsClient.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ObsStorageOperator(accessKeyId=" + this.getAccessKeyId() + ", accessKeySecret=" + this.getAccessKeySecret() + ", bucketName=" + this.getBucketName() + ", endPoint=" + this.getEndPoint() + ", obsClient=" + this.getObsClient() + ")";
    }
}

