/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.atompub;

import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.chemistry.opencmis.client.bindings.spi.BindingSession;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AbstractAtomPubService;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.AtomEntryWriter;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomElement;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomEntry;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomFeed;
import org.apache.chemistry.opencmis.client.bindings.spi.atompub.objects.AtomLink;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Output;
import org.apache.chemistry.opencmis.client.bindings.spi.http.Response;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.RepositoryInfo;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionList;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionContainerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeDefinitionListImpl;
import org.apache.chemistry.opencmis.commons.spi.RepositoryService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryServiceImpl
extends AbstractAtomPubService
implements RepositoryService {
    public RepositoryServiceImpl(BindingSession session) {
        this.setSession(session);
    }

    public List<RepositoryInfo> getRepositoryInfos(ExtensionsData extension) {
        return this.getRepositoriesInternal(null);
    }

    public RepositoryInfo getRepositoryInfo(String repositoryId, ExtensionsData extension) {
        List<RepositoryInfo> repositoryInfos = this.getRepositoriesInternal(repositoryId);
        if (repositoryInfos.size() == 0) {
            throw new CmisObjectNotFoundException("Repository '" + repositoryId + "'not found!");
        }
        if (repositoryInfos.size() == 1) {
            return repositoryInfos.get(0);
        }
        for (RepositoryInfo info : repositoryInfos) {
            if (info.getId() == null || !info.getId().equals(repositoryId)) continue;
            return info;
        }
        throw new CmisObjectNotFoundException("Repository '" + repositoryId + "'not found!");
    }

    public TypeDefinition getTypeDefinition(String repositoryId, String typeId, ExtensionsData extension) {
        return this.getTypeDefinitionInternal(repositoryId, typeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDefinitionList getTypeChildren(String repositoryId, String typeId, Boolean includePropertyDefinitions, BigInteger maxItems, BigInteger skipCount, ExtensionsData extension) {
        TypeDefinitionListImpl result = new TypeDefinitionListImpl();
        String link = null;
        link = typeId == null ? this.loadCollection(repositoryId, "types") : this.loadTypeLink(repositoryId, typeId, "down", "application/atom+xml;type=feed");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or type!");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("includePropertyDefinitions", (Object)includePropertyDefinitions);
        url.addParameter("maxItems", (Object)maxItems);
        url.addParameter("skipCount", (Object)skipCount);
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        for (AtomElement element : feed.getElements()) {
            if (element.getObject() instanceof AtomLink) {
                if (!this.isNextLink(element)) continue;
                result.setHasMoreItems(Boolean.TRUE);
                continue;
            }
            if (!this.isInt("numItems", element)) continue;
            result.setNumItems((BigInteger)element.getObject());
        }
        result.setList(new ArrayList(feed.getEntries().size()));
        if (!feed.getEntries().isEmpty()) {
            for (AtomEntry entry : feed.getEntries()) {
                TypeDefinition child = null;
                this.lockTypeLinks();
                try {
                    for (AtomElement element : entry.getElements()) {
                        if (element.getObject() instanceof AtomLink) {
                            this.addTypeLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                            continue;
                        }
                        if (!(element.getObject() instanceof TypeDefinition)) continue;
                        child = (TypeDefinition)element.getObject();
                    }
                }
                finally {
                    this.unlockTypeLinks();
                }
                if (child == null) continue;
                result.getList().add(child);
            }
        }
        return result;
    }

    public List<TypeDefinitionContainer> getTypeDescendants(String repositoryId, String typeId, BigInteger depth, Boolean includePropertyDefinitions, ExtensionsData extension) {
        ArrayList<TypeDefinitionContainer> result = new ArrayList<TypeDefinitionContainer>();
        String link = null;
        link = typeId == null ? this.loadRepositoryLink(repositoryId, "http://docs.oasis-open.org/ns/cmis/link/200908/typedescendants") : this.loadTypeLink(repositoryId, typeId, "down", "application/cmistree+xml");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or type!");
        }
        UrlBuilder url = new UrlBuilder(link);
        url.addParameter("depth", (Object)depth);
        url.addParameter("includePropertyDefinitions", (Object)includePropertyDefinitions);
        Response resp = this.read(url);
        AtomFeed feed = this.parse(resp.getStream(), AtomFeed.class);
        this.addTypeDescendantsLevel(repositoryId, feed, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTypeDescendantsLevel(String repositoryId, AtomFeed feed, List<TypeDefinitionContainer> containerList) {
        if (feed == null || feed.getEntries().isEmpty()) {
            return;
        }
        for (AtomEntry entry : feed.getEntries()) {
            TypeDefinitionContainerImpl childContainer = null;
            ArrayList<TypeDefinitionContainer> childContainerList = new ArrayList<TypeDefinitionContainer>();
            this.lockTypeLinks();
            try {
                for (AtomElement element : entry.getElements()) {
                    if (element.getObject() instanceof AtomLink) {
                        this.addTypeLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                        continue;
                    }
                    if (element.getObject() instanceof TypeDefinition) {
                        childContainer = new TypeDefinitionContainerImpl((TypeDefinition)element.getObject());
                        continue;
                    }
                    if (!(element.getObject() instanceof AtomFeed)) continue;
                    this.addTypeDescendantsLevel(repositoryId, (AtomFeed)element.getObject(), childContainerList);
                }
            }
            finally {
                this.unlockTypeLinks();
            }
            if (childContainer == null) continue;
            childContainer.setChildren(childContainerList);
            containerList.add((TypeDefinitionContainer)childContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDefinition createType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        if (type == null) {
            throw new CmisInvalidArgumentException("Type definition must be set!");
        }
        String parentId = type.getParentTypeId();
        if (parentId == null) {
            throw new CmisInvalidArgumentException("Type definition has no parent type id!");
        }
        String link = this.loadTypeLink(repositoryId, parentId, "down", "application/atom+xml;type=feed");
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or parent type!");
        }
        final AtomEntryWriter entryWriter = new AtomEntryWriter(type, this.getCmisVersion(repositoryId));
        Response resp = this.post(new UrlBuilder(link), "application/atom+xml;type=entry", new Output(){

            public void write(OutputStream out) throws Exception {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        if (entry.getId() == null) {
            throw new CmisConnectionException("Received Atom entry is not a CMIS entry!");
        }
        this.lockTypeLinks();
        TypeDefinition result = null;
        try {
            this.removeTypeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                if (element.getObject() instanceof AtomLink) {
                    this.addTypeLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                    continue;
                }
                if (!(element.getObject() instanceof TypeDefinition)) continue;
                result = (TypeDefinition)element.getObject();
            }
        }
        finally {
            this.unlockTypeLinks();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDefinition updateType(String repositoryId, TypeDefinition type, ExtensionsData extension) {
        if (type == null) {
            throw new CmisInvalidArgumentException("Type definition must be set!");
        }
        String typeId = type.getId();
        if (typeId == null) {
            throw new CmisInvalidArgumentException("Type definition has no type id!");
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", typeId);
        String link = this.loadTemplateLink(repositoryId, "typebyid", parameters);
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository or type!");
        }
        final AtomEntryWriter entryWriter = new AtomEntryWriter(type, this.getCmisVersion(repositoryId));
        Response resp = this.put(new UrlBuilder(link), "application/atom+xml;type=entry", new Output(){

            public void write(OutputStream out) throws Exception {
                entryWriter.write(out);
            }
        });
        AtomEntry entry = this.parse(resp.getStream(), AtomEntry.class);
        if (entry.getId() == null) {
            throw new CmisConnectionException("Received Atom entry is not a CMIS entry!");
        }
        this.lockTypeLinks();
        TypeDefinition result = null;
        try {
            this.removeTypeLinks(repositoryId, entry.getId());
            for (AtomElement element : entry.getElements()) {
                if (element.getObject() instanceof AtomLink) {
                    this.addTypeLink(repositoryId, entry.getId(), (AtomLink)element.getObject());
                    continue;
                }
                if (!(element.getObject() instanceof TypeDefinition)) continue;
                result = (TypeDefinition)element.getObject();
            }
        }
        finally {
            this.unlockTypeLinks();
        }
        return result;
    }

    public void deleteType(String repositoryId, String typeId, ExtensionsData extension) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", typeId);
        String link = this.loadTemplateLink(repositoryId, "typebyid", parameters);
        if (link == null) {
            throw new CmisObjectNotFoundException("Unknown repository!");
        }
        this.delete(new UrlBuilder(link));
    }
}

