/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.constants.LoggerAction;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.CarbonMetadata;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonMeasure;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.processing.datatypes.ArrayDataType;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.datatypes.PrimitiveDataType;
import org.apache.carbondata.processing.datatypes.StructDataType;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.complexobjects.ArrayObject;
import org.apache.carbondata.processing.loading.model.CarbonDataLoadSchema;
import org.apache.carbondata.processing.loading.sort.SortScopeOptions;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class CarbonDataProcessorUtil {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonDataProcessorUtil.class.getName());

    private CarbonDataProcessorUtil() {
    }

    public static void deleteSortLocationIfExists(String[] locations) {
        for (String loc : locations) {
            File file = new File(loc);
            if (!file.exists()) continue;
            try {
                CarbonUtil.deleteFoldersAndFiles((File[])new File[]{file});
            }
            catch (IOException | InterruptedException e) {
                LOGGER.error((Throwable)e, "Failed to delete " + loc);
            }
        }
    }

    public static void createLocations(String[] locations) {
        for (String loc : locations) {
            File dir = new File(loc);
            if (dir.exists()) {
                LOGGER.warn("dir already exists, skip dir creation: " + loc);
                continue;
            }
            if (dir.mkdirs()) continue;
            LOGGER.error("Error occurs while creating dir: " + loc);
        }
    }

    public static String[] getLocalDataFolderLocation(CarbonTable carbonTable, String taskId, String segmentId, boolean isCompactionFlow, boolean isAltPartitionFlow) {
        String tempLocationKey = CarbonDataProcessorUtil.getTempStoreLocationKey(carbonTable.getDatabaseName(), carbonTable.getTableName(), segmentId, taskId, isCompactionFlow, isAltPartitionFlow);
        String baseTempStorePath = CarbonProperties.getInstance().getProperty(tempLocationKey);
        if (baseTempStorePath == null) {
            LOGGER.warn("Location not set for the key " + tempLocationKey + ". This will occur during a global-sort loading, in this case local dirs will be chosen by spark");
            baseTempStorePath = "./store.location";
        }
        String[] baseTmpStorePathArray = StringUtils.split((String)baseTempStorePath, (String)File.pathSeparator);
        String[] localDataFolderLocArray = new String[baseTmpStorePathArray.length];
        for (int i = 0; i < baseTmpStorePathArray.length; ++i) {
            String tmpStore = baseTmpStorePathArray[i];
            String carbonDataDirectoryPath = CarbonTablePath.getSegmentPath((String)tmpStore, (String)segmentId);
            localDataFolderLocArray[i] = carbonDataDirectoryPath + File.separator + taskId;
        }
        return localDataFolderLocArray;
    }

    public static String[] getLocalDataFolderLocation(String databaseName, String tableName, String taskId, String segmentId, boolean isCompactionFlow, boolean isAltPartitionFlow) {
        CarbonTable carbonTable = CarbonMetadata.getInstance().getCarbonTable(databaseName, tableName);
        return CarbonDataProcessorUtil.getLocalDataFolderLocation(carbonTable, taskId, segmentId, isCompactionFlow, isAltPartitionFlow);
    }

    public static String getTempStoreLocationKey(String databaseName, String tableName, String segmentId, String taskId, boolean isCompactionFlow, boolean isAltPartitionFlow) {
        String tempLocationKey = databaseName + "_" + tableName + "_" + segmentId + "_" + taskId;
        if (isCompactionFlow) {
            tempLocationKey = "COMPACTION_" + tempLocationKey;
        }
        if (isAltPartitionFlow) {
            tempLocationKey = "ALTER_PARTITION_" + tempLocationKey;
        }
        return tempLocationKey;
    }

    public static boolean[] getNoDictionaryMapping(DataField[] fields) {
        ArrayList<Boolean> noDictionaryMapping = new ArrayList<Boolean>();
        for (DataField field : fields) {
            if (field.getColumn().isComplex().booleanValue()) break;
            if (!field.hasDictionaryEncoding() && field.getColumn().isDimension().booleanValue()) {
                noDictionaryMapping.add(true);
                continue;
            }
            if (!field.getColumn().isDimension().booleanValue()) continue;
            noDictionaryMapping.add(false);
        }
        return ArrayUtils.toPrimitive((Boolean[])noDictionaryMapping.toArray(new Boolean[noDictionaryMapping.size()]));
    }

    public static boolean[] getIsVarcharColumnMapping(DataField[] fields) {
        ArrayList<Boolean> isVarcharColumnMapping = new ArrayList<Boolean>();
        for (DataField field : fields) {
            if (field.getColumn().isComplex().booleanValue()) break;
            if (!field.getColumn().isDimension().booleanValue()) continue;
            isVarcharColumnMapping.add(field.getColumn().getColumnSchema().getDataType() == DataTypes.VARCHAR);
        }
        return ArrayUtils.toPrimitive((Boolean[])isVarcharColumnMapping.toArray(new Boolean[isVarcharColumnMapping.size()]));
    }

    public static boolean[] getNoDictionaryMapping(CarbonColumn[] carbonColumns) {
        ArrayList<Boolean> noDictionaryMapping = new ArrayList<Boolean>();
        for (CarbonColumn column : carbonColumns) {
            if (column.isComplex().booleanValue()) break;
            if (!column.hasEncoding(Encoding.DICTIONARY) && column.isDimension().booleanValue()) {
                noDictionaryMapping.add(true);
                continue;
            }
            if (!column.isDimension().booleanValue()) continue;
            noDictionaryMapping.add(false);
        }
        return ArrayUtils.toPrimitive((Boolean[])noDictionaryMapping.toArray(new Boolean[noDictionaryMapping.size()]));
    }

    public static void getComplexNoDictionaryMapping(DataField[] dataFields, List<Integer> complexNoDictionary) {
        for (DataField field : dataFields) {
            if (!field.getColumn().isComplex().booleanValue()) continue;
            CarbonDataProcessorUtil.getComplexNoDictionaryMapping(((CarbonDimension)field.getColumn()).getListOfChildDimensions(), complexNoDictionary);
        }
    }

    public static void getComplexNoDictionaryMapping(List<CarbonDimension> carbonDimensions, List<Integer> complexNoDictionary) {
        for (CarbonDimension carbonDimension : carbonDimensions) {
            if (carbonDimension.isComplex().booleanValue()) {
                CarbonDataProcessorUtil.getComplexNoDictionaryMapping(carbonDimension.getListOfChildDimensions(), complexNoDictionary);
                continue;
            }
            if (carbonDimension.hasEncoding(Encoding.DICTIONARY)) continue;
            complexNoDictionary.add(carbonDimension.getOrdinal());
        }
    }

    public static boolean[] getIsUseInvertedIndex(DataField[] fields) {
        ArrayList<Boolean> isUseInvertedIndexList = new ArrayList<Boolean>();
        for (DataField field : fields) {
            if (field.getColumn().isUseInvertedIndex().booleanValue() && field.getColumn().isDimension().booleanValue()) {
                isUseInvertedIndexList.add(true);
                continue;
            }
            if (!field.getColumn().isDimension().booleanValue()) continue;
            isUseInvertedIndexList.add(false);
        }
        return ArrayUtils.toPrimitive((Boolean[])isUseInvertedIndexList.toArray(new Boolean[isUseInvertedIndexList.size()]));
    }

    private static String getComplexTypeString(DataField[] dataFields) {
        StringBuilder dimString = new StringBuilder();
        for (DataField dataField : dataFields) {
            if (!dataField.getColumn().getDataType().isComplexType()) continue;
            CarbonDataProcessorUtil.addAllComplexTypeChildren((CarbonDimension)dataField.getColumn(), dimString, "");
            dimString.append(";#!@:SEMIC:@!#;");
        }
        return dimString.toString();
    }

    private static String isDictionaryType(CarbonDimension dimension) {
        Boolean isDictionary = true;
        if (!dimension.hasEncoding(Encoding.DICTIONARY)) {
            isDictionary = false;
        }
        return isDictionary.toString();
    }

    private static void addAllComplexTypeChildren(CarbonDimension dimension, StringBuilder dimString, String parent) {
        dimString.append(dimension.getColName()).append(":!@#COLON#@!:").append(dimension.getDataType()).append(":!@#COLON#@!:").append(parent).append(":!@#COLON#@!:").append(CarbonDataProcessorUtil.isDictionaryType(dimension)).append(":!@#COLON#@!:").append(dimension.getColumnId()).append("#!@:HASH:@!#");
        for (int i = 0; i < dimension.getNumberOfChild(); ++i) {
            CarbonDimension childDim = (CarbonDimension)dimension.getListOfChildDimensions().get(i);
            if (childDim.getNumberOfChild() > 0) {
                CarbonDataProcessorUtil.addAllComplexTypeChildren(childDim, dimString, dimension.getColName());
                continue;
            }
            dimString.append(childDim.getColName()).append(":!@#COLON#@!:").append(childDim.getDataType()).append(":!@#COLON#@!:").append(dimension.getColName()).append(":!@#COLON#@!:").append(CarbonDataProcessorUtil.isDictionaryType(dimension)).append(":!@#COLON#@!:").append(childDim.getColumnId()).append(":!@#COLON#@!:").append(childDim.getOrdinal()).append("#!@:HASH:@!#");
        }
    }

    public static Map<String, GenericDataType> getComplexTypesMap(DataField[] dataFields, CarbonDataLoadConfiguration configuration) {
        String complexTypeString = CarbonDataProcessorUtil.getComplexTypeString(dataFields);
        if (null == complexTypeString || complexTypeString.equals("")) {
            return new LinkedHashMap<String, GenericDataType>();
        }
        String nullFormat = configuration.getDataLoadProperty("SERIALIZATION_NULL_FORMAT").toString();
        boolean isEmptyBadRecord = Boolean.parseBoolean(configuration.getDataLoadProperty("IS_EMPTY_DATA_BAD_RECORD").toString());
        LinkedHashMap<String, GenericDataType> complexTypesMap = new LinkedHashMap<String, GenericDataType>();
        String[] hierarchies = complexTypeString.split(";#!@:SEMIC:@!#;");
        for (int i = 0; i < hierarchies.length; ++i) {
            String[] levels = hierarchies[i].split("#!@:HASH:@!#");
            String[] levelInfo = levels[0].split(":!@#COLON#@!:");
            String level1Info = levelInfo[1].toLowerCase();
            GenericDataType<ArrayObject> g = level1Info.contains("array") || level1Info.contains("map") ? new ArrayDataType(levelInfo[0], "", levelInfo[3]) : new StructDataType(levelInfo[0], "", levelInfo[3]);
            complexTypesMap.put(levelInfo[0], g);
            for (int j = 1; j < levels.length; ++j) {
                levelInfo = levels[j].split(":!@#COLON#@!:");
                String levelInfo1 = levelInfo[1].toLowerCase();
                if (levelInfo1.contains("array") || levelInfo1.contains("map")) {
                    g.addChildren(new ArrayDataType(levelInfo[0], levelInfo[2], levelInfo[3]));
                    continue;
                }
                if (levelInfo[1].toLowerCase().contains("struct")) {
                    g.addChildren(new StructDataType(levelInfo[0], levelInfo[2], levelInfo[3]));
                    continue;
                }
                g.addChildren(new PrimitiveDataType(levelInfo[0], DataTypeUtil.valueOf((String)levelInfo[1]), levelInfo[2], levelInfo[4], levelInfo[3].contains("true"), nullFormat, isEmptyBadRecord));
            }
        }
        return complexTypesMap;
    }

    public static boolean isHeaderValid(String tableName, String[] csvHeader, CarbonDataLoadSchema schema, List<String> ignoreColumns) {
        Iterator<String> columnIterator = CarbonDataProcessorUtil.getSchemaColumnNames(schema).iterator();
        HashSet csvColumns = new HashSet(csvHeader.length);
        Collections.addAll(csvColumns, csvHeader);
        while (columnIterator.hasNext()) {
            String column = columnIterator.next().toLowerCase();
            if (csvColumns.contains(column) || ignoreColumns.contains(column)) continue;
            return false;
        }
        return true;
    }

    public static Set<String> getSchemaColumnNames(CarbonDataLoadSchema schema) {
        HashSet<String> columnNames = new HashSet<String>(16);
        String factTableName = schema.getCarbonTable().getTableName();
        List dimensions = schema.getCarbonTable().getDimensionByTableName(factTableName);
        for (CarbonDimension dimension : dimensions) {
            columnNames.add(dimension.getColName());
        }
        List measures = schema.getCarbonTable().getMeasureByTableName(factTableName);
        for (CarbonMeasure msr : measures) {
            columnNames.add(msr.getColName());
        }
        return columnNames;
    }

    public static DataType[] getMeasureDataType(int measureCount, String databaseName, String tableName) {
        DataType[] type = new DataType[measureCount];
        for (int i = 0; i < type.length; ++i) {
            type[i] = DataTypes.DOUBLE;
        }
        CarbonTable carbonTable = CarbonMetadata.getInstance().getCarbonTable(databaseName, tableName);
        List measures = carbonTable.getMeasureByTableName(tableName);
        for (int i = 0; i < type.length; ++i) {
            type[i] = ((CarbonMeasure)measures.get(i)).getDataType();
        }
        return type;
    }

    public static DataType[] getNoDictDataTypes(String databaseName, String tableName) {
        CarbonTable carbonTable = CarbonMetadata.getInstance().getCarbonTable(databaseName, tableName);
        List dimensions = carbonTable.getDimensionByTableName(tableName);
        ArrayList<DataType> type = new ArrayList<DataType>();
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!((CarbonDimension)dimensions.get(i)).isSortColumn() || ((CarbonDimension)dimensions.get(i)).hasEncoding(Encoding.DICTIONARY)) continue;
            type.add(((CarbonDimension)dimensions.get(i)).getDataType());
        }
        return type.toArray(new DataType[type.size()]);
    }

    public static boolean[] getNoDictSortColMapping(String databaseName, String tableName) {
        CarbonTable carbonTable = CarbonMetadata.getInstance().getCarbonTable(databaseName, tableName);
        List dimensions = carbonTable.getDimensionByTableName(tableName);
        ArrayList<Boolean> noDicSortColMap = new ArrayList<Boolean>();
        for (int i = 0; i < dimensions.size(); ++i) {
            if (!((CarbonDimension)dimensions.get(i)).isSortColumn()) continue;
            if (!((CarbonDimension)dimensions.get(i)).hasEncoding(Encoding.DICTIONARY)) {
                noDicSortColMap.add(true);
                continue;
            }
            noDicSortColMap.add(false);
        }
        Boolean[] mapping = noDicSortColMap.toArray(new Boolean[noDicSortColMap.size()]);
        boolean[] noDicSortColMapping = new boolean[mapping.length];
        for (int i = 0; i < mapping.length; ++i) {
            noDicSortColMapping[i] = mapping[i];
        }
        return noDicSortColMapping;
    }

    public static Map<String, DataType[]> getNoDictSortAndNoSortDataTypes(String databaseName, String tableName) {
        CarbonTable carbonTable = CarbonMetadata.getInstance().getCarbonTable(databaseName, tableName);
        List dimensions = carbonTable.getDimensionByTableName(tableName);
        ArrayList<DataType> noDictSortType = new ArrayList<DataType>();
        ArrayList<DataType> noDictNoSortType = new ArrayList<DataType>();
        for (int i = 0; i < dimensions.size(); ++i) {
            if (((CarbonDimension)dimensions.get(i)).hasEncoding(Encoding.DICTIONARY)) continue;
            if (((CarbonDimension)dimensions.get(i)).isSortColumn()) {
                noDictSortType.add(((CarbonDimension)dimensions.get(i)).getDataType());
                continue;
            }
            noDictNoSortType.add(((CarbonDimension)dimensions.get(i)).getDataType());
        }
        DataType[] noDictSortTypes = noDictSortType.toArray(new DataType[noDictSortType.size()]);
        DataType[] noDictNoSortTypes = noDictNoSortType.toArray(new DataType[noDictNoSortType.size()]);
        HashMap<String, DataType[]> noDictSortAndNoSortTypes = new HashMap<String, DataType[]>(2);
        noDictSortAndNoSortTypes.put("noDictSortDataTypes", noDictSortTypes);
        noDictSortAndNoSortTypes.put("noDictNoSortDataTypes", noDictNoSortTypes);
        return noDictSortAndNoSortTypes;
    }

    public static String createCarbonStoreLocation(String databaseName, String tableName, String segmentId) {
        CarbonTable carbonTable = CarbonMetadata.getInstance().getCarbonTable(databaseName, tableName);
        return CarbonTablePath.getSegmentPath((String)carbonTable.getTablePath(), (String)segmentId);
    }

    public static DataType[] initDataType(CarbonTable carbonTable, String tableName, int measureCount) {
        DataType[] type = new DataType[measureCount];
        for (int i = 0; i < type.length; ++i) {
            type[i] = DataTypes.DOUBLE;
        }
        List measures = carbonTable.getMeasureByTableName(tableName);
        for (int i = 0; i < measureCount; ++i) {
            type[i] = ((CarbonMeasure)measures.get(i)).getDataType();
        }
        return type;
    }

    public static SortScopeOptions.SortScope getSortScope(CarbonDataLoadConfiguration configuration) {
        SortScopeOptions.SortScope sortScope;
        try {
            sortScope = configuration.getDataLoadProperty("carbon.load.sort.scope") == null ? SortScopeOptions.getSortScope(CarbonProperties.getInstance().getProperty("carbon.load.sort.scope", "LOCAL_SORT")) : SortScopeOptions.getSortScope(configuration.getDataLoadProperty("carbon.load.sort.scope").toString());
            LOGGER.info("sort scope is set to " + (Object)((Object)sortScope));
        }
        catch (Exception e) {
            sortScope = SortScopeOptions.getSortScope("LOCAL_SORT");
            LOGGER.warn("Exception occured while resolving sort scope. sort scope is set to " + (Object)((Object)sortScope));
        }
        return sortScope;
    }

    public static SortScopeOptions.SortScope getSortScope(String sortScopeString) {
        SortScopeOptions.SortScope sortScope;
        try {
            sortScope = sortScopeString == null ? SortScopeOptions.getSortScope(CarbonProperties.getInstance().getProperty("carbon.load.sort.scope", "LOCAL_SORT")) : SortScopeOptions.getSortScope(sortScopeString);
            LOGGER.info("sort scope is set to " + (Object)((Object)sortScope));
        }
        catch (Exception e) {
            sortScope = SortScopeOptions.getSortScope("LOCAL_SORT");
            LOGGER.warn("Exception occured while resolving sort scope. sort scope is set to " + (Object)((Object)sortScope));
        }
        return sortScope;
    }

    public static int getBatchSortSizeinMb(CarbonDataLoadConfiguration configuration) {
        int batchSortSizeInMb;
        try {
            batchSortSizeInMb = configuration.getDataLoadProperty("carbon.load.batch.sort.size.inmb") == null ? Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.load.batch.sort.size.inmb", "0")) : Integer.parseInt(configuration.getDataLoadProperty("carbon.load.batch.sort.size.inmb").toString());
            LOGGER.info("batch sort size is set to " + batchSortSizeInMb);
        }
        catch (Exception e) {
            batchSortSizeInMb = 0;
            LOGGER.warn("Exception occured while resolving batch sort size. batch sort size is set to " + batchSortSizeInMb);
        }
        return batchSortSizeInMb;
    }

    public static int getGlobalSortPartitions(Object globalSortPartitions) {
        int numPartitions;
        try {
            numPartitions = globalSortPartitions == null ? Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.load.global.sort.partitions", "0")) : Integer.parseInt(globalSortPartitions.toString());
        }
        catch (Exception e) {
            numPartitions = 0;
        }
        return numPartitions;
    }

    public static String prepareFailureReason(String columnName, DataType dataType) {
        return "The value with column name " + columnName + " and column data type " + dataType.getName() + " is not a valid " + dataType + " type.";
    }

    public static String[] arrayAppend(String[] inputArr, String ... append) {
        String[] outArr = new String[inputArr.length];
        StringBuffer sb = new StringBuffer();
        for (String str : append) {
            sb.append(str);
        }
        String appendStr = sb.toString();
        for (int i = 0; i < inputArr.length; ++i) {
            outArr[i] = inputArr[i] + appendStr;
        }
        return outArr;
    }

    public static String trimErrorMessage(String input) {
        String errorMessage = input;
        if (input != null) {
            if (input.split("Hint").length > 1) {
                errorMessage = input.split("Hint")[0];
            } else if (input.split("Parser Configuration:").length > 1) {
                errorMessage = input.split("Parser Configuration:")[0];
            }
        }
        return errorMessage;
    }

    public static boolean isRawDataRequired(CarbonDataLoadConfiguration configuration) {
        Object bad_records_action;
        boolean isRawDataRequired = Boolean.parseBoolean(configuration.getDataLoadProperty("BAD_RECORDS_LOGGER_ENABLE").toString());
        if (!isRawDataRequired && null != (bad_records_action = configuration.getDataLoadProperty("BAD_RECORDS_LOGGER_ACTION"))) {
            LoggerAction loggerAction = null;
            try {
                loggerAction = LoggerAction.valueOf((String)bad_records_action.toString().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                loggerAction = LoggerAction.FORCE;
            }
            isRawDataRequired = loggerAction == LoggerAction.REDIRECT;
        }
        return isRawDataRequired;
    }

    public static List<CarbonIterator<Object[]>>[] partitionInputReaderIterators(CarbonIterator<Object[]>[] inputIterators, short sdkWriterCores) {
        int i;
        int numberOfCores = sdkWriterCores > 0 ? sdkWriterCores : CarbonProperties.getInstance().getNumberOfCores();
        int parallelThreadNumber = Math.min(inputIterators.length, numberOfCores);
        if (parallelThreadNumber <= 0) {
            parallelThreadNumber = 1;
        }
        List[] iterators = new List[parallelThreadNumber];
        for (i = 0; i < parallelThreadNumber; ++i) {
            iterators[i] = new ArrayList();
        }
        for (i = 0; i < inputIterators.length; ++i) {
            iterators[i % parallelThreadNumber].add(inputIterators[i]);
        }
        return iterators;
    }
}

