/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.sort.sortdata;

import java.io.Serializable;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;

public class NewRowComparator
implements java.util.Comparator<Object[]>,
Serializable {
    private static final long serialVersionUID = -1739874611112709436L;
    private DataType[] noDicDataTypes;
    private boolean[] noDicSortColumnMapping;

    public NewRowComparator(boolean[] noDicSortColumnMapping, DataType[] noDicDataTypes) {
        this.noDicSortColumnMapping = noDicSortColumnMapping;
        this.noDicDataTypes = noDicDataTypes;
    }

    @Override
    public int compare(Object[] rowA, Object[] rowB) {
        int diff = 0;
        int index = 0;
        int dataTypeIdx = 0;
        int noDicSortIdx = 0;
        for (int i = 0; i < this.noDicSortColumnMapping.length; ++i) {
            if (this.noDicSortColumnMapping[noDicSortIdx++]) {
                if (DataTypeUtil.isPrimitiveColumn((DataType)this.noDicDataTypes[dataTypeIdx])) {
                    SerializableComparator comparator = Comparator.getComparator((DataType)this.noDicDataTypes[dataTypeIdx]);
                    int difference = comparator.compare(rowA[index], rowB[index]);
                    if (difference != 0) {
                        return difference;
                    }
                } else {
                    byte[] byteArr1 = (byte[])rowA[index];
                    byte[] byteArr2 = (byte[])rowB[index];
                    int difference = ByteUtil.UnsafeComparer.INSTANCE.compareTo(byteArr1, byteArr2);
                    if (difference != 0) {
                        return difference;
                    }
                }
                ++dataTypeIdx;
            } else {
                int dimFieldB;
                int dimFieldA = (Integer)rowA[index];
                diff = dimFieldA - (dimFieldB = ((Integer)rowB[index]).intValue());
                if (diff != 0) {
                    return diff;
                }
            }
            ++index;
        }
        return diff;
    }
}

