/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.merger;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.carbondata.common.exceptions.sql.MalformedCarbonCommandException;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.locks.ICarbonLock;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.mutate.DeleteDeltaBlockDetails;
import org.apache.carbondata.core.mutate.SegmentUpdateDetails;
import org.apache.carbondata.core.reader.CarbonDeleteFilesDataReader;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatus;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.core.writer.CarbonDeleteDeltaWriterImpl;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.CarbonDataMergerUtilResult;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.carbondata.processing.util.CarbonLoaderUtil;
import org.apache.commons.lang.StringUtils;

public final class CarbonDataMergerUtil {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonDataMergerUtil.class.getName());

    private CarbonDataMergerUtil() {
    }

    private static long getSizeOfFactFileInLoad(CarbonFile carbonFile) {
        CarbonFile[] factFile;
        long factSize = 0L;
        for (CarbonFile fact : factFile = carbonFile.listFiles(new CarbonFileFilter(){

            public boolean accept(CarbonFile file) {
                return CarbonTablePath.isCarbonDataFile((String)file.getName());
            }
        })) {
            factSize += fact.getSize();
        }
        return factSize;
    }

    public static boolean checkIfAutoLoadMergingRequired(CarbonTable carbonTable) {
        Map tblProps = carbonTable.getTableInfo().getFactTable().getTableProperties();
        String isLoadMergeEnabled = CarbonProperties.getInstance().getProperty("carbon.enable.auto.load.merge", "false");
        if (tblProps.containsKey("auto_load_merge")) {
            isLoadMergeEnabled = (String)tblProps.get("auto_load_merge");
        }
        return !isLoadMergeEnabled.equalsIgnoreCase("false");
    }

    public static String getMergedLoadName(List<LoadMetadataDetails> segmentsToBeMergedList) {
        String firstSegmentName = segmentsToBeMergedList.get(0).getLoadName();
        if (firstSegmentName.contains(".")) {
            String beforeDecimal = firstSegmentName.substring(0, firstSegmentName.indexOf("."));
            String afterDecimal = firstSegmentName.substring(firstSegmentName.indexOf(".") + 1);
            int fraction = Integer.parseInt(afterDecimal) + 1;
            String mergedSegmentName = beforeDecimal + "." + fraction;
            return "Segment_" + mergedSegmentName;
        }
        String mergeName = firstSegmentName + "." + 1;
        return "Segment_" + mergeName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateLoadMetadataIUDUpdateDeltaMergeStatus(List<LoadMetadataDetails> loadsToMerge, String metaDataFilepath, CarbonLoadModel carbonLoadModel, List<Segment> segmentFilesToBeUpdated) {
        boolean status = false;
        boolean updateLockStatus = false;
        boolean tableLockStatus = false;
        String timestamp = "" + carbonLoadModel.getFactTimeStamp();
        List updatedDeltaFilesList = null;
        AbsoluteTableIdentifier identifier = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().getAbsoluteTableIdentifier();
        SegmentUpdateStatusManager segmentUpdateStatusManager = new SegmentUpdateStatusManager(carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable());
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier);
        ICarbonLock updateLock = segmentUpdateStatusManager.getTableUpdateStatusLock();
        ICarbonLock statusLock = segmentStatusManager.getTableStatusLock();
        try {
            updatedDeltaFilesList = segmentUpdateStatusManager.getUpdateDeltaFiles(loadsToMerge.get(0).getLoadName());
        }
        catch (Exception e) {
            LOGGER.error("Error while getting the Update Delta Blocks.");
            status = false;
            return status;
        }
        if (updatedDeltaFilesList.size() > 0) {
            try {
                updateLockStatus = updateLock.lockWithRetries();
                tableLockStatus = statusLock.lockWithRetries();
                ArrayList<String> blockNames = new ArrayList<String>(updatedDeltaFilesList.size());
                for (Object compactedBlocks : updatedDeltaFilesList) {
                    int endIndex = ((String)compactedBlocks).lastIndexOf(File.separator);
                    String blkNoExt = ((String)compactedBlocks).substring(endIndex + 1, ((String)compactedBlocks).lastIndexOf("-"));
                    blockNames.add(blkNoExt);
                }
                if (updateLockStatus && tableLockStatus) {
                    LoadMetadataDetails[] loadDetails;
                    SegmentUpdateDetails[] updateLists = segmentUpdateStatusManager.readLoadMetadata();
                    for (String compactedBlocks : blockNames) {
                        for (int i = 0; i < updateLists.length; ++i) {
                            if (!updateLists[i].getBlockName().equalsIgnoreCase(compactedBlocks) || updateLists[i].getSegmentStatus() == SegmentStatus.COMPACTED || updateLists[i].getSegmentStatus() == SegmentStatus.MARKED_FOR_DELETE) continue;
                            updateLists[i].setSegmentStatus(SegmentStatus.COMPACTED);
                        }
                    }
                    for (LoadMetadataDetails loadDetail : loadDetails = SegmentStatusManager.readLoadMetadata((String)metaDataFilepath)) {
                        int segmentFileIndex;
                        if (!loadsToMerge.contains(loadDetail)) continue;
                        loadDetail.setUpdateDeltaStartTimestamp(timestamp);
                        loadDetail.setUpdateDeltaEndTimestamp(timestamp);
                        if (loadDetail.getLoadName().equalsIgnoreCase("0")) {
                            loadDetail.setUpdateStatusFileName(CarbonUpdateUtil.getUpdateStatusFileName((String)timestamp));
                        }
                        if ((segmentFileIndex = segmentFilesToBeUpdated.indexOf(Segment.toSegment((String)loadDetail.getLoadName(), null))) <= -1) continue;
                        loadDetail.setSegmentFile(segmentFilesToBeUpdated.get(segmentFileIndex).getSegmentFileName());
                    }
                    segmentUpdateStatusManager.writeLoadDetailsIntoFile(Arrays.asList(updateLists), timestamp);
                    SegmentStatusManager.writeLoadDetailsIntoFile((String)CarbonTablePath.getTableStatusFilePath((String)identifier.getTablePath()), (LoadMetadataDetails[])loadDetails);
                    status = true;
                } else {
                    LOGGER.error("Not able to acquire the lock.");
                    status = false;
                }
            }
            catch (IOException e) {
                LOGGER.error("Error while updating metadata. The metadata file path is " + CarbonTablePath.getMetadataPath((String)identifier.getTablePath()));
                status = false;
            }
            finally {
                if (updateLockStatus) {
                    if (updateLock.unlock()) {
                        LOGGER.info("Unlock the segment update lock successfully.");
                    } else {
                        LOGGER.error("Not able to unlock the segment update lock.");
                    }
                }
                if (tableLockStatus) {
                    if (statusLock.unlock()) {
                        LOGGER.info("Unlock the table status lock successfully.");
                    } else {
                        LOGGER.error("Not able to unlock the table status lock.");
                    }
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateLoadMetadataWithMergeStatus(List<LoadMetadataDetails> loadsToMerge, String metaDataFilepath, String mergedLoadNumber, CarbonLoadModel carbonLoadModel, CompactionType compactionType, String segmentFile) throws IOException {
        boolean tableStatusUpdationStatus = false;
        AbsoluteTableIdentifier identifier = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().getAbsoluteTableIdentifier();
        SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier);
        ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
        try {
            if (carbonLock.lockWithRetries()) {
                LOGGER.info("Acquired lock for the table " + carbonLoadModel.getDatabaseName() + "." + carbonLoadModel.getTableName() + " for table status updation ");
                String statusFilePath = CarbonTablePath.getTableStatusFilePath((String)identifier.getTablePath());
                LoadMetadataDetails[] loadDetails = SegmentStatusManager.readLoadMetadata((String)metaDataFilepath);
                long modificationOrDeletionTimeStamp = CarbonUpdateUtil.readCurrentTime();
                for (LoadMetadataDetails loadDetail : loadDetails) {
                    if (!loadsToMerge.contains(loadDetail)) continue;
                    if (loadDetail.getSegmentStatus() == SegmentStatus.MARKED_FOR_DELETE) {
                        LOGGER.error("Compaction is aborted as the segment " + loadDetail.getLoadName() + " is deleted after the compaction is started.");
                        boolean bl = false;
                        return bl;
                    }
                    loadDetail.setSegmentStatus(SegmentStatus.COMPACTED);
                    loadDetail.setModificationOrdeletionTimesStamp(modificationOrDeletionTimeStamp);
                    loadDetail.setMergedLoadName(mergedLoadNumber);
                }
                LoadMetadataDetails loadMetadataDetails = new LoadMetadataDetails();
                loadMetadataDetails.setPartitionCount("0");
                loadMetadataDetails.setSegmentStatus(SegmentStatus.SUCCESS);
                long loadEnddate = CarbonUpdateUtil.readCurrentTime();
                loadMetadataDetails.setLoadEndTime(loadEnddate);
                CarbonTable carbonTable = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable();
                loadMetadataDetails.setLoadName(mergedLoadNumber);
                loadMetadataDetails.setSegmentFile(segmentFile);
                CarbonLoaderUtil.addDataIndexSizeIntoMetaEntry(loadMetadataDetails, mergedLoadNumber, carbonTable);
                loadMetadataDetails.setLoadStartTime(carbonLoadModel.getFactTimeStamp());
                loadMetadataDetails.setPartitionCount("0");
                if (CompactionType.MAJOR == compactionType) {
                    loadMetadataDetails.setMajorCompacted("true");
                }
                ArrayList<LoadMetadataDetails> updatedDetailsList = new ArrayList<LoadMetadataDetails>(Arrays.asList(loadDetails));
                updatedDetailsList.add(loadMetadataDetails);
                try {
                    SegmentStatusManager.writeLoadDetailsIntoFile((String)statusFilePath, (LoadMetadataDetails[])updatedDetailsList.toArray(new LoadMetadataDetails[updatedDetailsList.size()]));
                    tableStatusUpdationStatus = true;
                }
                catch (IOException e) {
                    LOGGER.error("Error while writing metadata");
                    tableStatusUpdationStatus = false;
                }
            } else {
                LOGGER.error("Could not able to obtain lock for table" + carbonLoadModel.getDatabaseName() + "." + carbonLoadModel.getTableName() + "for table status updation");
            }
        }
        finally {
            if (carbonLock.unlock()) {
                LOGGER.info("Table unlocked successfully after table status updation" + carbonLoadModel.getDatabaseName() + "." + carbonLoadModel.getTableName());
            } else {
                LOGGER.error("Unable to unlock Table lock for table" + carbonLoadModel.getDatabaseName() + "." + carbonLoadModel.getTableName() + " during table status updation");
            }
        }
        return tableStatusUpdationStatus;
    }

    public static String getLoadNumberFromLoadName(String loadName) {
        return loadName.substring(loadName.lastIndexOf("Segment_") + "Segment_".length(), loadName.length());
    }

    public static List<LoadMetadataDetails> identifySegmentsToBeMerged(CarbonLoadModel carbonLoadModel, long compactionSize, List<LoadMetadataDetails> segments, CompactionType compactionType, List<String> customSegmentIds) throws IOException, MalformedCarbonCommandException {
        Map tableLevelProperties = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().getTableInfo().getFactTable().getTableProperties();
        ArrayList<LoadMetadataDetails> sortedSegments = new ArrayList<LoadMetadataDetails>(segments);
        CarbonDataMergerUtil.sortSegments(sortedSegments);
        if (CompactionType.CUSTOM == compactionType) {
            return CarbonDataMergerUtil.identitySegmentsToBeMergedBasedOnSpecifiedSegments(sortedSegments, new LinkedHashSet<String>(customSegmentIds));
        }
        if (CompactionType.IUD_UPDDEL_DELTA == compactionType) {
            return CarbonDataMergerUtil.identifySegmentsToBeMergedBasedOnIUD(sortedSegments, carbonLoadModel);
        }
        List<LoadMetadataDetails> listOfSegmentsAfterPreserve = CarbonDataMergerUtil.checkPreserveSegmentsPropertyReturnRemaining(sortedSegments, tableLevelProperties);
        List<LoadMetadataDetails> listOfSegmentsLoadedInSameDateInterval = CarbonDataMergerUtil.identifySegmentsToBeMergedBasedOnLoadedDate(listOfSegmentsAfterPreserve, tableLevelProperties);
        List<LoadMetadataDetails> listOfSegmentsToBeMerged = CompactionType.MAJOR == compactionType ? CarbonDataMergerUtil.identifySegmentsToBeMergedBasedOnSize(compactionSize, listOfSegmentsLoadedInSameDateInterval, carbonLoadModel) : CarbonDataMergerUtil.identifySegmentsToBeMergedBasedOnSegCount(listOfSegmentsLoadedInSameDateInterval, tableLevelProperties);
        return listOfSegmentsToBeMerged;
    }

    public static void sortSegments(List segments) {
        Collections.sort(segments, new Comparator<LoadMetadataDetails>(){

            @Override
            public int compare(LoadMetadataDetails seg1, LoadMetadataDetails seg2) {
                double seg1Id = Double.parseDouble(seg1.getLoadName());
                double seg2Id = Double.parseDouble(seg2.getLoadName());
                return Double.compare(seg1Id, seg2Id);
            }
        });
    }

    private static List<LoadMetadataDetails> identitySegmentsToBeMergedBasedOnSpecifiedSegments(List<LoadMetadataDetails> listOfSegments, Set<String> segmentIds) throws MalformedCarbonCommandException {
        LinkedHashMap<String, LoadMetadataDetails> specifiedSegments = new LinkedHashMap<String, LoadMetadataDetails>(16);
        for (LoadMetadataDetails detail : listOfSegments) {
            if (!segmentIds.contains(detail.getLoadName())) continue;
            specifiedSegments.put(detail.getLoadName(), detail);
        }
        for (String segmentId : segmentIds) {
            if (specifiedSegments.containsKey(segmentId) && CarbonDataMergerUtil.isSegmentValid((LoadMetadataDetails)specifiedSegments.get(segmentId))) continue;
            String errMsg = String.format("Segment %s does not exist or is not valid", segmentId);
            LOGGER.error(errMsg);
            throw new MalformedCarbonCommandException(errMsg);
        }
        return new ArrayList<LoadMetadataDetails>(specifiedSegments.values());
    }

    private static List<LoadMetadataDetails> identifySegmentsToBeMergedBasedOnLoadedDate(List<LoadMetadataDetails> listOfSegmentsBelowThresholdSize, Map<String, String> tblProps) {
        ArrayList<LoadMetadataDetails> loadsOfSameDate = new ArrayList<LoadMetadataDetails>(16);
        long numberOfDaysAllowedToMerge = 0L;
        try {
            numberOfDaysAllowedToMerge = Long.parseLong(CarbonProperties.getInstance().getProperty("carbon.allowed.compaction.days", "0"));
            if (tblProps.containsKey("allowed_compaction_days")) {
                numberOfDaysAllowedToMerge = Long.parseLong(tblProps.get("allowed_compaction_days"));
            }
            if (numberOfDaysAllowedToMerge < 0L || numberOfDaysAllowedToMerge > 100L) {
                LOGGER.error("The specified value for property carbon.allowed.compaction.days is incorrect. Correct value should be in range of 0 -100. Taking the default value.");
                numberOfDaysAllowedToMerge = Long.parseLong("0");
            }
        }
        catch (NumberFormatException e) {
            numberOfDaysAllowedToMerge = Long.parseLong("0");
        }
        if (numberOfDaysAllowedToMerge > 0L) {
            boolean first = true;
            Date segDate1 = null;
            SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
            for (LoadMetadataDetails segment : listOfSegmentsBelowThresholdSize) {
                if (segment.getSegmentStatus() == SegmentStatus.STREAMING || segment.getSegmentStatus() == SegmentStatus.STREAMING_FINISH) continue;
                if (first) {
                    segDate1 = CarbonDataMergerUtil.initializeFirstSegment(loadsOfSameDate, segment, sdf);
                    first = false;
                    continue;
                }
                long segmentDate = segment.getLoadStartTime();
                Date segDate2 = null;
                try {
                    segDate2 = sdf.parse(sdf.format(segmentDate));
                }
                catch (ParseException e) {
                    LOGGER.error("Error while parsing segment start time" + e.getMessage());
                }
                if (CarbonDataMergerUtil.isTwoDatesPresentInRequiredRange(segDate1, segDate2, numberOfDaysAllowedToMerge)) {
                    loadsOfSameDate.add(segment);
                    continue;
                }
                if (loadsOfSameDate.size() < 2) {
                    loadsOfSameDate.clear();
                    segDate1 = CarbonDataMergerUtil.initializeFirstSegment(loadsOfSameDate, segment, sdf);
                    continue;
                }
                break;
            }
        } else {
            for (LoadMetadataDetails segment : listOfSegmentsBelowThresholdSize) {
                if (segment.getSegmentStatus() == SegmentStatus.STREAMING || segment.getSegmentStatus() == SegmentStatus.STREAMING_FINISH) continue;
                loadsOfSameDate.add(segment);
            }
        }
        return loadsOfSameDate;
    }

    private static Date initializeFirstSegment(List<LoadMetadataDetails> loadsOfSameDate, LoadMetadataDetails segment, SimpleDateFormat sdf) {
        long baselineLoadStartTime = segment.getLoadStartTime();
        Date segDate1 = null;
        try {
            segDate1 = sdf.parse(sdf.format(baselineLoadStartTime));
        }
        catch (ParseException e) {
            LOGGER.error("Error while parsing segment start time" + e.getMessage());
        }
        loadsOfSameDate.add(segment);
        return segDate1;
    }

    private static boolean isTwoDatesPresentInRequiredRange(Date segDate1, Date segDate2, long numberOfDaysAllowedToMerge) {
        if (segDate1 == null || segDate2 == null) {
            return false;
        }
        Calendar cal1 = Calendar.getInstance();
        cal1.set(segDate1.getYear(), segDate1.getMonth(), segDate1.getDate());
        Calendar cal2 = Calendar.getInstance();
        cal2.set(segDate2.getYear(), segDate2.getMonth(), segDate2.getDate());
        long diff = cal2.getTimeInMillis() - cal1.getTimeInMillis();
        return diff / 86400000L < numberOfDaysAllowedToMerge;
    }

    private static List<LoadMetadataDetails> identifySegmentsToBeMergedBasedOnSize(long compactionSize, List<LoadMetadataDetails> listOfSegmentsAfterPreserve, CarbonLoadModel carbonLoadModel) throws IOException {
        ArrayList<Object> segmentsToBeMerged = new ArrayList<LoadMetadataDetails>(16);
        CarbonTable carbonTable = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable();
        long totalLength = 0L;
        for (LoadMetadataDetails segment : listOfSegmentsAfterPreserve) {
            if (segment.getSegmentStatus() == SegmentStatus.STREAMING || segment.getSegmentStatus() == SegmentStatus.STREAMING_FINISH) continue;
            String segId = segment.getLoadName();
            long sizeOfOneSegmentAcrossPartition = segment.getSegmentFile() != null ? (!StringUtils.isEmpty((String)segment.getDataSize()) ? Long.parseLong(segment.getDataSize()) : CarbonUtil.getSizeOfSegment((String)carbonTable.getTablePath(), (Segment)new Segment(segId, segment.getSegmentFile()))) : CarbonDataMergerUtil.getSizeOfSegment(carbonTable.getTablePath(), segId);
            if (sizeOfOneSegmentAcrossPartition > compactionSize * 1024L * 1024L) {
                if (segmentsToBeMerged.size() > 1) break;
                segmentsToBeMerged = new ArrayList(16);
                totalLength = 0L;
                continue;
            }
            if ((totalLength += sizeOfOneSegmentAcrossPartition) < compactionSize * 1024L * 1024L) {
                segmentsToBeMerged.add(segment);
                continue;
            }
            if (segmentsToBeMerged.size() > 1) break;
            segmentsToBeMerged = new ArrayList(16);
            segmentsToBeMerged.add(segment);
            totalLength = sizeOfOneSegmentAcrossPartition;
        }
        return segmentsToBeMerged;
    }

    private static long getSizeOfSegment(String tablePath, String segId) {
        String loadPath = CarbonTablePath.getSegmentPath((String)tablePath, (String)segId);
        CarbonFile segmentFolder = FileFactory.getCarbonFile((String)loadPath, (FileFactory.FileType)FileFactory.getFileType((String)loadPath));
        return CarbonDataMergerUtil.getSizeOfFactFileInLoad(segmentFolder);
    }

    private static List<LoadMetadataDetails> identifySegmentsToBeMergedBasedOnSegCount(List<LoadMetadataDetails> listOfSegmentsAfterPreserve, Map<String, String> tblProps) {
        ArrayList<LoadMetadataDetails> mergedSegments = new ArrayList<LoadMetadataDetails>(16);
        ArrayList<LoadMetadataDetails> unMergedSegments = new ArrayList<LoadMetadataDetails>(16);
        int[] noOfSegmentLevelsCount = CarbonProperties.getInstance().getCompactionSegmentLevelCount();
        if (tblProps.containsKey("compaction_level_threshold") && 0 == (noOfSegmentLevelsCount = CarbonProperties.getInstance().getIntArray(tblProps.get("compaction_level_threshold"))).length) {
            noOfSegmentLevelsCount = CarbonProperties.getInstance().getCompactionSegmentLevelCount();
        }
        int level1Size = 0;
        int level2Size = 0;
        int size = noOfSegmentLevelsCount.length;
        if (size >= 2) {
            level1Size = noOfSegmentLevelsCount[0];
            level2Size = noOfSegmentLevelsCount[1];
            level2Size = level2Size == 1 ? 0 : level2Size;
        } else if (size == 1) {
            level1Size = noOfSegmentLevelsCount[0];
        }
        int unMergeCounter = 0;
        int mergeCounter = 0;
        for (LoadMetadataDetails segment : listOfSegmentsAfterPreserve) {
            String segName;
            if (segment.getSegmentStatus() == SegmentStatus.STREAMING || segment.getSegmentStatus() == SegmentStatus.STREAMING_FINISH || (segName = segment.getLoadName()).endsWith(".2") || segment.isMajorCompacted() != null && segment.isMajorCompacted().equalsIgnoreCase("true")) continue;
            if (!CarbonDataMergerUtil.isMergedSegment(segName)) {
                unMergedSegments.add(segment);
                if (++unMergeCounter != level1Size) continue;
                return unMergedSegments;
            }
            mergedSegments.add(segment);
            if (++mergeCounter != level2Size) continue;
            return mergedSegments;
        }
        return new ArrayList<LoadMetadataDetails>(0);
    }

    private static boolean isMergedSegment(String segName) {
        return segName.contains(".");
    }

    private static List<LoadMetadataDetails> checkPreserveSegmentsPropertyReturnRemaining(List<LoadMetadataDetails> segments, Map<String, String> tblProps) {
        int numberOfSegmentsToBePreserved = CarbonProperties.getInstance().getNumberOfSegmentsToBePreserved();
        if (tblProps.containsKey("compaction_preserve_segments")) {
            numberOfSegmentsToBePreserved = Integer.parseInt(tblProps.get("compaction_preserve_segments"));
        }
        return CarbonDataMergerUtil.getValidLoadDetailsWithRetaining(segments, numberOfSegmentsToBePreserved);
    }

    private static List<LoadMetadataDetails> getValidLoadDetailsWithRetaining(List<LoadMetadataDetails> loadMetadataDetails, int numberOfSegToBeRetained) {
        ArrayList<LoadMetadataDetails> validList = new ArrayList<LoadMetadataDetails>(16);
        for (LoadMetadataDetails segment : loadMetadataDetails) {
            if (!CarbonDataMergerUtil.isSegmentValid(segment)) continue;
            validList.add(segment);
        }
        int removingIndex = validList.size() - 1;
        for (int i = validList.size(); i > 0 && numberOfSegToBeRetained != 0; --numberOfSegToBeRetained, --i) {
            validList.remove(removingIndex--);
        }
        return validList;
    }

    public static long getCompactionSize(CompactionType compactionType, CarbonLoadModel carbonLoadModel) {
        long compactionSize = 0L;
        switch (compactionType) {
            case MAJOR: {
                compactionSize = CarbonProperties.getInstance().getMajorCompactionSize();
                Map tblProps = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().getTableInfo().getFactTable().getTableProperties();
                if (!tblProps.containsKey("major_compaction_size")) break;
                compactionSize = Long.parseLong((String)tblProps.get("major_compaction_size"));
                break;
            }
        }
        return compactionSize;
    }

    public static List<Segment> getValidSegments(List<LoadMetadataDetails> loadMetadataDetails) {
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (LoadMetadataDetails segment : loadMetadataDetails) {
            if (null != segment.getMergedLoadName()) {
                segments.add(Segment.toSegment((String)segment.getMergedLoadName(), null));
                continue;
            }
            segments.add(Segment.toSegment((String)segment.getLoadName(), null));
        }
        return segments;
    }

    public static List<Segment> getValidSegmentList(AbsoluteTableIdentifier absoluteTableIdentifier) throws IOException {
        SegmentStatusManager.ValidAndInvalidSegmentsInfo validAndInvalidSegments = null;
        try {
            validAndInvalidSegments = new SegmentStatusManager(absoluteTableIdentifier).getValidAndInvalidSegments();
        }
        catch (IOException e) {
            LOGGER.error("Error while getting valid segment list for a table identifier");
            throw new IOException();
        }
        return validAndInvalidSegments.getValidSegments();
    }

    public static List<LoadMetadataDetails> filterOutNewlyAddedSegments(List<LoadMetadataDetails> segments, LoadMetadataDetails lastSeg) {
        ArrayList<LoadMetadataDetails> list = new ArrayList<LoadMetadataDetails>(segments);
        CarbonDataMergerUtil.sortSegments(list);
        return list.subList(0, list.indexOf(lastSeg) + 1);
    }

    private static List<LoadMetadataDetails> identifySegmentsToBeMergedBasedOnIUD(List<LoadMetadataDetails> segments, CarbonLoadModel carbonLoadModel) {
        ArrayList<LoadMetadataDetails> validSegments = new ArrayList<LoadMetadataDetails>(segments.size());
        AbsoluteTableIdentifier absoluteTableIdentifier = carbonLoadModel.getCarbonDataLoadSchema().getCarbonTable().getAbsoluteTableIdentifier();
        int numberUpdateDeltaFilesThreshold = CarbonProperties.getInstance().getNoUpdateDeltaFilesThresholdForIUDCompaction();
        for (LoadMetadataDetails seg : segments) {
            if (!CarbonDataMergerUtil.isSegmentValid(seg) || !CarbonDataMergerUtil.checkUpdateDeltaFilesInSeg(new Segment(seg.getLoadName(), seg.getSegmentFile()), absoluteTableIdentifier, carbonLoadModel.getSegmentUpdateStatusManager(), numberUpdateDeltaFilesThreshold).booleanValue()) continue;
            validSegments.add(seg);
        }
        return validSegments;
    }

    private static boolean isSegmentValid(LoadMetadataDetails seg) {
        return seg.getSegmentStatus() == SegmentStatus.SUCCESS || seg.getSegmentStatus() == SegmentStatus.LOAD_PARTIAL_SUCCESS || seg.getSegmentStatus() == SegmentStatus.MARKED_FOR_UPDATE;
    }

    public static List<String> getSegListIUDCompactionQualified(List<Segment> segments, AbsoluteTableIdentifier absoluteTableIdentifier, SegmentUpdateStatusManager segmentUpdateStatusManager, CompactionType compactionTypeIUD) {
        ArrayList<String> validSegments;
        block5: {
            block4: {
                validSegments = new ArrayList<String>();
                if (CompactionType.IUD_DELETE_DELTA != compactionTypeIUD) break block4;
                int numberDeleteDeltaFilesThreshold = CarbonProperties.getInstance().getNoDeleteDeltaFilesThresholdForIUDCompaction();
                ArrayList<Segment> deleteSegments = new ArrayList<Segment>();
                for (Segment seg : segments) {
                    if (!CarbonDataMergerUtil.checkDeleteDeltaFilesInSeg(seg, segmentUpdateStatusManager, numberDeleteDeltaFilesThreshold)) continue;
                    deleteSegments.add(seg);
                }
                if (deleteSegments.size() <= 0) break block5;
                for (Segment segName : deleteSegments) {
                    List<String> tempSegments = CarbonDataMergerUtil.getDeleteDeltaFilesInSeg(segName, segmentUpdateStatusManager, numberDeleteDeltaFilesThreshold);
                    validSegments.addAll(tempSegments);
                }
                break block5;
            }
            if (CompactionType.IUD_UPDDEL_DELTA == compactionTypeIUD) {
                int numberUpdateDeltaFilesThreshold = CarbonProperties.getInstance().getNoUpdateDeltaFilesThresholdForIUDCompaction();
                for (Segment seg : segments) {
                    if (!CarbonDataMergerUtil.checkUpdateDeltaFilesInSeg(seg, absoluteTableIdentifier, segmentUpdateStatusManager, numberUpdateDeltaFilesThreshold).booleanValue()) continue;
                    validSegments.add(seg.getSegmentNo());
                }
            }
        }
        return validSegments;
    }

    public static Boolean checkUpdateDeltaMatchBlock(String seg, String blkName, SegmentUpdateStatusManager segmentUpdateStatusManager) {
        List list = segmentUpdateStatusManager.getUpdateDeltaFiles(seg);
        String[] FileParts = blkName.split("/");
        String blockName = FileParts[FileParts.length - 1];
        for (String str : list) {
            if (!str.contains(blockName)) continue;
            return true;
        }
        return false;
    }

    private static Boolean checkUpdateDeltaFilesInSeg(Segment seg, AbsoluteTableIdentifier identifier, SegmentUpdateStatusManager segmentUpdateStatusManager, int numberDeltaFilesThreshold) {
        CarbonFile[] updateDeltaFiles = null;
        HashSet<String> uniqueBlocks = new HashSet<String>();
        String segmentPath = CarbonTablePath.getSegmentPath((String)identifier.getTablePath(), (String)seg.getSegmentNo());
        CarbonFile segDir = FileFactory.getCarbonFile((String)segmentPath, (FileFactory.FileType)FileFactory.getFileType((String)segmentPath));
        CarbonFile[] allSegmentFiles = segDir.listFiles();
        updateDeltaFiles = segmentUpdateStatusManager.getUpdateDeltaFilesForSegment(seg.getSegmentNo(), true, ".carbondata", false, allSegmentFiles);
        if (updateDeltaFiles == null) {
            return false;
        }
        for (CarbonFile blocks : updateDeltaFiles) {
            String task = CarbonTablePath.DataFileUtil.getTaskNo((String)blocks.getName());
            String timestamp = CarbonTablePath.DataFileUtil.getTimeStampFromDeleteDeltaFile((String)blocks.getName());
            String taskAndTimeStamp = task + "-" + timestamp;
            uniqueBlocks.add(taskAndTimeStamp);
        }
        if (uniqueBlocks.size() > numberDeltaFilesThreshold) {
            return true;
        }
        return false;
    }

    private static boolean checkDeleteDeltaFilesInSeg(Segment seg, SegmentUpdateStatusManager segmentUpdateStatusManager, int numberDeltaFilesThreshold) {
        HashSet<String> uniqueBlocks = new HashSet<String>();
        List blockNameList = segmentUpdateStatusManager.getBlockNameFromSegment(seg.getSegmentNo());
        for (String blockName : blockNameList) {
            CarbonFile[] deleteDeltaFiles = segmentUpdateStatusManager.getDeleteDeltaFilesList(seg, blockName);
            if (null == deleteDeltaFiles) continue;
            for (CarbonFile blocks : deleteDeltaFiles) {
                String task = CarbonTablePath.DataFileUtil.getTaskNo((String)blocks.getName());
                String timestamp = CarbonTablePath.DataFileUtil.getTimeStampFromDeleteDeltaFile((String)blocks.getName());
                String taskAndTimeStamp = task + "-" + timestamp;
                uniqueBlocks.add(taskAndTimeStamp);
            }
            if (uniqueBlocks.size() <= numberDeltaFilesThreshold) continue;
            return true;
        }
        return false;
    }

    private static List<String> getDeleteDeltaFilesInSeg(Segment seg, SegmentUpdateStatusManager segmentUpdateStatusManager, int numberDeltaFilesThreshold) {
        ArrayList<String> blockLists = new ArrayList<String>();
        List blockNameList = segmentUpdateStatusManager.getBlockNameFromSegment(seg.getSegmentNo());
        for (String blockName : blockNameList) {
            CarbonFile[] deleteDeltaFiles = segmentUpdateStatusManager.getDeleteDeltaFilesList(seg, blockName);
            if (null == deleteDeltaFiles || deleteDeltaFiles.length <= numberDeltaFilesThreshold) continue;
            blockLists.add(seg.getSegmentNo() + "/" + blockName);
        }
        return blockLists;
    }

    public static boolean isHorizontalCompactionEnabled() {
        return CarbonProperties.getInstance().getProperty("carbon.horizontal.compaction.enable", "true").equalsIgnoreCase("true");
    }

    public static List<CarbonDataMergerUtilResult> compactBlockDeleteDeltaFiles(String seg, String blockName, CarbonTable table, SegmentUpdateDetails[] segmentUpdateDetails, Long timestamp) throws IOException {
        SegmentUpdateStatusManager segmentUpdateStatusManager = new SegmentUpdateStatusManager(table);
        ArrayList<CarbonDataMergerUtilResult> resultList = new ArrayList<CarbonDataMergerUtilResult>(1);
        segmentUpdateStatusManager.setUpdateStatusDetails(segmentUpdateDetails);
        CarbonFile[] deleteDeltaFiles = segmentUpdateStatusManager.getDeleteDeltaFilesList(new Segment(seg), blockName);
        String destFileName = blockName + "-" + timestamp.toString() + ".deletedelta";
        ArrayList<String> deleteFilePathList = new ArrayList<String>();
        if (null != deleteDeltaFiles && deleteDeltaFiles.length > 0 && null != deleteDeltaFiles[0].getParentFile()) {
            String fullBlockFilePath = deleteDeltaFiles[0].getParentFile().getCanonicalPath() + "/" + destFileName;
            for (CarbonFile cFile : deleteDeltaFiles) {
                deleteFilePathList.add(cFile.getCanonicalPath());
            }
            CarbonDataMergerUtilResult blockDetails = new CarbonDataMergerUtilResult();
            blockDetails.setBlockName(blockName);
            blockDetails.setSegmentName(seg);
            blockDetails.setDeleteDeltaStartTimestamp(timestamp.toString());
            blockDetails.setDeleteDeltaEndTimestamp(timestamp.toString());
            try {
                CarbonDataMergerUtil.startCompactionDeleteDeltaFiles(deleteFilePathList, blockName, fullBlockFilePath);
                blockDetails.setCompactionStatus(true);
                resultList.add(blockDetails);
            }
            catch (IOException e) {
                LOGGER.error("Compaction of Delete Delta Files failed. The complete file path is " + fullBlockFilePath);
                throw new IOException();
            }
        }
        return resultList;
    }

    public static void startCompactionDeleteDeltaFiles(List<String> deleteDeltaFiles, String blockName, String fullBlockFilePath) throws IOException {
        DeleteDeltaBlockDetails deleteDeltaBlockDetails = null;
        CarbonDeleteFilesDataReader dataReader = new CarbonDeleteFilesDataReader();
        try {
            deleteDeltaBlockDetails = dataReader.getCompactedDeleteDeltaFileFromBlock(deleteDeltaFiles, blockName);
        }
        catch (Exception e) {
            String blockFilePath = fullBlockFilePath.substring(0, fullBlockFilePath.lastIndexOf("/"));
            LOGGER.error("Error while getting the delete delta blocks in path " + blockFilePath);
            throw new IOException();
        }
        CarbonDeleteDeltaWriterImpl carbonDeleteWriter = new CarbonDeleteDeltaWriterImpl(fullBlockFilePath, FileFactory.getFileType((String)fullBlockFilePath));
        try {
            carbonDeleteWriter.write(deleteDeltaBlockDetails);
        }
        catch (IOException e) {
            LOGGER.error("Error while writing compacted delete delta file " + fullBlockFilePath);
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean updateStatusFile(List<CarbonDataMergerUtilResult> updateDataMergerDetailsList, CarbonTable table, String timestamp, SegmentUpdateStatusManager segmentUpdateStatusManager) {
        block17: {
            ArrayList<SegmentUpdateDetails> segmentUpdateDetails = new ArrayList<SegmentUpdateDetails>(updateDataMergerDetailsList.size());
            for (CarbonDataMergerUtilResult carbonDataMergerUtilResult : updateDataMergerDetailsList) {
                if (carbonDataMergerUtilResult.getCompactionStatus()) {
                    SegmentUpdateDetails tempSegmentUpdateDetails = new SegmentUpdateDetails();
                    tempSegmentUpdateDetails.setSegmentName(carbonDataMergerUtilResult.getSegmentName());
                    tempSegmentUpdateDetails.setBlockName(carbonDataMergerUtilResult.getBlockName());
                    for (SegmentUpdateDetails origDetails : segmentUpdateStatusManager.getUpdateStatusDetails()) {
                        if (!origDetails.getBlockName().equalsIgnoreCase(carbonDataMergerUtilResult.getBlockName()) || !origDetails.getSegmentName().equalsIgnoreCase(carbonDataMergerUtilResult.getSegmentName())) continue;
                        tempSegmentUpdateDetails.setDeletedRowsInBlock(origDetails.getDeletedRowsInBlock());
                        tempSegmentUpdateDetails.setSegmentStatus(origDetails.getSegmentStatus());
                        break;
                    }
                    tempSegmentUpdateDetails.setDeleteDeltaStartTimestamp(carbonDataMergerUtilResult.getDeleteDeltaStartTimestamp());
                    tempSegmentUpdateDetails.setDeleteDeltaEndTimestamp(carbonDataMergerUtilResult.getDeleteDeltaEndTimestamp());
                    segmentUpdateDetails.add(tempSegmentUpdateDetails);
                    continue;
                }
                return false;
            }
            CarbonUpdateUtil.updateSegmentStatus(segmentUpdateDetails, (CarbonTable)table, (String)timestamp, (boolean)true);
            String metaDataFilepath = table.getMetadataPath();
            AbsoluteTableIdentifier identifier = table.getAbsoluteTableIdentifier();
            String tableStatusPath = CarbonTablePath.getTableStatusFilePath((String)identifier.getTablePath());
            SegmentStatusManager segmentStatusManager = new SegmentStatusManager(identifier);
            ICarbonLock carbonLock = segmentStatusManager.getTableStatusLock();
            boolean lockStatus = false;
            try {
                lockStatus = carbonLock.lockWithRetries();
                if (lockStatus) {
                    LoadMetadataDetails[] listOfLoadFolderDetailsArray;
                    LOGGER.info("Acquired lock for table" + table.getDatabaseName() + "." + table.getTableName() + " for table status updation");
                    for (LoadMetadataDetails loadMetadata : listOfLoadFolderDetailsArray = SegmentStatusManager.readLoadMetadata((String)metaDataFilepath)) {
                        if (!loadMetadata.getLoadName().equalsIgnoreCase("0")) continue;
                        loadMetadata.setUpdateStatusFileName(CarbonUpdateUtil.getUpdateStatusFileName((String)timestamp));
                    }
                    try {
                        SegmentStatusManager.writeLoadDetailsIntoFile((String)tableStatusPath, (LoadMetadataDetails[])listOfLoadFolderDetailsArray);
                        break block17;
                    }
                    catch (IOException e) {
                        Boolean bl = false;
                        if (lockStatus) {
                            if (carbonLock.unlock()) {
                                LOGGER.info("Table unlocked successfully after table status updation" + table.getDatabaseName() + "." + table.getTableName());
                            } else {
                                LOGGER.error("Unable to unlock Table lock for table" + table.getDatabaseName() + "." + table.getTableName() + " during table status updation");
                            }
                        }
                        return bl;
                    }
                }
                LOGGER.error("Not able to acquire the lock for Table status updation for table " + table.getDatabaseName() + "." + table.getTableName());
            }
            finally {
                if (lockStatus) {
                    if (carbonLock.unlock()) {
                        LOGGER.info("Table unlocked successfully after table status updation" + table.getDatabaseName() + "." + table.getTableName());
                    } else {
                        LOGGER.error("Unable to unlock Table lock for table" + table.getDatabaseName() + "." + table.getTableName() + " during table status updation");
                    }
                }
            }
        }
        return true;
    }
}

