/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.merger;

import java.io.IOException;
import java.util.List;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.mutate.CarbonUpdateUtil;
import org.apache.carbondata.core.scan.result.iterator.RawResultIterator;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.merger.CompactionType;
import org.apache.carbondata.processing.store.CarbonDataFileAttributes;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;

public abstract class AbstractResultProcessor {
    public abstract boolean execute(List<RawResultIterator> var1) throws Exception;

    public abstract void close();

    protected void setDataFileAttributesInModel(CarbonLoadModel loadModel, CompactionType compactionType, CarbonFactDataHandlerModel carbonFactDataHandlerModel) throws IOException {
        CarbonDataFileAttributes carbonDataFileAttributes;
        if (compactionType == CompactionType.IUD_UPDDEL_DELTA) {
            long taskNo = CarbonUpdateUtil.getLatestTaskIdForSegment((Segment)loadModel.getSegment(), (String)loadModel.getTablePath());
            long index = taskNo + 1L;
            carbonDataFileAttributes = new CarbonDataFileAttributes(index, loadModel.getFactTimeStamp());
        } else {
            carbonDataFileAttributes = new CarbonDataFileAttributes(Long.parseLong(loadModel.getTaskNo()), loadModel.getFactTimeStamp());
        }
        carbonFactDataHandlerModel.setCarbonDataFileAttributes(carbonDataFileAttributes);
    }
}

