/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.steps;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.datamap.DataMapWriterListener;
import org.apache.carbondata.processing.loading.AbstractDataLoadProcessorStep;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.exception.BadRecordFoundException;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.row.CarbonRowBatch;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.CarbonFactHandler;
import org.apache.carbondata.processing.store.CarbonFactHandlerFactory;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class DataWriterBatchProcessorStepImpl
extends AbstractDataLoadProcessorStep {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)DataWriterBatchProcessorStepImpl.class.getName());
    private Map<String, LocalDictionaryGenerator> localDictionaryGeneratorMap;
    private CarbonFactHandler carbonFactHandler;

    public DataWriterBatchProcessorStepImpl(CarbonDataLoadConfiguration configuration, AbstractDataLoadProcessorStep child) {
        super(configuration, child);
        this.localDictionaryGeneratorMap = CarbonUtil.getLocalDictionaryModel((CarbonTable)configuration.getTableSpec().getCarbonTable());
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
        this.child.initialize();
    }

    private String[] getStoreLocation(CarbonTableIdentifier tableIdentifier) {
        return CarbonDataProcessorUtil.getLocalDataFolderLocation(tableIdentifier.getDatabaseName(), tableIdentifier.getTableName(), String.valueOf(this.configuration.getTaskNo()), this.configuration.getSegmentId(), false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<CarbonRowBatch>[] execute() throws CarbonDataLoadingException {
        Iterator<CarbonRowBatch>[] iterators = this.child.execute();
        CarbonTableIdentifier tableIdentifier = this.configuration.getTableIdentifier().getCarbonTableIdentifier();
        String tableName = tableIdentifier.getTableName();
        try {
            CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordDictionaryValue2MdkAdd2FileTime("0", Long.valueOf(System.currentTimeMillis()));
            int i = 0;
            String[] storeLocation = this.getStoreLocation(tableIdentifier);
            CarbonDataProcessorUtil.createLocations(storeLocation);
            for (Iterator<CarbonRowBatch> iterator : iterators) {
                int k = 0;
                while (iterator.hasNext()) {
                    CarbonRowBatch next = iterator.next();
                    if (!next.hasNext()) continue;
                    DataMapWriterListener listener = this.getDataMapWriterListener(0);
                    CarbonFactDataHandlerModel model = CarbonFactDataHandlerModel.createCarbonFactDataHandlerModel(this.configuration, storeLocation, i, k++, listener);
                    model.setColumnLocalDictGenMap(this.localDictionaryGeneratorMap);
                    this.carbonFactHandler = CarbonFactHandlerFactory.createCarbonFactHandler(model);
                    this.carbonFactHandler.initialise();
                    this.processBatch(next, this.carbonFactHandler);
                    try {
                        this.finish(tableName, this.carbonFactHandler);
                    }
                    finally {
                        this.carbonFactHandler = null;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "Failed for table: " + tableName + " in DataWriterBatchProcessorStepImpl");
            if (e.getCause() instanceof BadRecordFoundException) {
                throw new BadRecordFoundException(e.getCause().getMessage());
            }
            throw new CarbonDataLoadingException("There is an unexpected error: " + e.getMessage());
        }
        return null;
    }

    @Override
    protected String getStepName() {
        return "Data Batch Writer";
    }

    private void finish(String tableName, CarbonFactHandler dataHandler) {
        CarbonDataWriterException exception = null;
        try {
            dataHandler.finish();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "Failed for table: " + tableName + " in  finishing data handler");
            exception = new CarbonDataWriterException("Failed for table: " + tableName + " in  finishing data handler", (Throwable)e);
        }
        CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordTotalRecords(this.rowCounter.get());
        try {
            this.processingComplete(dataHandler);
        }
        catch (Exception e) {
            exception = new CarbonDataWriterException(e.getMessage(), (Throwable)e);
        }
        CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordDictionaryValue2MdkAdd2FileTime("0", Long.valueOf(System.currentTimeMillis()));
        CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordMdkGenerateTotalTime("0", Long.valueOf(System.currentTimeMillis()));
        if (null != exception) {
            throw exception;
        }
    }

    private void processingComplete(CarbonFactHandler dataHandler) {
        if (null != dataHandler) {
            try {
                dataHandler.closeHandler();
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                throw new CarbonDataLoadingException("There is an unexpected error while closing data handler", e);
            }
        }
    }

    private void processBatch(CarbonRowBatch batch, CarbonFactHandler dataHandler) throws Exception {
        int batchSize = 0;
        while (batch.hasNext()) {
            CarbonRow row = batch.next();
            dataHandler.addDataToStore(row);
            ++batchSize;
        }
        batch.close();
        this.rowCounter.getAndAdd(batchSize);
    }

    @Override
    public void close() {
        if (!this.closed) {
            super.close();
            if (null != this.carbonFactHandler) {
                this.carbonFactHandler.finish();
                this.carbonFactHandler.closeHandler();
            }
        }
    }
}

