/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.steps;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.datastore.row.WriteStepRowUtil;
import org.apache.carbondata.core.keygenerator.KeyGenException;
import org.apache.carbondata.core.localdictionary.generator.LocalDictionaryGenerator;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.datamap.DataMapWriterListener;
import org.apache.carbondata.processing.loading.AbstractDataLoadProcessorStep;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.exception.BadRecordFoundException;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.row.CarbonRowBatch;
import org.apache.carbondata.processing.store.CarbonFactDataHandlerModel;
import org.apache.carbondata.processing.store.CarbonFactHandler;
import org.apache.carbondata.processing.store.CarbonFactHandlerFactory;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class CarbonRowDataWriterProcessorStepImpl
extends AbstractDataLoadProcessorStep {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonRowDataWriterProcessorStepImpl.class.getName());
    private int dimensionWithComplexCount;
    private int noDictWithComplextCount;
    private boolean[] isNoDictionaryDimensionColumn;
    private DataType[] measureDataType;
    private int dimensionCount;
    private int measureCount;
    private long[] readCounter;
    private long[] writeCounter;
    private int outputLength;
    private CarbonTableIdentifier tableIdentifier;
    private String tableName;
    private Map<String, LocalDictionaryGenerator> localDictionaryGeneratorMap;
    private List<CarbonFactHandler> carbonFactHandlers;
    private ExecutorService executorService = null;

    public CarbonRowDataWriterProcessorStepImpl(CarbonDataLoadConfiguration configuration, AbstractDataLoadProcessorStep child) {
        super(configuration, child);
        this.localDictionaryGeneratorMap = CarbonUtil.getLocalDictionaryModel((CarbonTable)configuration.getTableSpec().getCarbonTable());
        this.carbonFactHandlers = new CopyOnWriteArrayList<CarbonFactHandler>();
    }

    @Override
    public void initialize() throws IOException {
        super.initialize();
        this.child.initialize();
    }

    private String[] getStoreLocation(CarbonTableIdentifier tableIdentifier) {
        String[] storeLocation = CarbonDataProcessorUtil.getLocalDataFolderLocation(tableIdentifier.getDatabaseName(), tableIdentifier.getTableName(), String.valueOf(this.configuration.getTaskNo()), this.configuration.getSegmentId(), false, false);
        CarbonDataProcessorUtil.createLocations(storeLocation);
        return storeLocation;
    }

    @Override
    public Iterator<CarbonRowBatch>[] execute() throws CarbonDataLoadingException {
        Iterator<CarbonRowBatch>[] iterators = this.child.execute();
        this.tableIdentifier = this.configuration.getTableIdentifier().getCarbonTableIdentifier();
        this.tableName = this.tableIdentifier.getTableName();
        try {
            this.readCounter = new long[iterators.length];
            this.writeCounter = new long[iterators.length];
            this.dimensionWithComplexCount = this.configuration.getDimensionCount();
            this.noDictWithComplextCount = this.configuration.getNoDictionaryCount() + this.configuration.getComplexDictionaryColumnCount() + this.configuration.getComplexNonDictionaryColumnCount();
            this.dimensionCount = this.configuration.getDimensionCount() - this.noDictWithComplextCount;
            this.isNoDictionaryDimensionColumn = CarbonDataProcessorUtil.getNoDictionaryMapping(this.configuration.getDataFields());
            this.measureDataType = this.configuration.getMeasureDataType();
            this.measureCount = this.configuration.getMeasureCount();
            this.outputLength = this.measureCount + (this.noDictWithComplextCount > 0 ? 1 : 0) + 1;
            CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordDictionaryValue2MdkAdd2FileTime("0", Long.valueOf(System.currentTimeMillis()));
            if (iterators.length == 1) {
                this.doExecute(iterators[0], 0);
            } else {
                this.executorService = Executors.newFixedThreadPool(iterators.length, (ThreadFactory)new CarbonThreadFactory("NoSortDataWriterPool:" + this.configuration.getTableIdentifier().getCarbonTableIdentifier().getTableName()));
                Future[] futures = new Future[iterators.length];
                for (int i = 0; i < iterators.length; ++i) {
                    futures[i] = this.executorService.submit(new DataWriterRunnable(iterators[i], i));
                }
                for (Future future : futures) {
                    future.get();
                }
            }
        }
        catch (CarbonDataWriterException e) {
            LOGGER.error((Throwable)e, "Failed for table: " + this.tableName + " in DataWriterProcessorStepImpl");
            throw new CarbonDataLoadingException("Error while initializing data handler : " + e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "Failed for table: " + this.tableName + " in DataWriterProcessorStepImpl");
            if (e instanceof BadRecordFoundException) {
                throw new BadRecordFoundException(e.getMessage(), e);
            }
            throw new CarbonDataLoadingException("There is an unexpected error: " + e.getMessage(), e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(Iterator<CarbonRowBatch> iterator, int iteratorIndex) throws IOException {
        String[] storeLocation = this.getStoreLocation(this.tableIdentifier);
        DataMapWriterListener listener = this.getDataMapWriterListener(0);
        CarbonFactDataHandlerModel model = CarbonFactDataHandlerModel.createCarbonFactDataHandlerModel(this.configuration, storeLocation, 0, iteratorIndex, listener);
        model.setColumnLocalDictGenMap(this.localDictionaryGeneratorMap);
        CarbonFactHandler dataHandler = null;
        boolean rowsNotExist = true;
        while (iterator.hasNext()) {
            if (rowsNotExist) {
                rowsNotExist = false;
                dataHandler = CarbonFactHandlerFactory.createCarbonFactHandler(model);
                this.carbonFactHandlers.add(dataHandler);
                dataHandler.initialise();
            }
            this.processBatch(iterator.next(), dataHandler, iteratorIndex);
        }
        try {
            if (!rowsNotExist) {
                this.finish(dataHandler, iteratorIndex);
            }
        }
        finally {
            this.carbonFactHandlers.remove(dataHandler);
        }
    }

    @Override
    protected String getStepName() {
        return "Data Writer";
    }

    private void finish(CarbonFactHandler dataHandler, int iteratorIndex) {
        CarbonDataWriterException exception = null;
        try {
            dataHandler.finish();
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "Failed for table: " + this.tableName + " in  finishing data handler");
            exception = new CarbonDataWriterException("Failed for table: " + this.tableName + " in  finishing data handler", (Throwable)e);
        }
        LOGGER.info("Record Processed For table: " + this.tableName);
        String logMessage = "Finished Carbon DataWriterProcessorStepImpl: Read: " + this.readCounter[iteratorIndex] + ": Write: " + this.readCounter[iteratorIndex];
        LOGGER.info(logMessage);
        CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordTotalRecords(this.rowCounter.get());
        try {
            this.processingComplete(dataHandler);
        }
        catch (CarbonDataLoadingException e) {
            exception = new CarbonDataWriterException(e.getMessage(), (Throwable)e);
        }
        CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordDictionaryValue2MdkAdd2FileTime("0", Long.valueOf(System.currentTimeMillis()));
        CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordMdkGenerateTotalTime("0", Long.valueOf(System.currentTimeMillis()));
        if (null != exception) {
            throw exception;
        }
    }

    private void processingComplete(CarbonFactHandler dataHandler) throws CarbonDataLoadingException {
        if (null != dataHandler) {
            try {
                dataHandler.closeHandler();
            }
            catch (CarbonDataWriterException e) {
                LOGGER.error((Throwable)e, e.getMessage());
                throw new CarbonDataLoadingException(e.getMessage());
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e, e.getMessage());
                throw new CarbonDataLoadingException("There is an unexpected error: " + e.getMessage());
            }
        }
    }

    private CarbonRow convertRow(CarbonRow row) throws KeyGenException {
        int dimCount;
        int dictIndex = 0;
        int nonDicIndex = 0;
        int[] dim = new int[this.dimensionCount];
        Object[] nonDicArray = new Object[this.noDictWithComplextCount];
        for (dimCount = 0; dimCount < this.isNoDictionaryDimensionColumn.length; ++dimCount) {
            if (this.isNoDictionaryDimensionColumn[dimCount]) {
                nonDicArray[nonDicIndex++] = row.getObject(dimCount);
                continue;
            }
            dim[dictIndex++] = (Integer)row.getObject(dimCount);
        }
        while (dimCount < this.dimensionWithComplexCount) {
            nonDicArray[nonDicIndex++] = row.getObject(dimCount);
            ++dimCount;
        }
        Object[] measures = new Object[this.measureCount];
        for (int i = 0; i < this.measureCount; ++i) {
            measures[i] = row.getObject(i + this.dimensionWithComplexCount);
        }
        return WriteStepRowUtil.fromColumnCategory((int[])dim, (Object[])nonDicArray, (Object[])measures);
    }

    private void processBatch(CarbonRowBatch batch, CarbonFactHandler dataHandler, int iteratorIndex) throws CarbonDataLoadingException {
        try {
            while (batch.hasNext()) {
                CarbonRow row = batch.next();
                CarbonRow converted = this.convertRow(row);
                dataHandler.addDataToStore(converted);
                int n = iteratorIndex;
                this.readCounter[n] = this.readCounter[n] + 1L;
            }
            int n = iteratorIndex;
            this.writeCounter[n] = this.writeCounter[n] + (long)batch.getSize();
        }
        catch (Exception e) {
            throw new CarbonDataLoadingException("unable to generate the mdkey", e);
        }
        this.rowCounter.getAndAdd(batch.getSize());
    }

    @Override
    public void close() {
        if (!this.closed) {
            super.close();
            if (null != this.executorService) {
                this.executorService.shutdownNow();
            }
            if (null != this.carbonFactHandlers && !this.carbonFactHandlers.isEmpty()) {
                for (CarbonFactHandler carbonFactHandler : this.carbonFactHandlers) {
                    carbonFactHandler.finish();
                    carbonFactHandler.closeHandler();
                }
            }
        }
    }

    class DataWriterRunnable
    implements Runnable {
        private Iterator<CarbonRowBatch> iterator;
        private int iteratorIndex = 0;

        DataWriterRunnable(Iterator<CarbonRowBatch> iterator, int iteratorIndex) {
            this.iterator = iterator;
            this.iteratorIndex = iteratorIndex;
        }

        @Override
        public void run() {
            try {
                CarbonRowDataWriterProcessorStepImpl.this.doExecute(this.iterator, this.iteratorIndex);
            }
            catch (IOException e) {
                LOGGER.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

