/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe.sort;

import org.apache.carbondata.core.memory.IntPointerBuffer;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeCarbonRow;
import org.apache.carbondata.processing.loading.sort.unsafe.sort.SortDataFormat;

public class UnsafeIntSortDataFormat
extends SortDataFormat<UnsafeCarbonRow, IntPointerBuffer> {
    private UnsafeCarbonRowPage page;

    public UnsafeIntSortDataFormat(UnsafeCarbonRowPage page) {
        this.page = page;
    }

    @Override
    public UnsafeCarbonRow getKey(IntPointerBuffer data, int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public UnsafeCarbonRow newKey() {
        return new UnsafeCarbonRow();
    }

    @Override
    public UnsafeCarbonRow getKey(IntPointerBuffer data, int pos, UnsafeCarbonRow reuse) {
        reuse.address = (long)data.get(pos) + this.page.getDataBlock().getBaseOffset();
        return reuse;
    }

    @Override
    public void swap(IntPointerBuffer data, int pos0, int pos1) {
        int tempPointer = data.get(pos0);
        data.set(pos0, data.get(pos1));
        data.set(pos1, tempPointer);
    }

    @Override
    public void copyElement(IntPointerBuffer src, int srcPos, IntPointerBuffer dst, int dstPos) {
        dst.set(dstPos, src.get(srcPos));
    }

    @Override
    public void copyRange(IntPointerBuffer src, int srcPos, IntPointerBuffer dst, int dstPos, int length) {
        System.arraycopy(src.getPointerBlock(), srcPos, dst.getPointerBlock(), dstPos, length);
    }

    @Override
    public IntPointerBuffer allocate(int length) {
        return new IntPointerBuffer(length);
    }
}

