/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe.holder;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.loading.sort.SortStepRowHandler;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.SortTempChunkHolder;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.IntermediateSortTempRowComparator;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.sort.sortdata.TableFieldStat;

public class UnsafeSortTempFileChunkHolder
implements SortTempChunkHolder {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)UnsafeSortTempFileChunkHolder.class.getName());
    private File tempFile;
    private DataInputStream stream;
    private int entryCount;
    private IntermediateSortTempRow returnRow;
    private int readBufferSize;
    private String compressorName;
    private IntermediateSortTempRow[] currentBuffer;
    private IntermediateSortTempRow[] backupBuffer;
    private boolean isBackupFilled;
    private boolean prefetch;
    private int bufferSize;
    private int bufferRowCounter;
    private ExecutorService executorService;
    private Future<Void> submit;
    private int prefetchRecordsProceesed;
    private int totalRecordFetch;
    private int numberOfObjectRead;
    private TableFieldStat tableFieldStat;
    private SortStepRowHandler sortStepRowHandler;
    private Comparator<IntermediateSortTempRow> comparator;
    private boolean convertNoSortFields;

    public UnsafeSortTempFileChunkHolder(File tempFile, SortParameters parameters, boolean convertNoSortFields) {
        this.tempFile = tempFile;
        this.readBufferSize = parameters.getBufferSize();
        this.compressorName = parameters.getSortTempCompressorName();
        this.tableFieldStat = new TableFieldStat(parameters);
        this.sortStepRowHandler = new SortStepRowHandler(this.tableFieldStat);
        this.executorService = Executors.newFixedThreadPool(1);
        this.comparator = new IntermediateSortTempRowComparator(parameters.getNoDictionarySortColumn(), parameters.getNoDictDataType());
        this.convertNoSortFields = convertNoSortFields;
        this.initialize();
    }

    public void initialize() {
        this.prefetch = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("carbon.merge.sort.prefetch", "true"));
        this.bufferSize = Integer.parseInt(CarbonProperties.getInstance().getProperty("carbon.prefetch.buffersize", "1000"));
        this.initialise();
    }

    private void initialise() {
        try {
            this.stream = FileFactory.getDataInputStream((String)this.tempFile.getPath(), (FileFactory.FileType)FileFactory.FileType.LOCAL, (int)this.readBufferSize, (String)this.compressorName);
            this.entryCount = this.stream.readInt();
            LOGGER.info("Processing unsafe mode file rows with size : " + this.entryCount);
            if (this.prefetch) {
                new DataFetcher(false).call();
                this.totalRecordFetch += this.currentBuffer.length;
                if (this.totalRecordFetch < this.entryCount) {
                    this.submit = this.executorService.submit(new DataFetcher(true));
                }
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Throwable)e);
            throw new RuntimeException(this.tempFile + " No Found", e);
        }
        catch (IOException e) {
            LOGGER.error((Throwable)e);
            throw new RuntimeException(this.tempFile + " No Found", e);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new RuntimeException(this.tempFile + " Problem while reading", e);
        }
    }

    @Override
    public void readRow() throws CarbonSortKeyAndGroupByException {
        if (this.prefetch) {
            this.fillDataForPrefetch();
        } else {
            try {
                this.returnRow = this.convertNoSortFields ? this.sortStepRowHandler.readWithNoSortFieldConvert(this.stream) : this.sortStepRowHandler.readWithoutNoSortFieldConvert(this.stream);
                ++this.numberOfObjectRead;
            }
            catch (IOException e) {
                throw new CarbonSortKeyAndGroupByException("Problems while reading row", e);
            }
        }
    }

    private void fillDataForPrefetch() {
        if (this.bufferRowCounter >= this.bufferSize) {
            if (this.isBackupFilled) {
                this.bufferRowCounter = 0;
                this.currentBuffer = this.backupBuffer;
                this.totalRecordFetch += this.currentBuffer.length;
                this.isBackupFilled = false;
                if (this.totalRecordFetch < this.entryCount) {
                    this.submit = this.executorService.submit(new DataFetcher(true));
                }
            } else {
                try {
                    this.submit.get();
                }
                catch (Exception e) {
                    LOGGER.error((Throwable)e);
                }
                this.bufferRowCounter = 0;
                this.currentBuffer = this.backupBuffer;
                this.isBackupFilled = false;
                this.totalRecordFetch += this.currentBuffer.length;
                if (this.totalRecordFetch < this.entryCount) {
                    this.submit = this.executorService.submit(new DataFetcher(true));
                }
            }
        }
        ++this.prefetchRecordsProceesed;
        this.returnRow = this.currentBuffer[this.bufferRowCounter++];
    }

    private IntermediateSortTempRow[] readBatchedRowFromStream(int expected) throws IOException {
        IntermediateSortTempRow[] holders = new IntermediateSortTempRow[expected];
        for (int i = 0; i < expected; ++i) {
            holders[i] = this.convertNoSortFields ? this.sortStepRowHandler.readWithNoSortFieldConvert(this.stream) : this.sortStepRowHandler.readWithoutNoSortFieldConvert(this.stream);
        }
        this.numberOfObjectRead += expected;
        return holders;
    }

    @Override
    public IntermediateSortTempRow getRow() {
        return this.returnRow;
    }

    @Override
    public boolean hasNext() {
        if (this.prefetch) {
            return this.prefetchRecordsProceesed < this.entryCount;
        }
        return this.numberOfObjectRead < this.entryCount;
    }

    @Override
    public void close() {
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{this.stream});
        if (null != this.executorService && !this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
        }
    }

    @Override
    public int numberOfRows() {
        return this.entryCount;
    }

    @Override
    public int compareTo(SortTempChunkHolder other) {
        return this.comparator.compare(this.returnRow, other.getRow());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof UnsafeSortTempFileChunkHolder)) {
            return false;
        }
        UnsafeSortTempFileChunkHolder o = (UnsafeSortTempFileChunkHolder)obj;
        return this == o;
    }

    public int hashCode() {
        int hash = 0;
        hash += this.tableFieldStat.hashCode();
        return hash += this.tempFile.hashCode();
    }

    private IntermediateSortTempRow[] prefetchRecordsFromFile(int numberOfRecords) throws IOException {
        return this.readBatchedRowFromStream(numberOfRecords);
    }

    static /* synthetic */ IntermediateSortTempRow[] access$402(UnsafeSortTempFileChunkHolder x0, IntermediateSortTempRow[] x1) {
        x0.backupBuffer = x1;
        return x1;
    }

    static /* synthetic */ IntermediateSortTempRow[] access$702(UnsafeSortTempFileChunkHolder x0, IntermediateSortTempRow[] x1) {
        x0.currentBuffer = x1;
        return x1;
    }

    private final class DataFetcher
    implements Callable<Void> {
        private boolean isBackUpFilling;
        private int numberOfRecords;

        private DataFetcher(boolean backUp) {
            this.isBackUpFilling = backUp;
            this.calculateNumberOfRecordsToBeFetched();
        }

        private void calculateNumberOfRecordsToBeFetched() {
            int numberOfRecordsLeftToBeRead = UnsafeSortTempFileChunkHolder.this.entryCount - UnsafeSortTempFileChunkHolder.this.totalRecordFetch;
            this.numberOfRecords = UnsafeSortTempFileChunkHolder.this.bufferSize < numberOfRecordsLeftToBeRead ? UnsafeSortTempFileChunkHolder.this.bufferSize : numberOfRecordsLeftToBeRead;
        }

        @Override
        public Void call() throws Exception {
            try {
                if (this.isBackUpFilling) {
                    UnsafeSortTempFileChunkHolder.access$402(UnsafeSortTempFileChunkHolder.this, UnsafeSortTempFileChunkHolder.this.prefetchRecordsFromFile(this.numberOfRecords));
                    UnsafeSortTempFileChunkHolder.this.isBackupFilled = true;
                } else {
                    UnsafeSortTempFileChunkHolder.access$702(UnsafeSortTempFileChunkHolder.this, UnsafeSortTempFileChunkHolder.this.prefetchRecordsFromFile(this.numberOfRecords));
                }
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
            }
            return null;
        }
    }
}

