/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.memory.CarbonUnsafe;
import org.apache.carbondata.core.memory.IntPointerBuffer;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.MemoryException;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.memory.UnsafeSortMemoryManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.ReUsableByteArrayDataOutputStream;
import org.apache.carbondata.core.util.ThreadLocalTaskInfo;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.comparator.UnsafeRowComparator;
import org.apache.carbondata.processing.loading.sort.unsafe.comparator.UnsafeRowComparatorForNormalDims;
import org.apache.carbondata.processing.loading.sort.unsafe.holder.UnsafeCarbonRow;
import org.apache.carbondata.processing.loading.sort.unsafe.merger.UnsafeIntermediateMerger;
import org.apache.carbondata.processing.loading.sort.unsafe.sort.TimSort;
import org.apache.carbondata.processing.loading.sort.unsafe.sort.UnsafeIntSortDataFormat;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.sort.sortdata.TableFieldStat;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class UnsafeSortDataRows {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)UnsafeSortDataRows.class.getName());
    private ThreadStatusObserver threadStatusObserver;
    private ExecutorService dataSorterAndWriterExecutorService;
    private SortParameters parameters;
    private TableFieldStat tableFieldStat;
    private ThreadLocal<ReUsableByteArrayDataOutputStream> reUsableByteArrayDataOutputStream;
    private UnsafeIntermediateMerger unsafeInMemoryIntermediateFileMerger;
    private UnsafeCarbonRowPage rowPage;
    private final Object addRowsLock = new Object();
    private long inMemoryChunkSize;
    private boolean enableInMemoryIntermediateMerge;
    private int bytesAdded;
    private long maxSizeAllowed;
    private Semaphore semaphore;
    private final String taskId;

    public UnsafeSortDataRows(SortParameters parameters, UnsafeIntermediateMerger unsafeInMemoryIntermediateFileMerger, int inMemoryChunkSize) {
        this.parameters = parameters;
        this.tableFieldStat = new TableFieldStat(parameters);
        this.reUsableByteArrayDataOutputStream = new ThreadLocal<ReUsableByteArrayDataOutputStream>(){

            @Override
            protected ReUsableByteArrayDataOutputStream initialValue() {
                ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
                return new ReUsableByteArrayDataOutputStream(byteStream);
            }
        };
        this.unsafeInMemoryIntermediateFileMerger = unsafeInMemoryIntermediateFileMerger;
        this.threadStatusObserver = new ThreadStatusObserver();
        this.taskId = ThreadLocalTaskInfo.getCarbonTaskInfo().getTaskId();
        this.inMemoryChunkSize = (long)inMemoryChunkSize * 1024L * 1024L;
        this.enableInMemoryIntermediateMerge = Boolean.parseBoolean(CarbonProperties.getInstance().getProperty("enable.inmemory.merge.sort", "false"));
        this.maxSizeAllowed = parameters.getBatchSortSizeinMb();
        this.maxSizeAllowed = this.maxSizeAllowed <= 0L ? UnsafeMemoryManager.INSTANCE.getUsableMemory() / 2L : this.maxSizeAllowed * 1024L * 1024L;
    }

    public void initialize() throws MemoryException, CarbonSortKeyAndGroupByException {
        this.rowPage = this.createUnsafeRowPage();
        this.deleteSortLocationIfExists();
        CarbonDataProcessorUtil.createLocations(this.parameters.getTempFileLocation());
        this.dataSorterAndWriterExecutorService = Executors.newFixedThreadPool(this.parameters.getNumberOfCores(), (ThreadFactory)new CarbonThreadFactory("UnsafeSortDataRowPool:" + this.parameters.getTableName()));
        this.semaphore = new Semaphore(this.parameters.getNumberOfCores());
    }

    private UnsafeCarbonRowPage createUnsafeRowPage() throws MemoryException, CarbonSortKeyAndGroupByException {
        MemoryBlock baseBlock = UnsafeMemoryManager.allocateMemoryWithRetry((String)this.taskId, (long)this.inMemoryChunkSize);
        boolean isMemoryAvailable = UnsafeSortMemoryManager.INSTANCE.isMemoryAvailable(baseBlock.size());
        if (isMemoryAvailable) {
            UnsafeSortMemoryManager.INSTANCE.allocateDummyMemory(baseBlock.size());
        } else {
            this.unsafeInMemoryIntermediateFileMerger.tryTriggerInmemoryMerging(true);
        }
        return new UnsafeCarbonRowPage(this.tableFieldStat, baseBlock, !isMemoryAvailable, this.taskId);
    }

    public boolean canAdd() {
        return (long)this.bytesAdded < this.maxSizeAllowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowBatch(Object[][] rowBatch, int size) throws CarbonSortKeyAndGroupByException {
        Object object = this.addRowsLock;
        synchronized (object) {
            this.addBatch(rowBatch, size);
        }
    }

    public void addRowBatchWithOutSync(Object[][] rowBatch, int size) throws CarbonSortKeyAndGroupByException {
        this.addBatch(rowBatch, size);
    }

    private void addBatch(Object[][] rowBatch, int size) throws CarbonSortKeyAndGroupByException {
        if (this.rowPage == null) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            try {
                if (!this.rowPage.canAdd()) {
                    this.handlePreviousPage();
                    try {
                        this.rowPage = this.createUnsafeRowPage();
                    }
                    catch (Exception ex) {
                        this.rowPage = null;
                        LOGGER.error("exception occurred while trying to acquire a semaphore lock: " + ex.getMessage());
                        throw new CarbonSortKeyAndGroupByException(ex);
                    }
                }
                this.bytesAdded += this.rowPage.addRow(rowBatch[i], this.reUsableByteArrayDataOutputStream.get());
                continue;
            }
            catch (Exception e) {
                if (e.getMessage().contains("cannot handle this row. create new page")) {
                    this.rowPage.makeCanAddFail();
                    --i;
                    continue;
                }
                LOGGER.error("exception occurred while trying to acquire a semaphore lock: " + e.getMessage());
                throw new CarbonSortKeyAndGroupByException(e);
            }
        }
    }

    public void addRow(Object[] row) throws CarbonSortKeyAndGroupByException {
        if (this.rowPage == null) {
            return;
        }
        try {
            if (!this.rowPage.canAdd()) {
                this.handlePreviousPage();
                try {
                    this.rowPage = this.createUnsafeRowPage();
                }
                catch (Exception ex) {
                    this.rowPage = null;
                    LOGGER.error("exception occurred while trying to acquire a semaphore lock: " + ex.getMessage());
                    throw new CarbonSortKeyAndGroupByException(ex);
                }
            }
            this.rowPage.addRow(row, this.reUsableByteArrayDataOutputStream.get());
        }
        catch (Exception e) {
            if (e.getMessage().contains("cannot handle this row. create new page")) {
                this.rowPage.makeCanAddFail();
                this.addRow(row);
            }
            LOGGER.error("exception occurred while trying to acquire a semaphore lock: " + e.getMessage());
            throw new CarbonSortKeyAndGroupByException(e);
        }
    }

    public void startSorting() throws CarbonSortKeyAndGroupByException, InterruptedException {
        LOGGER.info("Unsafe based sorting will be used");
        if (this.rowPage.getUsedSize() > 0) {
            this.handlePreviousPage();
        } else {
            this.rowPage.freeMemory();
        }
        this.startFileBasedMerge();
    }

    private void handlePreviousPage() throws CarbonSortKeyAndGroupByException, InterruptedException {
        if (this.enableInMemoryIntermediateMerge) {
            this.unsafeInMemoryIntermediateFileMerger.startInmemoryMergingIfPossible();
        }
        this.unsafeInMemoryIntermediateFileMerger.startFileMergingIfPossible();
        this.semaphore.acquire();
        this.dataSorterAndWriterExecutorService.submit(new DataSorterAndWriter(this.rowPage));
    }

    private void writeDataToFile(UnsafeCarbonRowPage rowPage, File file) throws CarbonSortKeyAndGroupByException {
        DataOutputStream stream = null;
        try {
            stream = FileFactory.getDataOutputStream((String)file.getPath(), (FileFactory.FileType)FileFactory.FileType.LOCAL, (int)this.parameters.getFileWriteBufferSize(), (String)this.parameters.getSortTempCompressorName());
            int actualSize = rowPage.getBuffer().getActualSize();
            stream.writeInt(actualSize);
            for (int i = 0; i < actualSize; ++i) {
                rowPage.writeRow((long)rowPage.getBuffer().get(i) + rowPage.getDataBlock().getBaseOffset(), stream);
            }
        }
        catch (IOException | MemoryException e) {
            try {
                throw new CarbonSortKeyAndGroupByException("Problem while writing the file", e);
            }
            catch (Throwable throwable) {
                CarbonUtil.closeStreams((Closeable[])new Closeable[]{stream});
                throw throwable;
            }
        }
        CarbonUtil.closeStreams((Closeable[])new Closeable[]{stream});
    }

    public void deleteSortLocationIfExists() {
        CarbonDataProcessorUtil.deleteSortLocationIfExists(this.parameters.getTempFileLocation());
    }

    private void startFileBasedMerge() throws InterruptedException {
        this.dataSorterAndWriterExecutorService.shutdown();
        this.dataSorterAndWriterExecutorService.awaitTermination(2L, TimeUnit.DAYS);
    }

    private class DataSorterAndWriter
    implements Runnable {
        private UnsafeCarbonRowPage page;

        public DataSorterAndWriter(UnsafeCarbonRowPage rowPage) {
            this.page = rowPage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                TimSort<UnsafeCarbonRow, IntPointerBuffer> timSort = new TimSort<UnsafeCarbonRow, IntPointerBuffer>(new UnsafeIntSortDataFormat(this.page));
                if (UnsafeSortDataRows.this.parameters.getNumberOfNoDictSortColumns() > 0) {
                    timSort.sort(this.page.getBuffer(), 0, this.page.getBuffer().getActualSize(), new UnsafeRowComparator(this.page));
                } else {
                    timSort.sort(this.page.getBuffer(), 0, this.page.getBuffer().getActualSize(), new UnsafeRowComparatorForNormalDims(this.page));
                }
                if (this.page.isSaveToDisk()) {
                    String tmpDir = UnsafeSortDataRows.this.parameters.getTempFileLocation()[new Random().nextInt(UnsafeSortDataRows.this.parameters.getTempFileLocation().length)];
                    File sortTempFile = new File(tmpDir + File.separator + UnsafeSortDataRows.this.parameters.getTableName() + '_' + UnsafeSortDataRows.this.parameters.getRangeId() + '_' + System.nanoTime() + ".sorttemp");
                    UnsafeSortDataRows.this.writeDataToFile(this.page, sortTempFile);
                    LOGGER.info("Time taken to sort row page with size" + this.page.getBuffer().getActualSize() + " and write is: " + (System.currentTimeMillis() - startTime) + ": location:" + sortTempFile + ", sort temp file size in MB is " + (double)sortTempFile.length() * 0.1 * 10.0 / 1024.0 / 1024.0);
                    this.page.freeMemory();
                    UnsafeSortDataRows.this.unsafeInMemoryIntermediateFileMerger.addFileToMerge(sortTempFile);
                } else {
                    MemoryBlock newMemoryBlock = UnsafeSortMemoryManager.INSTANCE.allocateMemoryLazy(UnsafeSortDataRows.this.taskId, this.page.getDataBlock().size());
                    CarbonUnsafe.getUnsafe().copyMemory(this.page.getDataBlock().getBaseObject(), this.page.getDataBlock().getBaseOffset(), newMemoryBlock.getBaseObject(), newMemoryBlock.getBaseOffset(), this.page.getDataBlock().size());
                    this.page.freeMemory();
                    this.page.setNewDataBlock(newMemoryBlock);
                    this.page.getBuffer().loadToUnsafe();
                    UnsafeSortDataRows.this.unsafeInMemoryIntermediateFileMerger.addDataChunkToMerge(this.page);
                    LOGGER.info("Time taken to sort row page with size: " + this.page.getBuffer().getActualSize() + "is: " + (System.currentTimeMillis() - startTime));
                }
            }
            catch (Throwable e) {
                try {
                    UnsafeSortDataRows.this.threadStatusObserver.notifyFailed(e);
                }
                catch (CarbonSortKeyAndGroupByException ex) {
                    LOGGER.error(e);
                }
            }
            finally {
                UnsafeSortDataRows.this.semaphore.release();
            }
        }
    }

    private class ThreadStatusObserver {
        private ThreadStatusObserver() {
        }

        public void notifyFailed(Throwable exception) throws CarbonSortKeyAndGroupByException {
            UnsafeSortDataRows.this.semaphore.release();
            UnsafeSortDataRows.this.dataSorterAndWriterExecutorService.shutdownNow();
            UnsafeSortDataRows.this.unsafeInMemoryIntermediateFileMerger.close();
            UnsafeSortDataRows.this.parameters.getObserver().setFailed(true);
            LOGGER.error(exception);
            throw new CarbonSortKeyAndGroupByException(exception);
        }
    }
}

