/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.unsafe;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.carbondata.core.memory.IntPointerBuffer;
import org.apache.carbondata.core.memory.MemoryBlock;
import org.apache.carbondata.core.memory.MemoryException;
import org.apache.carbondata.core.memory.UnsafeMemoryManager;
import org.apache.carbondata.core.memory.UnsafeSortMemoryManager;
import org.apache.carbondata.core.util.ReUsableByteArrayDataOutputStream;
import org.apache.carbondata.processing.loading.row.IntermediateSortTempRow;
import org.apache.carbondata.processing.loading.sort.SortStepRowHandler;
import org.apache.carbondata.processing.sort.sortdata.TableFieldStat;

public class UnsafeCarbonRowPage {
    private IntPointerBuffer buffer;
    private int lastSize;
    private long sizeToBeUsed;
    private MemoryBlock dataBlock;
    private boolean saveToDisk;
    private MemoryManagerType managerType;
    private String taskId;
    private TableFieldStat tableFieldStat;
    private SortStepRowHandler sortStepRowHandler;
    private boolean convertNoSortFields;

    public UnsafeCarbonRowPage(TableFieldStat tableFieldStat, MemoryBlock memoryBlock, boolean saveToDisk, String taskId) {
        this.tableFieldStat = tableFieldStat;
        this.sortStepRowHandler = new SortStepRowHandler(tableFieldStat);
        this.saveToDisk = saveToDisk;
        this.taskId = taskId;
        this.buffer = new IntPointerBuffer(this.taskId);
        this.dataBlock = memoryBlock;
        this.sizeToBeUsed = this.dataBlock.size() - this.dataBlock.size() * 5L / 100L;
        this.managerType = MemoryManagerType.UNSAFE_MEMORY_MANAGER;
    }

    public int addRow(Object[] row, ReUsableByteArrayDataOutputStream reUsableByteArrayDataOutputStream) throws MemoryException, IOException {
        int size = this.addRow(row, this.dataBlock.getBaseOffset() + (long)this.lastSize, reUsableByteArrayDataOutputStream);
        this.buffer.set(this.lastSize);
        this.lastSize += size;
        return size;
    }

    private int addRow(Object[] row, long address, ReUsableByteArrayDataOutputStream reUsableByteArrayDataOutputStream) throws MemoryException, IOException {
        return this.sortStepRowHandler.writeRawRowAsIntermediateSortTempRowToUnsafeMemory(row, this.dataBlock.getBaseObject(), address, reUsableByteArrayDataOutputStream, this.dataBlock.size() - (long)this.lastSize, this.dataBlock.size());
    }

    public IntermediateSortTempRow getRow(long address) {
        if (this.convertNoSortFields) {
            return this.sortStepRowHandler.readRowFromMemoryWithNoSortFieldConvert(this.dataBlock.getBaseObject(), address);
        }
        return this.sortStepRowHandler.readFromMemoryWithoutNoSortFieldConvert(this.dataBlock.getBaseObject(), address);
    }

    public void writeRow(long address, DataOutputStream stream) throws IOException, MemoryException {
        this.sortStepRowHandler.writeIntermediateSortTempRowFromUnsafeMemoryToStream(this.dataBlock.getBaseObject(), address, stream, this.dataBlock.size() - (long)this.lastSize, this.dataBlock.size());
    }

    public void freeMemory() {
        switch (this.managerType) {
            case UNSAFE_MEMORY_MANAGER: {
                UnsafeMemoryManager.INSTANCE.freeMemory(this.taskId, this.dataBlock);
                break;
            }
            default: {
                UnsafeSortMemoryManager.INSTANCE.freeMemory(this.taskId, this.dataBlock);
                this.buffer.freeMemory();
            }
        }
    }

    public boolean isSaveToDisk() {
        return this.saveToDisk;
    }

    public IntPointerBuffer getBuffer() {
        return this.buffer;
    }

    public int getUsedSize() {
        return this.lastSize;
    }

    public boolean canAdd() {
        return (long)this.lastSize < this.sizeToBeUsed;
    }

    public MemoryBlock getDataBlock() {
        return this.dataBlock;
    }

    public TableFieldStat getTableFieldStat() {
        return this.tableFieldStat;
    }

    public void setNewDataBlock(MemoryBlock newMemoryBlock) {
        this.dataBlock = newMemoryBlock;
        this.managerType = MemoryManagerType.UNSAFE_SORT_MEMORY_MANAGER;
    }

    public void setReadConvertedNoSortField() {
        this.convertNoSortFields = true;
    }

    public void makeCanAddFail() {
        this.lastSize = (int)this.sizeToBeUsed;
    }

    public static enum MemoryManagerType {
        UNSAFE_MEMORY_MANAGER,
        UNSAFE_SORT_MEMORY_MANAGER;

    }
}

