/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.schema.ColumnRangeInfo;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.row.CarbonRowBatch;
import org.apache.carbondata.processing.loading.sort.AbstractMergeSorter;
import org.apache.carbondata.processing.loading.sort.impl.ThreadStatusObserver;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeSortDataRows;
import org.apache.carbondata.processing.loading.sort.unsafe.merger.UnsafeIntermediateMerger;
import org.apache.carbondata.processing.loading.sort.unsafe.merger.UnsafeSingleThreadFinalSortFilesMerger;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.commons.lang3.StringUtils;

public class UnsafeParallelReadMergeSorterWithColumnRangeImpl
extends AbstractMergeSorter {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)UnsafeParallelReadMergeSorterWithColumnRangeImpl.class.getName());
    private SortParameters originSortParameters;
    private UnsafeIntermediateMerger[] intermediateFileMergers;
    private int inMemoryChunkSizeInMB;
    private AtomicLong rowCounter;
    private ColumnRangeInfo columnRangeInfo;
    private List<AtomicLong> insideRowCounterList;

    public UnsafeParallelReadMergeSorterWithColumnRangeImpl(AtomicLong rowCounter, ColumnRangeInfo columnRangeInfo) {
        this.rowCounter = rowCounter;
        this.columnRangeInfo = columnRangeInfo;
    }

    @Override
    public void initialize(SortParameters sortParameters) {
        this.originSortParameters = sortParameters;
        int totalInMemoryChunkSizeInMB = CarbonProperties.getInstance().getSortMemoryChunkSizeInMB();
        this.inMemoryChunkSizeInMB = totalInMemoryChunkSizeInMB / this.columnRangeInfo.getNumOfRanges();
        if (this.inMemoryChunkSizeInMB < 5) {
            this.inMemoryChunkSizeInMB = 5;
        }
        this.insideRowCounterList = new ArrayList<AtomicLong>(this.columnRangeInfo.getNumOfRanges());
        for (int i = 0; i < this.columnRangeInfo.getNumOfRanges(); ++i) {
            this.insideRowCounterList.add(new AtomicLong(0L));
        }
    }

    @Override
    public Iterator<CarbonRowBatch>[] sort(Iterator<CarbonRowBatch>[] iterators) throws CarbonDataLoadingException {
        int i;
        UnsafeSortDataRows[] sortDataRows = new UnsafeSortDataRows[this.columnRangeInfo.getNumOfRanges()];
        this.intermediateFileMergers = new UnsafeIntermediateMerger[this.columnRangeInfo.getNumOfRanges()];
        SortParameters[] sortParameterArray = new SortParameters[this.columnRangeInfo.getNumOfRanges()];
        try {
            for (int i2 = 0; i2 < this.columnRangeInfo.getNumOfRanges(); ++i2) {
                SortParameters parameters = this.originSortParameters.getCopy();
                parameters.setPartitionID(i2 + "");
                parameters.setRangeId(i2);
                sortParameterArray[i2] = parameters;
                this.setTempLocation(parameters);
                this.intermediateFileMergers[i2] = new UnsafeIntermediateMerger(parameters);
                sortDataRows[i2] = new UnsafeSortDataRows(parameters, this.intermediateFileMergers[i2], this.inMemoryChunkSizeInMB);
                sortDataRows[i2].initialize();
            }
        }
        catch (Exception e) {
            throw new CarbonDataLoadingException(e);
        }
        ExecutorService executorService = Executors.newFixedThreadPool(iterators.length);
        this.threadStatusObserver = new ThreadStatusObserver(executorService);
        int batchSize = CarbonProperties.getInstance().getBatchSize();
        try {
            for (i = 0; i < iterators.length; ++i) {
                executorService.execute(new SortIteratorThread(iterators[i], sortDataRows, this.rowCounter, this.insideRowCounterList, this.threadStatusObserver));
            }
            executorService.shutdown();
            executorService.awaitTermination(2L, TimeUnit.DAYS);
            this.processRowToNextStep(sortDataRows, this.originSortParameters);
        }
        catch (Exception e) {
            this.checkError();
            throw new CarbonDataLoadingException("Problem while shutdown the server ", e);
        }
        this.checkError();
        try {
            for (i = 0; i < this.intermediateFileMergers.length; ++i) {
                this.intermediateFileMergers[i].finish();
            }
        }
        catch (Exception e) {
            throw new CarbonDataLoadingException(e);
        }
        Iterator[] batchIterator = new Iterator[this.columnRangeInfo.getNumOfRanges()];
        for (int i3 = 0; i3 < sortDataRows.length; ++i3) {
            batchIterator[i3] = new MergedDataIterator(sortParameterArray[i3], batchSize, this.intermediateFileMergers[i3]);
        }
        return batchIterator;
    }

    private UnsafeSingleThreadFinalSortFilesMerger getFinalMerger(SortParameters sortParameters) {
        String[] storeLocation = CarbonDataProcessorUtil.getLocalDataFolderLocation(sortParameters.getDatabaseName(), sortParameters.getTableName(), String.valueOf(sortParameters.getTaskNo()), sortParameters.getSegmentId() + "", false, false);
        String[] dataFolderLocation = CarbonDataProcessorUtil.arrayAppend(storeLocation, File.separator, "sortrowtmp");
        return new UnsafeSingleThreadFinalSortFilesMerger(sortParameters, dataFolderLocation);
    }

    @Override
    public void close() {
        for (int i = 0; i < this.intermediateFileMergers.length; ++i) {
            this.intermediateFileMergers[i].close();
        }
    }

    private boolean processRowToNextStep(UnsafeSortDataRows[] sortDataRows, SortParameters parameters) throws CarbonDataLoadingException {
        try {
            for (int i = 0; i < sortDataRows.length; ++i) {
                sortDataRows[i].startSorting();
            }
            LOGGER.info("Record Processed For table: " + parameters.getTableName());
            CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordSortRowsStepTotalTime(parameters.getPartitionID(), Long.valueOf(System.currentTimeMillis()));
            CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordDictionaryValuesTotalTime(parameters.getPartitionID(), Long.valueOf(System.currentTimeMillis()));
            return false;
        }
        catch (Exception e) {
            throw new CarbonDataLoadingException(e);
        }
    }

    private void setTempLocation(SortParameters parameters) {
        String[] carbonDataDirectoryPath = CarbonDataProcessorUtil.getLocalDataFolderLocation(parameters.getDatabaseName(), parameters.getTableName(), parameters.getTaskNo(), parameters.getSegmentId(), false, false);
        Object[] tmpLoc = CarbonDataProcessorUtil.arrayAppend(carbonDataDirectoryPath, File.separator, "sortrowtmp");
        LOGGER.warn("set temp location: " + StringUtils.join((Object[])tmpLoc, (String)", "));
        parameters.setTempFileLocation((String[])tmpLoc);
    }

    private class MergedDataIterator
    extends CarbonIterator<CarbonRowBatch> {
        private SortParameters sortParameters;
        private int batchSize;
        private boolean firstRow;
        private UnsafeIntermediateMerger intermediateMerger;
        private UnsafeSingleThreadFinalSortFilesMerger finalMerger;

        public MergedDataIterator(SortParameters sortParameters, int batchSize, UnsafeIntermediateMerger intermediateMerger) {
            this.sortParameters = sortParameters;
            this.batchSize = batchSize;
            this.intermediateMerger = intermediateMerger;
            this.firstRow = true;
        }

        public boolean hasNext() {
            if (this.firstRow) {
                this.firstRow = false;
                this.finalMerger = UnsafeParallelReadMergeSorterWithColumnRangeImpl.this.getFinalMerger(this.sortParameters);
                List<UnsafeCarbonRowPage> rowPages = this.intermediateMerger.getRowPages();
                this.finalMerger.startFinalMerge(rowPages.toArray(new UnsafeCarbonRowPage[rowPages.size()]), this.intermediateMerger.getMergedPages());
            }
            return this.finalMerger.hasNext();
        }

        public CarbonRowBatch next() {
            CarbonRowBatch rowBatch = new CarbonRowBatch(this.batchSize);
            for (int counter = 0; this.finalMerger.hasNext() && counter < this.batchSize; ++counter) {
                rowBatch.addRow(new CarbonRow(this.finalMerger.next()));
            }
            return rowBatch;
        }
    }

    private static class SortIteratorThread
    implements Runnable {
        private Iterator<CarbonRowBatch> iterator;
        private UnsafeSortDataRows[] sortDataRows;
        private AtomicLong rowCounter;
        private List<AtomicLong> insideRowCounterList;
        private ThreadStatusObserver threadStatusObserver;

        public SortIteratorThread(Iterator<CarbonRowBatch> iterator, UnsafeSortDataRows[] sortDataRows, AtomicLong rowCounter, List<AtomicLong> insideRowCounterList, ThreadStatusObserver threadStatusObserver) {
            this.iterator = iterator;
            this.sortDataRows = sortDataRows;
            this.rowCounter = rowCounter;
            this.insideRowCounterList = insideRowCounterList;
            this.threadStatusObserver = threadStatusObserver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (this.iterator.hasNext()) {
                    CarbonRowBatch batch = this.iterator.next();
                    while (batch.hasNext()) {
                        UnsafeSortDataRows sortDataRow;
                        CarbonRow row = batch.next();
                        if (row == null) continue;
                        UnsafeSortDataRows unsafeSortDataRows = sortDataRow = this.sortDataRows[row.getRangeId()];
                        synchronized (unsafeSortDataRows) {
                            this.rowCounter.getAndIncrement();
                            this.insideRowCounterList.get(row.getRangeId()).getAndIncrement();
                            sortDataRow.addRow(row.getData());
                        }
                    }
                }
                LOGGER.info("Rows processed by each range: " + this.insideRowCounterList);
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                this.threadStatusObserver.notifyFailed(e);
            }
        }
    }
}

