/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.sort.impl;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.exception.CarbonDataWriterException;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.row.CarbonRowBatch;
import org.apache.carbondata.processing.loading.row.CarbonSortBatch;
import org.apache.carbondata.processing.loading.sort.AbstractMergeSorter;
import org.apache.carbondata.processing.loading.sort.impl.ThreadStatusObserver;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeCarbonRowPage;
import org.apache.carbondata.processing.loading.sort.unsafe.UnsafeSortDataRows;
import org.apache.carbondata.processing.loading.sort.unsafe.merger.UnsafeIntermediateMerger;
import org.apache.carbondata.processing.loading.sort.unsafe.merger.UnsafeSingleThreadFinalSortFilesMerger;
import org.apache.carbondata.processing.sort.exception.CarbonSortKeyAndGroupByException;
import org.apache.carbondata.processing.sort.sortdata.SortParameters;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class UnsafeBatchParallelReadMergeSorterImpl
extends AbstractMergeSorter {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)UnsafeBatchParallelReadMergeSorterImpl.class.getName());
    private SortParameters sortParameters;
    private ExecutorService executorService;
    private AtomicLong rowCounter;
    private AtomicInteger batchId;

    public UnsafeBatchParallelReadMergeSorterImpl(AtomicLong rowCounter) {
        this.rowCounter = rowCounter;
    }

    @Override
    public void initialize(SortParameters sortParameters) {
        this.sortParameters = sortParameters;
        this.batchId = new AtomicInteger(0);
    }

    @Override
    public Iterator<CarbonRowBatch>[] sort(Iterator<CarbonRowBatch>[] iterators) throws CarbonDataLoadingException {
        this.executorService = Executors.newFixedThreadPool(iterators.length);
        this.threadStatusObserver = new ThreadStatusObserver(this.executorService);
        int batchSize = CarbonProperties.getInstance().getBatchSize();
        final SortBatchHolder sortBatchHolder = new SortBatchHolder(this.sortParameters, iterators.length, this.threadStatusObserver);
        try {
            for (int i = 0; i < iterators.length; ++i) {
                this.executorService.execute(new SortIteratorThread(iterators[i], sortBatchHolder, batchSize, this.rowCounter, this.threadStatusObserver));
            }
        }
        catch (Exception e) {
            this.checkError();
            throw new CarbonDataLoadingException("Problem while shutdown the server ", e);
        }
        this.checkError();
        CarbonIterator<CarbonSortBatch> batchIterator = new CarbonIterator<CarbonSortBatch>(){

            public boolean hasNext() {
                return sortBatchHolder.hasNext();
            }

            public CarbonSortBatch next() {
                return new CarbonSortBatch(sortBatchHolder.next());
            }
        };
        return new Iterator[]{batchIterator};
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(2L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            LOGGER.error((Throwable)e);
        }
    }

    private class SortBatchHolder
    extends CarbonIterator<UnsafeSingleThreadFinalSortFilesMerger> {
        private SortParameters sortParameters;
        private UnsafeSingleThreadFinalSortFilesMerger finalMerger;
        private UnsafeIntermediateMerger unsafeIntermediateFileMerger;
        private UnsafeSortDataRows sortDataRow;
        private final BlockingQueue<UnsafeSingleThreadFinalSortFilesMerger> mergerQueue;
        private AtomicInteger iteratorCount;
        private int batchCount;
        private ThreadStatusObserver threadStatusObserver;
        private final Object lock = new Object();

        SortBatchHolder(SortParameters sortParameters, int numberOfThreads, ThreadStatusObserver threadStatusObserver) {
            this.sortParameters = sortParameters.getCopy();
            this.iteratorCount = new AtomicInteger(numberOfThreads);
            this.mergerQueue = new LinkedBlockingQueue<UnsafeSingleThreadFinalSortFilesMerger>(1);
            this.threadStatusObserver = threadStatusObserver;
            this.createSortDataRows();
        }

        private void createSortDataRows() {
            this.sortParameters.setRangeId(UnsafeBatchParallelReadMergeSorterImpl.this.batchId.incrementAndGet());
            int inMemoryChunkSizeInMB = CarbonProperties.getInstance().getSortMemoryChunkSizeInMB();
            this.setTempLocation(this.sortParameters);
            this.finalMerger = new UnsafeSingleThreadFinalSortFilesMerger(this.sortParameters, this.sortParameters.getTempFileLocation());
            this.unsafeIntermediateFileMerger = new UnsafeIntermediateMerger(this.sortParameters);
            this.sortDataRow = new UnsafeSortDataRows(this.sortParameters, this.unsafeIntermediateFileMerger, inMemoryChunkSizeInMB);
            try {
                this.sortDataRow.initialize();
            }
            catch (Exception e) {
                throw new CarbonDataLoadingException(e);
            }
            ++this.batchCount;
        }

        private void setTempLocation(SortParameters parameters) {
            String[] carbonDataDirectoryPath = CarbonDataProcessorUtil.getLocalDataFolderLocation(parameters.getDatabaseName(), parameters.getTableName(), parameters.getTaskNo(), parameters.getSegmentId(), false, false);
            String[] tempDirs = CarbonDataProcessorUtil.arrayAppend(carbonDataDirectoryPath, File.separator, "sortrowtmp");
            parameters.setTempFileLocation(tempDirs);
        }

        public UnsafeSingleThreadFinalSortFilesMerger next() {
            try {
                UnsafeSingleThreadFinalSortFilesMerger unsafeSingleThreadFinalSortFilesMerger = this.mergerQueue.take();
                if (unsafeSingleThreadFinalSortFilesMerger.isStopProcess()) {
                    throw new RuntimeException(this.threadStatusObserver.getThrowable());
                }
                return unsafeSingleThreadFinalSortFilesMerger;
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public UnsafeSortDataRows getSortDataRow() {
            return this.sortDataRow;
        }

        public void finish(boolean isFinalAttempt) {
            try {
                if (this.mergerQueue.isEmpty() && this.threadStatusObserver != null && this.threadStatusObserver.getThrowable() != null && this.threadStatusObserver.getThrowable() instanceof CarbonDataLoadingException) {
                    this.finalMerger.setStopProcess(true);
                    if (isFinalAttempt) {
                        this.iteratorCount.decrementAndGet();
                    }
                    this.mergerQueue.put(this.finalMerger);
                    return;
                }
                this.processRowToNextStep(this.sortDataRow, this.sortParameters);
                this.unsafeIntermediateFileMerger.finish();
                List<UnsafeCarbonRowPage> rowPages = this.unsafeIntermediateFileMerger.getRowPages();
                this.finalMerger.startFinalMerge(rowPages.toArray(new UnsafeCarbonRowPage[rowPages.size()]), this.unsafeIntermediateFileMerger.getMergedPages());
                this.unsafeIntermediateFileMerger.close();
                if (isFinalAttempt) {
                    this.iteratorCount.decrementAndGet();
                }
                this.mergerQueue.put(this.finalMerger);
                this.sortDataRow = null;
                this.unsafeIntermediateFileMerger = null;
                this.finalMerger = null;
            }
            catch (CarbonDataWriterException e) {
                throw new CarbonDataLoadingException(e);
            }
            catch (CarbonSortKeyAndGroupByException e) {
                throw new CarbonDataLoadingException(e);
            }
            catch (InterruptedException e) {
                if (this.finalMerger != null) {
                    this.finalMerger.setStopProcess(true);
                    boolean offered = this.mergerQueue.offer(this.finalMerger);
                    if (!offered) {
                        throw new CarbonDataLoadingException(e);
                    }
                }
                throw new CarbonDataLoadingException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishThread() {
            Object object = this.lock;
            synchronized (object) {
                if (this.iteratorCount.get() <= 1) {
                    this.finish(true);
                } else {
                    this.iteratorCount.decrementAndGet();
                }
            }
        }

        public boolean hasNext() {
            return this.iteratorCount.get() > 0 || !this.mergerQueue.isEmpty();
        }

        private boolean processRowToNextStep(UnsafeSortDataRows sortDataRows, SortParameters parameters) throws CarbonDataLoadingException {
            try {
                sortDataRows.startSorting();
                LOGGER.info("Record Processed For table: " + parameters.getTableName());
                CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordSortRowsStepTotalTime(parameters.getPartitionID(), Long.valueOf(System.currentTimeMillis()));
                CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordDictionaryValuesTotalTime(parameters.getPartitionID(), Long.valueOf(System.currentTimeMillis()));
                return false;
            }
            catch (Exception e) {
                throw new CarbonDataLoadingException(e);
            }
        }
    }

    private static class SortIteratorThread
    implements Runnable {
        private Iterator<CarbonRowBatch> iterator;
        private SortBatchHolder sortDataRows;
        private Object[][] buffer;
        private AtomicLong rowCounter;
        private ThreadStatusObserver threadStatusObserver;

        public SortIteratorThread(Iterator<CarbonRowBatch> iterator, SortBatchHolder sortDataRows, int batchSize, AtomicLong rowCounter, ThreadStatusObserver threadStatusObserver) {
            this.iterator = iterator;
            this.sortDataRows = sortDataRows;
            this.buffer = new Object[batchSize][];
            this.rowCounter = rowCounter;
            this.threadStatusObserver = threadStatusObserver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (this.iterator.hasNext()) {
                    CarbonIterator batch = this.iterator.next();
                    int i = 0;
                    while (batch.hasNext()) {
                        CarbonRow row = batch.next();
                        if (row == null) continue;
                        this.buffer[i++] = row.getData();
                    }
                    if (i <= 0) continue;
                    SortBatchHolder sortBatchHolder = this.sortDataRows;
                    synchronized (sortBatchHolder) {
                        this.sortDataRows.getSortDataRow().addRowBatchWithOutSync(this.buffer, i);
                        this.rowCounter.getAndAdd(i);
                        if (!this.sortDataRows.getSortDataRow().canAdd()) {
                            this.sortDataRows.finish(false);
                            this.sortDataRows.createSortDataRows();
                        }
                    }
                }
                return;
            }
            catch (Exception e) {
                LOGGER.error((Throwable)e);
                this.threadStatusObserver.notifyFailed(e);
                return;
            }
            finally {
                SortBatchHolder sortBatchHolder = this.sortDataRows;
                synchronized (sortBatchHolder) {
                    this.sortDataRows.finishThread();
                }
            }
        }
    }
}

