/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.partition.impl;

import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.core.util.comparator.Comparator;
import org.apache.carbondata.core.util.comparator.SerializableComparator;

@InterfaceAudience.Internal
public class RawRowComparator
implements java.util.Comparator<CarbonRow> {
    private int[] sortColumnIndices;
    private boolean[] isSortColumnNoDict;
    private DataType[] noDicDataTypes;

    public RawRowComparator(int[] sortColumnIndices, boolean[] isSortColumnNoDict, DataType[] noDicDataTypes) {
        this.sortColumnIndices = sortColumnIndices;
        this.isSortColumnNoDict = isSortColumnNoDict;
        this.noDicDataTypes = noDicDataTypes;
    }

    @Override
    public int compare(CarbonRow o1, CarbonRow o2) {
        int diff = 0;
        int i = 0;
        int noDicIdx = 0;
        for (int colIdx : this.sortColumnIndices) {
            if (this.isSortColumnNoDict[i]) {
                if (DataTypeUtil.isPrimitiveColumn((DataType)this.noDicDataTypes[noDicIdx])) {
                    SerializableComparator comparator = Comparator.getComparator((DataType)this.noDicDataTypes[noDicIdx]);
                    int difference = comparator.compare(o1.getObject(colIdx), o2.getObject(colIdx));
                    if (difference != 0) {
                        return difference;
                    }
                } else {
                    byte[] colB;
                    byte[] colA = (byte[])o1.getObject(colIdx);
                    diff = ByteUtil.UnsafeComparer.INSTANCE.compareTo(colA, colB = (byte[])o2.getObject(colIdx));
                    if (diff != 0) {
                        return diff;
                    }
                }
                ++noDicIdx;
            } else {
                int colB;
                int colA = (Integer)o1.getObject(colIdx);
                diff = colA - (colB = ((Integer)o2.getObject(colIdx)).intValue());
                if (diff != 0) {
                    return diff;
                }
            }
            ++i;
        }
        return diff;
    }
}

