/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.model;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.Maps;
import org.apache.carbondata.common.Strings;
import org.apache.carbondata.common.annotations.InterfaceAudience;
import org.apache.carbondata.common.constants.LoggerAction;
import org.apache.carbondata.common.exceptions.sql.InvalidLoadOptionException;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.compression.CompressorFactory;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.processing.loading.model.CarbonDataLoadSchema;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.loading.model.LoadOption;
import org.apache.carbondata.processing.loading.sort.SortScopeOptions;
import org.apache.carbondata.processing.util.CarbonBadRecordUtil;
import org.apache.carbondata.processing.util.TableOptionConstant;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Internal
public class CarbonLoadModelBuilder {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonLoadModelBuilder.class.getName());
    private CarbonTable table;

    public CarbonLoadModelBuilder(CarbonTable table) {
        this.table = table;
    }

    public CarbonLoadModel build(Map<String, String> options, long timestamp, String taskNo) throws InvalidLoadOptionException, IOException {
        String dateFormat;
        Map<String, String> optionsFinal = LoadOption.fillOptionWithDefaultValue(options);
        if (!options.containsKey("fileheader")) {
            List csvHeader = this.table.getCreateOrderColumn(this.table.getTableName());
            String[] columns = new String[csvHeader.size()];
            for (int i = 0; i < columns.length; ++i) {
                columns[i] = ((CarbonColumn)csvHeader.get(i)).getColName();
            }
            optionsFinal.put("fileheader", Strings.mkString((String[])columns, (String)","));
        }
        optionsFinal.put("bad_record_path", CarbonBadRecordUtil.getBadRecordsPath(options, this.table));
        optionsFinal.put("sort_scope", (String)Maps.getOrDefault(options, (Object)"sort_scope", (Object)"LOCAL_SORT"));
        CarbonLoadModel model = new CarbonLoadModel();
        model.setCarbonTransactionalTable(this.table.isTransactionalTable());
        model.setFactTimeStamp(timestamp);
        model.setTaskNo(taskNo);
        this.build(options, optionsFinal, model, null);
        String timestampFormat = options.get("timestampformat");
        if (timestampFormat == null) {
            timestampFormat = CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss");
        }
        if ((dateFormat = options.get("dateFormat")) == null) {
            dateFormat = CarbonProperties.getInstance().getProperty("carbon.date.format", "yyyy-MM-dd");
        }
        model.setDateFormat(dateFormat);
        model.setTimestampformat(timestampFormat);
        model.setUseOnePass(Boolean.parseBoolean((String)Maps.getOrDefault(options, (Object)"onepass", (Object)"false")));
        model.setDictionaryServerHost((String)Maps.getOrDefault(options, (Object)"dicthost", null));
        try {
            model.setDictionaryServerPort(Integer.parseInt((String)Maps.getOrDefault(options, (Object)"dictport", (Object)"-1")));
        }
        catch (NumberFormatException e) {
            throw new InvalidLoadOptionException(e.getMessage());
        }
        this.validateAndSetColumnCompressor(model);
        return model;
    }

    public void build(Map<String, String> options, Map<String, String> optionsFinal, CarbonLoadModel carbonLoadModel, Configuration hadoopConf) throws InvalidLoadOptionException, IOException {
        this.build(options, optionsFinal, carbonLoadModel, hadoopConf, new HashMap<String, String>(), false);
    }

    /*
     * WARNING - void declaration
     */
    public void build(Map<String, String> options, Map<String, String> optionsFinal, CarbonLoadModel carbonLoadModel, Configuration hadoopConf, Map<String, String> partitions, boolean isDataFrame) throws InvalidLoadOptionException, IOException {
        carbonLoadModel.setTableName(this.table.getTableName());
        carbonLoadModel.setDatabaseName(this.table.getDatabaseName());
        carbonLoadModel.setTablePath(this.table.getTablePath());
        carbonLoadModel.setTableName(this.table.getTableName());
        carbonLoadModel.setCarbonTransactionalTable(this.table.isTransactionalTable());
        CarbonDataLoadSchema dataLoadSchema = new CarbonDataLoadSchema(this.table);
        carbonLoadModel.setCarbonDataLoadSchema(dataLoadSchema);
        String sort_scope = optionsFinal.get("sort_scope");
        String single_pass = optionsFinal.get("single_pass");
        String bad_records_logger_enable = optionsFinal.get("bad_records_logger_enable");
        String bad_records_action = optionsFinal.get("bad_records_action");
        String bad_record_path = optionsFinal.get("bad_record_path");
        String global_sort_partitions = optionsFinal.get("global_sort_partitions");
        String timestampformat = optionsFinal.get("timestampformat");
        String dateFormat = optionsFinal.get("dateformat");
        String delimeter = optionsFinal.get("delimiter");
        String complex_delimeter_level1 = optionsFinal.get("complex_delimiter_level_1");
        String complex_delimeter_level2 = optionsFinal.get("complex_delimiter_level_2");
        String all_dictionary_path = optionsFinal.get("all_dictionary_path");
        String column_dict = optionsFinal.get("columndict");
        this.validateDateTimeFormat(timestampformat, "TimestampFormat");
        this.validateDateTimeFormat(dateFormat, "DateFormat");
        this.validateSortScope(sort_scope);
        if (Boolean.parseBoolean(bad_records_logger_enable) || LoggerAction.REDIRECT.name().equalsIgnoreCase(bad_records_action)) {
            if (!StringUtils.isEmpty((String)bad_record_path)) {
                bad_record_path = CarbonUtil.checkAndAppendHDFSUrl((String)bad_record_path);
            } else {
                throw new InvalidLoadOptionException("Cannot redirect bad records as bad record location is not provided.");
            }
        }
        carbonLoadModel.setBadRecordsLocation(bad_record_path);
        this.validateGlobalSortPartitions(global_sort_partitions);
        carbonLoadModel.setEscapeChar(this.checkDefaultValue(optionsFinal.get("escapechar"), "\\"));
        carbonLoadModel.setQuoteChar(this.checkDefaultValue(optionsFinal.get("quotechar"), "\""));
        carbonLoadModel.setCommentChar(this.checkDefaultValue(optionsFinal.get("commentchar"), "#"));
        String fileHeader = optionsFinal.get("fileheader");
        String headerOption = options.get("header");
        if (headerOption != null) {
            if (!headerOption.equalsIgnoreCase("true") && !headerOption.equalsIgnoreCase("false")) {
                throw new InvalidLoadOptionException("'header' option should be either 'true' or 'false'.");
            }
            if (Boolean.valueOf(headerOption).booleanValue()) {
                if (!StringUtils.isEmpty((String)fileHeader)) {
                    throw new InvalidLoadOptionException("When 'header' option is true, 'fileheader' option is not required.");
                }
            } else if (StringUtils.isEmpty((String)fileHeader)) {
                void var25_27;
                List columns = this.table.getCreateOrderColumn(this.table.getTableName());
                String[] columnNames = new String[columns.size()];
                boolean bl = false;
                while (var25_27 < columnNames.length) {
                    columnNames[var25_27] = ((CarbonColumn)columns.get((int)var25_27)).getColName();
                    ++var25_27;
                }
                fileHeader = Strings.mkString((String[])columnNames, (String)",");
            }
        }
        carbonLoadModel.setTimestampformat(timestampformat);
        carbonLoadModel.setDateFormat(dateFormat);
        carbonLoadModel.setDefaultTimestampFormat(CarbonProperties.getInstance().getProperty("carbon.timestamp.format", "yyyy-MM-dd HH:mm:ss"));
        carbonLoadModel.setDefaultDateFormat(CarbonProperties.getInstance().getProperty("carbon.date.format", "yyyy-MM-dd"));
        carbonLoadModel.setSerializationNullFormat(TableOptionConstant.SERIALIZATION_NULL_FORMAT.getName() + "," + optionsFinal.get("serialization_null_format"));
        carbonLoadModel.setBadRecordsLoggerEnable(TableOptionConstant.BAD_RECORDS_LOGGER_ENABLE.getName() + "," + bad_records_logger_enable);
        carbonLoadModel.setBadRecordsAction(TableOptionConstant.BAD_RECORDS_ACTION.getName() + "," + bad_records_action.toUpperCase());
        carbonLoadModel.setIsEmptyDataBadRecord("IS_EMPTY_DATA_BAD_RECORD," + optionsFinal.get("is_empty_data_bad_record"));
        carbonLoadModel.setSkipEmptyLine(optionsFinal.get("skip_empty_line"));
        carbonLoadModel.setSortScope(sort_scope);
        carbonLoadModel.setBatchSortSizeInMb(optionsFinal.get("batch_sort_size_inmb"));
        carbonLoadModel.setGlobalSortPartitions(global_sort_partitions);
        carbonLoadModel.setUseOnePass(Boolean.parseBoolean(single_pass));
        if (delimeter.equalsIgnoreCase(complex_delimeter_level1) || complex_delimeter_level1.equalsIgnoreCase(complex_delimeter_level2) || delimeter.equalsIgnoreCase(complex_delimeter_level2)) {
            throw new InvalidLoadOptionException("Field Delimiter and Complex types delimiter are same");
        }
        carbonLoadModel.setComplexDelimiterLevel1(complex_delimeter_level1);
        carbonLoadModel.setComplexDelimiterLevel2(complex_delimeter_level2);
        carbonLoadModel.setAllDictPath(all_dictionary_path);
        carbonLoadModel.setCsvDelimiter(CarbonUtil.unescapeChar((String)delimeter));
        carbonLoadModel.setCsvHeader(fileHeader);
        carbonLoadModel.setColDictFilePath(column_dict);
        ArrayList<String> ignoreColumns = new ArrayList<String>();
        if (!isDataFrame) {
            for (Map.Entry entry : partitions.entrySet()) {
                if (entry.getValue() == null) continue;
                ignoreColumns.add((String)entry.getKey());
            }
        }
        carbonLoadModel.setCsvHeaderColumns(LoadOption.getCsvHeaderColumns(carbonLoadModel, hadoopConf, ignoreColumns));
        int validatedMaxColumns = this.validateMaxColumns(carbonLoadModel.getCsvHeaderColumns(), optionsFinal.get("maxcolumns"));
        carbonLoadModel.setMaxColumns(String.valueOf(validatedMaxColumns));
        if (carbonLoadModel.isCarbonTransactionalTable()) {
            carbonLoadModel.readAndSetLoadMetadataDetails();
        }
        carbonLoadModel.setSortColumnsBoundsStr(optionsFinal.get("sort_column_bounds"));
        carbonLoadModel.setLoadMinSize(optionsFinal.get("load_min_size_inmb"));
        this.validateAndSetColumnCompressor(carbonLoadModel);
    }

    private int validateMaxColumns(String[] csvHeaders, String maxColumns) throws InvalidLoadOptionException {
        int columnCountInSchema = csvHeaders.length;
        int maxNumberOfColumnsForParsing = 0;
        Integer maxColumnsInt = this.getMaxColumnValue(maxColumns);
        if (maxColumnsInt != null) {
            if (columnCountInSchema >= maxColumnsInt) {
                throw new InvalidLoadOptionException("csv headers should be less than the max columns " + maxColumnsInt);
            }
            if (maxColumnsInt > 20000) {
                throw new InvalidLoadOptionException("max columns cannot be greater than the threshold value: 20000");
            }
            maxNumberOfColumnsForParsing = maxColumnsInt;
        } else {
            if (columnCountInSchema >= 20000) {
                throw new InvalidLoadOptionException("csv header columns should be less than max threashold: 20000");
            }
            maxNumberOfColumnsForParsing = columnCountInSchema >= 2000 ? columnCountInSchema + 1 : 2000;
        }
        return maxNumberOfColumnsForParsing;
    }

    private Integer getMaxColumnValue(String maxColumn) {
        return maxColumn == null ? null : Integer.valueOf(Integer.parseInt(maxColumn));
    }

    private void validateDateTimeFormat(String dateTimeLoadFormat, String dateTimeLoadOption) throws InvalidLoadOptionException {
        if (dateTimeLoadFormat != null && !dateTimeLoadFormat.trim().equalsIgnoreCase("")) {
            try {
                new SimpleDateFormat(dateTimeLoadFormat);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidLoadOptionException("Error: Wrong option: " + dateTimeLoadFormat + " is provided for option " + dateTimeLoadOption);
            }
        }
    }

    private void validateSortScope(String sortScope) throws InvalidLoadOptionException {
        if (sortScope != null && this.table.getPartitionInfo(this.table.getTableName()) != null && !this.table.isHivePartitionTable() && sortScope.equalsIgnoreCase(SortScopeOptions.SortScope.GLOBAL_SORT.toString())) {
            throw new InvalidLoadOptionException("Don't support use global sort on " + this.table.getPartitionInfo().getPartitionType() + " partition table.");
        }
    }

    private void validateGlobalSortPartitions(String globalSortPartitions) throws InvalidLoadOptionException {
        if (globalSortPartitions != null) {
            try {
                int num = Integer.parseInt(globalSortPartitions);
                if (num <= 0) {
                    throw new InvalidLoadOptionException("'GLOBAL_SORT_PARTITIONS' should be greater than 0");
                }
            }
            catch (NumberFormatException e) {
                throw new InvalidLoadOptionException(e.getMessage());
            }
        }
    }

    private void validateAndSetColumnCompressor(CarbonLoadModel carbonLoadModel) throws InvalidLoadOptionException {
        try {
            String columnCompressor = carbonLoadModel.getColumnCompressor();
            if (StringUtils.isBlank((String)columnCompressor)) {
                columnCompressor = CarbonProperties.getInstance().getProperty("carbon.column.compressor", "snappy");
            }
            CompressorFactory.getInstance().getCompressor(columnCompressor);
            carbonLoadModel.setColumnCompressor(columnCompressor);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw new InvalidLoadOptionException("Failed to load the compressor");
        }
    }

    private String checkDefaultValue(String value, String defaultValue) {
        if (StringUtils.isEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }
}

