/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.carbondata.core.datamap.Segment;
import org.apache.carbondata.core.dictionary.service.DictionaryServiceProvider;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.statusmanager.SegmentUpdateStatusManager;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.processing.loading.model.CarbonDataLoadSchema;

public class CarbonLoadModel
implements Serializable {
    private static final long serialVersionUID = 6580168429197697465L;
    private String databaseName;
    private String tableName;
    private String factFilePath;
    private String colDictFilePath;
    private CarbonDataLoadSchema carbonDataLoadSchema;
    private boolean aggLoadRequest;
    private String tablePath;
    private String parentTablePath;
    private boolean carbonTransactionalTable = true;
    private short sdkWriterCores;
    private String csvHeader;
    private String[] csvHeaderColumns;
    private String csvDelimiter;
    private String complexDelimiterLevel1;
    private String complexDelimiterLevel2;
    private List<LoadMetadataDetails> loadMetadataDetails;
    private transient SegmentUpdateStatusManager segmentUpdateStatusManager;
    private String blocksID;
    private HashMap<CarbonDimension, String> predefDictMap;
    private String taskNo;
    private long factTimeStamp;
    private Segment segment;
    private String allDictPath;
    private String escapeChar;
    private String quoteChar;
    private String commentChar;
    private String timestampformat;
    private String dateFormat;
    private String defaultTimestampFormat;
    private String defaultDateFormat;
    private String serializationNullFormat;
    private String badRecordsLoggerEnable;
    private String badRecordsAction;
    private String maxColumns;
    private String isEmptyDataBadRecord;
    private String skipEmptyLine;
    private boolean useOnePass;
    private String dictionaryServerHost;
    private int dictionaryServerPort;
    private String dictionaryServerSecretKey;
    private DictionaryServiceProvider dictionaryServiceProvider;
    private Boolean dictionaryEncryptServerSecure;
    private boolean preFetch;
    private String sortScope;
    private String batchSortSizeInMb;
    private String badRecordsLocation;
    private String globalSortPartitions;
    private boolean isAggLoadRequest;
    private String sortColumnsBoundsStr;
    private boolean isLoadWithoutConverterStep;
    private boolean isJsonFileLoad;
    private String dataWritePath;
    private String loadMinSize;
    private List<String> mergedSegmentIds;
    private String columnCompressor;

    public boolean isAggLoadRequest() {
        return this.isAggLoadRequest;
    }

    public void setAggLoadRequest(boolean aggLoadRequest) {
        this.isAggLoadRequest = aggLoadRequest;
    }

    public String getParentTablePath() {
        return this.parentTablePath;
    }

    public void setParentTablePath(String parentTablePath) {
        this.parentTablePath = parentTablePath;
    }

    public String getEscapeChar() {
        return this.escapeChar;
    }

    public void setEscapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
    }

    public String getCsvDelimiter() {
        return this.csvDelimiter;
    }

    public void setCsvDelimiter(String csvDelimiter) {
        this.csvDelimiter = csvDelimiter;
    }

    public String getComplexDelimiterLevel1() {
        return this.complexDelimiterLevel1;
    }

    public void setComplexDelimiterLevel1(String complexDelimiterLevel1) {
        this.complexDelimiterLevel1 = complexDelimiterLevel1;
    }

    public String getComplexDelimiterLevel2() {
        return this.complexDelimiterLevel2;
    }

    public void setComplexDelimiterLevel2(String complexDelimiterLevel2) {
        this.complexDelimiterLevel2 = complexDelimiterLevel2;
    }

    public String getAllDictPath() {
        return this.allDictPath;
    }

    public void setAllDictPath(String allDictPath) {
        this.allDictPath = allDictPath;
    }

    public String getCsvHeader() {
        return this.csvHeader;
    }

    public void setCsvHeader(String csvHeader) {
        this.csvHeader = csvHeader;
    }

    public String[] getCsvHeaderColumns() {
        return this.csvHeaderColumns;
    }

    public void setCsvHeaderColumns(String[] csvHeaderColumns) {
        this.csvHeaderColumns = csvHeaderColumns;
    }

    public void initPredefDictMap() {
        this.predefDictMap = new HashMap();
    }

    public String getPredefDictFilePath(CarbonDimension dimension) {
        return this.predefDictMap.get(dimension);
    }

    public void setPredefDictMap(CarbonDimension dimension, String predefDictFilePath) {
        this.predefDictMap.put(dimension, predefDictFilePath);
    }

    public CarbonDataLoadSchema getCarbonDataLoadSchema() {
        return this.carbonDataLoadSchema;
    }

    public void setCarbonDataLoadSchema(CarbonDataLoadSchema carbonDataLoadSchema) {
        this.carbonDataLoadSchema = carbonDataLoadSchema;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getFactFilePath() {
        return this.factFilePath;
    }

    public void setFactFilePath(String factFilePath) {
        this.factFilePath = factFilePath;
    }

    public String getColDictFilePath() {
        return this.colDictFilePath;
    }

    public void setColDictFilePath(String colDictFilePath) {
        this.colDictFilePath = colDictFilePath;
    }

    public DictionaryServiceProvider getDictionaryServiceProvider() {
        return this.dictionaryServiceProvider;
    }

    public void setDictionaryServiceProvider(DictionaryServiceProvider dictionaryServiceProvider) {
        this.dictionaryServiceProvider = dictionaryServiceProvider;
    }

    public String getSortColumnsBoundsStr() {
        return this.sortColumnsBoundsStr;
    }

    public void setSortColumnsBoundsStr(String sortColumnsBoundsStr) {
        this.sortColumnsBoundsStr = sortColumnsBoundsStr;
    }

    public String getLoadMinSize() {
        return this.loadMinSize;
    }

    public void setLoadMinSize(String loadMinSize) {
        this.loadMinSize = loadMinSize;
    }

    public CarbonLoadModel getCopyWithTaskNo(String taskNo) {
        CarbonLoadModel copy = new CarbonLoadModel();
        copy.tableName = this.tableName;
        copy.factFilePath = this.factFilePath;
        copy.databaseName = this.databaseName;
        copy.aggLoadRequest = this.aggLoadRequest;
        copy.loadMetadataDetails = this.loadMetadataDetails;
        copy.csvHeader = this.csvHeader;
        copy.csvHeaderColumns = this.csvHeaderColumns;
        copy.csvDelimiter = this.csvDelimiter;
        copy.complexDelimiterLevel1 = this.complexDelimiterLevel1;
        copy.complexDelimiterLevel2 = this.complexDelimiterLevel2;
        copy.carbonDataLoadSchema = this.carbonDataLoadSchema;
        copy.blocksID = this.blocksID;
        copy.taskNo = taskNo;
        copy.factTimeStamp = this.factTimeStamp;
        copy.segment = this.segment;
        copy.serializationNullFormat = this.serializationNullFormat;
        copy.badRecordsLoggerEnable = this.badRecordsLoggerEnable;
        copy.badRecordsAction = this.badRecordsAction;
        copy.escapeChar = this.escapeChar;
        copy.quoteChar = this.quoteChar;
        copy.commentChar = this.commentChar;
        copy.timestampformat = this.timestampformat;
        copy.dateFormat = this.dateFormat;
        copy.defaultTimestampFormat = this.defaultTimestampFormat;
        copy.maxColumns = this.maxColumns;
        copy.tablePath = this.tablePath;
        copy.carbonTransactionalTable = this.carbonTransactionalTable;
        copy.useOnePass = this.useOnePass;
        copy.dictionaryServerHost = this.dictionaryServerHost;
        copy.dictionaryServerPort = this.dictionaryServerPort;
        copy.dictionaryServerSecretKey = this.dictionaryServerSecretKey;
        copy.dictionaryServiceProvider = this.dictionaryServiceProvider;
        copy.dictionaryEncryptServerSecure = this.dictionaryEncryptServerSecure;
        copy.preFetch = this.preFetch;
        copy.isEmptyDataBadRecord = this.isEmptyDataBadRecord;
        copy.skipEmptyLine = this.skipEmptyLine;
        copy.sortScope = this.sortScope;
        copy.batchSortSizeInMb = this.batchSortSizeInMb;
        copy.isAggLoadRequest = this.isAggLoadRequest;
        copy.badRecordsLocation = this.badRecordsLocation;
        copy.isLoadWithoutConverterStep = this.isLoadWithoutConverterStep;
        copy.sortColumnsBoundsStr = this.sortColumnsBoundsStr;
        copy.loadMinSize = this.loadMinSize;
        copy.parentTablePath = this.parentTablePath;
        copy.sdkWriterCores = this.sdkWriterCores;
        copy.columnCompressor = this.columnCompressor;
        return copy;
    }

    public CarbonLoadModel getCopyWithPartition(String header, String delimiter) {
        CarbonLoadModel copyObj = new CarbonLoadModel();
        copyObj.tableName = this.tableName;
        copyObj.factFilePath = null;
        copyObj.databaseName = this.databaseName;
        copyObj.aggLoadRequest = this.aggLoadRequest;
        copyObj.loadMetadataDetails = this.loadMetadataDetails;
        copyObj.carbonDataLoadSchema = this.carbonDataLoadSchema;
        copyObj.csvHeader = header;
        copyObj.csvHeaderColumns = this.csvHeaderColumns;
        copyObj.csvDelimiter = delimiter;
        copyObj.complexDelimiterLevel1 = this.complexDelimiterLevel1;
        copyObj.complexDelimiterLevel2 = this.complexDelimiterLevel2;
        copyObj.blocksID = this.blocksID;
        copyObj.taskNo = this.taskNo;
        copyObj.factTimeStamp = this.factTimeStamp;
        copyObj.segment = this.segment;
        copyObj.serializationNullFormat = this.serializationNullFormat;
        copyObj.badRecordsLoggerEnable = this.badRecordsLoggerEnable;
        copyObj.badRecordsAction = this.badRecordsAction;
        copyObj.escapeChar = this.escapeChar;
        copyObj.quoteChar = this.quoteChar;
        copyObj.commentChar = this.commentChar;
        copyObj.timestampformat = this.timestampformat;
        copyObj.dateFormat = this.dateFormat;
        copyObj.defaultTimestampFormat = this.defaultTimestampFormat;
        copyObj.maxColumns = this.maxColumns;
        copyObj.tablePath = this.tablePath;
        copyObj.carbonTransactionalTable = this.carbonTransactionalTable;
        copyObj.useOnePass = this.useOnePass;
        copyObj.dictionaryServerHost = this.dictionaryServerHost;
        copyObj.dictionaryServerPort = this.dictionaryServerPort;
        copyObj.dictionaryServerSecretKey = this.dictionaryServerSecretKey;
        copyObj.dictionaryServiceProvider = this.dictionaryServiceProvider;
        copyObj.dictionaryEncryptServerSecure = this.dictionaryEncryptServerSecure;
        copyObj.preFetch = this.preFetch;
        copyObj.isEmptyDataBadRecord = this.isEmptyDataBadRecord;
        copyObj.skipEmptyLine = this.skipEmptyLine;
        copyObj.sortScope = this.sortScope;
        copyObj.batchSortSizeInMb = this.batchSortSizeInMb;
        copyObj.badRecordsLocation = this.badRecordsLocation;
        copyObj.isAggLoadRequest = this.isAggLoadRequest;
        copyObj.sortColumnsBoundsStr = this.sortColumnsBoundsStr;
        copyObj.loadMinSize = this.loadMinSize;
        copyObj.parentTablePath = this.parentTablePath;
        copyObj.sdkWriterCores = this.sdkWriterCores;
        copyObj.columnCompressor = this.columnCompressor;
        return copyObj;
    }

    public void setTablePath(String tablePath) {
        this.tablePath = tablePath;
    }

    public String getTablePath() {
        return this.tablePath;
    }

    public List<LoadMetadataDetails> getLoadMetadataDetails() {
        return this.loadMetadataDetails;
    }

    public LoadMetadataDetails getCurrentLoadMetadataDetail() {
        if (this.loadMetadataDetails != null && this.loadMetadataDetails.size() > 0) {
            return this.loadMetadataDetails.get(this.loadMetadataDetails.size() - 1);
        }
        return null;
    }

    public void setLoadMetadataDetails(List<LoadMetadataDetails> loadMetadataDetails) {
        this.loadMetadataDetails = loadMetadataDetails;
    }

    public SegmentUpdateStatusManager getSegmentUpdateStatusManager() {
        return this.segmentUpdateStatusManager;
    }

    public void setSegmentUpdateStatusManager(SegmentUpdateStatusManager segmentUpdateStatusManager) {
        this.segmentUpdateStatusManager = segmentUpdateStatusManager;
    }

    public String getTaskNo() {
        return this.taskNo;
    }

    public void setTaskNo(String taskNo) {
        this.taskNo = taskNo;
    }

    public long getFactTimeStamp() {
        return this.factTimeStamp;
    }

    public void setFactTimeStamp(long factTimeStamp) {
        this.factTimeStamp = factTimeStamp;
    }

    public String[] getDelimiters() {
        return new String[]{this.complexDelimiterLevel1, this.complexDelimiterLevel2};
    }

    public String getSegmentId() {
        if (this.segment != null) {
            return this.segment.getSegmentNo();
        }
        return null;
    }

    public void setSegmentId(String segmentId) {
        if (segmentId != null) {
            this.segment = Segment.toSegment((String)segmentId);
        }
    }

    public Segment getSegment() {
        return this.segment;
    }

    public String getSerializationNullFormat() {
        return this.serializationNullFormat;
    }

    public void setSerializationNullFormat(String serializationNullFormat) {
        this.serializationNullFormat = serializationNullFormat;
    }

    public String getBadRecordsLoggerEnable() {
        return this.badRecordsLoggerEnable;
    }

    public void setBadRecordsLoggerEnable(String badRecordsLoggerEnable) {
        this.badRecordsLoggerEnable = badRecordsLoggerEnable;
    }

    public String getQuoteChar() {
        return this.quoteChar;
    }

    public void setQuoteChar(String quoteChar) {
        this.quoteChar = quoteChar;
    }

    public String getCommentChar() {
        return this.commentChar;
    }

    public void setCommentChar(String commentChar) {
        this.commentChar = commentChar;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDefaultTimestampFormat() {
        return this.defaultTimestampFormat;
    }

    public void setDefaultTimestampFormat(String defaultTimestampFormat) {
        this.defaultTimestampFormat = defaultTimestampFormat;
    }

    public String getMaxColumns() {
        return this.maxColumns;
    }

    public void setMaxColumns(String maxColumns) {
        this.maxColumns = maxColumns;
    }

    public String getBadRecordsAction() {
        return this.badRecordsAction;
    }

    public void setBadRecordsAction(String badRecordsAction) {
        this.badRecordsAction = badRecordsAction;
    }

    public boolean getUseOnePass() {
        return this.useOnePass;
    }

    public void setUseOnePass(boolean useOnePass) {
        this.useOnePass = useOnePass;
    }

    public int getDictionaryServerPort() {
        return this.dictionaryServerPort;
    }

    public void setDictionaryServerPort(int dictionaryServerPort) {
        this.dictionaryServerPort = dictionaryServerPort;
    }

    public String getDictionaryServerSecretKey() {
        return this.dictionaryServerSecretKey;
    }

    public void setDictionaryServerSecretKey(String dictionaryServerSecretKey) {
        this.dictionaryServerSecretKey = dictionaryServerSecretKey;
    }

    public Boolean getDictionaryEncryptServerSecure() {
        return this.dictionaryEncryptServerSecure;
    }

    public void setDictionaryEncryptServerSecure(Boolean dictionaryEncryptServerSecure) {
        this.dictionaryEncryptServerSecure = dictionaryEncryptServerSecure;
    }

    public String getDictionaryServerHost() {
        return this.dictionaryServerHost;
    }

    public void setDictionaryServerHost(String dictionaryServerHost) {
        this.dictionaryServerHost = dictionaryServerHost;
    }

    public boolean isPreFetch() {
        return this.preFetch;
    }

    public void setPreFetch(boolean preFetch) {
        this.preFetch = preFetch;
    }

    public String getDefaultDateFormat() {
        return this.defaultDateFormat;
    }

    public void setDefaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
    }

    public String getIsEmptyDataBadRecord() {
        return this.isEmptyDataBadRecord;
    }

    public void setIsEmptyDataBadRecord(String isEmptyDataBadRecord) {
        this.isEmptyDataBadRecord = isEmptyDataBadRecord;
    }

    public String getSortScope() {
        return this.sortScope;
    }

    public void setSortScope(String sortScope) {
        this.sortScope = sortScope;
    }

    public String getBatchSortSizeInMb() {
        return this.batchSortSizeInMb;
    }

    public void setBatchSortSizeInMb(String batchSortSizeInMb) {
        this.batchSortSizeInMb = batchSortSizeInMb;
    }

    public String getGlobalSortPartitions() {
        return this.globalSortPartitions;
    }

    public void setGlobalSortPartitions(String globalSortPartitions) {
        this.globalSortPartitions = globalSortPartitions;
    }

    public String getBadRecordsLocation() {
        return this.badRecordsLocation;
    }

    public void setBadRecordsLocation(String badRecordsLocation) {
        this.badRecordsLocation = badRecordsLocation;
    }

    public String getTimestampformat() {
        return this.timestampformat;
    }

    public void setTimestampformat(String timestampformat) {
        this.timestampformat = timestampformat;
    }

    public String getSkipEmptyLine() {
        return this.skipEmptyLine;
    }

    public void setSkipEmptyLine(String skipEmptyLine) {
        this.skipEmptyLine = skipEmptyLine;
    }

    public boolean isLoadWithoutConverterStep() {
        return this.isLoadWithoutConverterStep;
    }

    public void setLoadWithoutConverterStep(boolean loadWithoutConverterStep) {
        this.isLoadWithoutConverterStep = loadWithoutConverterStep;
    }

    public boolean isJsonFileLoad() {
        return this.isJsonFileLoad;
    }

    public void setJsonFileLoad(boolean isJsonFileLoad) {
        this.isJsonFileLoad = isJsonFileLoad;
    }

    public String getDataWritePath() {
        return this.dataWritePath;
    }

    public void setDataWritePath(String dataWritePath) {
        this.dataWritePath = dataWritePath;
    }

    public void readAndSetLoadMetadataDetails() {
        String metadataPath = CarbonTablePath.getMetadataPath((String)this.tablePath);
        LoadMetadataDetails[] details = SegmentStatusManager.readLoadMetadata((String)metadataPath);
        this.setLoadMetadataDetails(Arrays.asList(details));
    }

    public boolean isCarbonTransactionalTable() {
        return this.carbonTransactionalTable;
    }

    public void setCarbonTransactionalTable(boolean carbonTransactionalTable) {
        this.carbonTransactionalTable = carbonTransactionalTable;
    }

    public void setMergedSegmentIds(List<String> mergedSegmentIds) {
        this.mergedSegmentIds = mergedSegmentIds;
    }

    public List<String> getMergedSegmentIds() {
        if (null == this.mergedSegmentIds) {
            this.mergedSegmentIds = new ArrayList<String>(16);
        }
        return this.mergedSegmentIds;
    }

    public short getSdkWriterCores() {
        return this.sdkWriterCores;
    }

    public void setSdkWriterCores(short sdkWriterCores) {
        this.sdkWriterCores = sdkWriterCores;
    }

    public String getColumnCompressor() {
        return this.columnCompressor;
    }

    public void setColumnCompressor(String columnCompressor) {
        this.columnCompressor = columnCompressor;
    }
}

