/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.dictionary;

import org.apache.carbondata.core.devapi.BiDictionary;
import org.apache.carbondata.core.devapi.DictionaryGenerationException;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryGenerator;

public class DirectDictionary
implements BiDictionary<Integer, Object> {
    private DirectDictionaryGenerator dictionaryGenerator;

    public DirectDictionary(DirectDictionaryGenerator dictionaryGenerator) {
        this.dictionaryGenerator = dictionaryGenerator;
    }

    public Integer getOrGenerateKey(Object value) throws DictionaryGenerationException {
        Integer key = this.getKey(value);
        if (key == null) {
            throw new UnsupportedOperationException("trying to add new entry in DirectDictionary");
        }
        return key;
    }

    public Integer getKey(Object value) {
        return this.dictionaryGenerator.generateDirectSurrogateKey(value.toString());
    }

    public Integer generateKey(long value) {
        return this.dictionaryGenerator.generateKey(value);
    }

    public Object getValue(Integer key) {
        return this.dictionaryGenerator.getValueFromSurrogate(key.intValue());
    }

    public int size() {
        return Integer.MAX_VALUE;
    }
}

