/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.csvinput;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public class StringArrayWritable
implements Writable {
    private String[] values;

    public String[] toStrings() {
        return this.values;
    }

    public void set(String[] values) {
        this.values = values;
    }

    public String[] get() {
        return this.values;
    }

    public void readFields(DataInput in) throws IOException {
        int length = in.readInt();
        this.values = new String[length];
        for (int i = 0; i < length; ++i) {
            byte[] b = new byte[in.readInt()];
            in.readFully(b);
            this.values[i] = new String(b, Charset.defaultCharset());
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.values.length);
        for (int i = 0; i < this.values.length; ++i) {
            byte[] b = this.values[i].getBytes(Charset.defaultCharset());
            out.writeInt(b.length);
            out.write(b);
        }
    }

    public String toString() {
        return Arrays.toString(this.values);
    }
}

