/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.csvinput;

import java.io.Serializable;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

public class BlockDetails
extends FileSplit
implements Serializable {
    private static final long serialVersionUID = 2293906691860002339L;
    private long blockOffset;
    private long blockLength;
    private String filePath;
    private String[] locations;

    public BlockDetails(Path filePath, long blockOffset, long blockLength, String[] locations) {
        super(filePath, blockOffset, blockLength, locations);
        this.filePath = filePath.toString();
        this.blockOffset = blockOffset;
        this.blockLength = blockLength;
        this.locations = locations;
    }

    public long getBlockOffset() {
        return this.blockOffset;
    }

    public long getBlockLength() {
        return this.blockLength;
    }

    public String getFilePath() {
        return FileFactory.getUpdatedFilePath((String)this.filePath);
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public Path getPath() {
        return new Path(this.filePath);
    }

    public long getStart() {
        return this.blockOffset;
    }

    public long getLength() {
        return this.blockLength;
    }
}

