/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.dictionary.client.DictionaryClient;
import org.apache.carbondata.core.dictionary.service.DictionaryOnePassService;
import org.apache.carbondata.core.dictionary.service.DictionaryServiceProvider;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.core.util.CarbonTimeStatisticsFactory;
import org.apache.carbondata.processing.loading.BadRecordsLogger;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.FieldConverter;
import org.apache.carbondata.processing.loading.converter.RowConverter;
import org.apache.carbondata.processing.loading.converter.impl.AbstractDictionaryFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.FieldEncoderFactory;
import org.apache.carbondata.processing.loading.exception.BadRecordFoundException;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;

public class RowConverterImpl
implements RowConverter {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)RowConverterImpl.class.getName());
    private CarbonDataLoadConfiguration configuration;
    private DataField[] fields;
    private FieldConverter[] fieldConverters;
    private BadRecordsLogger badRecordLogger;
    private BadRecordLogHolder logHolder;
    private List<DictionaryClient> dictClients = new ArrayList<DictionaryClient>();
    private ExecutorService executorService;
    private Map<Object, Integer>[] localCaches;
    private boolean isConvertToBinary;

    public RowConverterImpl(DataField[] fields, CarbonDataLoadConfiguration configuration, BadRecordsLogger badRecordLogger) {
        this.fields = fields;
        this.configuration = configuration;
        this.badRecordLogger = badRecordLogger;
    }

    public RowConverterImpl(DataField[] fields, CarbonDataLoadConfiguration configuration, BadRecordsLogger badRecordLogger, boolean isConvertToBinary) {
        this.fields = fields;
        this.configuration = configuration;
        this.badRecordLogger = badRecordLogger;
        this.isConvertToBinary = isConvertToBinary;
    }

    @Override
    public void initialize() throws IOException {
        String nullFormat = this.configuration.getDataLoadProperty("SERIALIZATION_NULL_FORMAT").toString();
        boolean isEmptyBadRecord = Boolean.parseBoolean(this.configuration.getDataLoadProperty("IS_EMPTY_DATA_BAD_RECORD").toString());
        ArrayList<FieldConverter> fieldConverterList = new ArrayList<FieldConverter>();
        this.localCaches = new Map[this.fields.length];
        long lruCacheStartTime = System.currentTimeMillis();
        DictionaryClient client = this.createDictionaryClient();
        this.dictClients.add(client);
        for (int i = 0; i < this.fields.length; ++i) {
            this.localCaches[i] = new ConcurrentHashMap<Object, Integer>();
            FieldConverter fieldConverter = FieldEncoderFactory.getInstance().createFieldEncoder(this.fields[i], this.configuration.getTableIdentifier(), i, nullFormat, client, this.configuration.getUseOnePass(), this.localCaches[i], isEmptyBadRecord, this.configuration.getParentTablePath(), this.isConvertToBinary);
            fieldConverterList.add(fieldConverter);
        }
        CarbonTimeStatisticsFactory.getLoadStatisticsInstance().recordLruCacheLoadTime((double)(System.currentTimeMillis() - lruCacheStartTime) / 1000.0);
        this.fieldConverters = fieldConverterList.toArray(new FieldConverter[fieldConverterList.size()]);
        this.logHolder = new BadRecordLogHolder();
    }

    private DictionaryClient createDictionaryClient() {
        if (this.configuration.getUseOnePass()) {
            if (this.executorService == null) {
                this.executorService = Executors.newCachedThreadPool((ThreadFactory)new CarbonThreadFactory("DictionaryClientPool:" + this.configuration.getTableIdentifier().getCarbonTableIdentifier().getTableName()));
            }
            DictionaryOnePassService.setDictionaryServiceProvider((DictionaryServiceProvider)this.configuration.getDictionaryServiceProvider());
            Future<DictionaryClient> result = this.executorService.submit(new Callable<DictionaryClient>(){

                @Override
                public DictionaryClient call() throws Exception {
                    Thread.currentThread().setName("Dictionary client");
                    DictionaryClient client = DictionaryOnePassService.getDictionaryProvider().getDictionaryClient();
                    client.startClient(RowConverterImpl.this.configuration.getDictionaryServerSecretKey(), RowConverterImpl.this.configuration.getDictionaryServerHost(), RowConverterImpl.this.configuration.getDictionaryServerPort(), RowConverterImpl.this.configuration.getDictionaryEncryptServerSecure().booleanValue());
                    return client;
                }
            });
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error((Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                return result.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @Override
    public CarbonRow convert(CarbonRow row) throws CarbonDataLoadingException {
        this.logHolder.setLogged(false);
        this.logHolder.clear();
        for (int i = 0; i < this.fieldConverters.length; ++i) {
            this.fieldConverters[i].convert(row, this.logHolder);
            if (this.logHolder.isLogged() || !this.logHolder.isBadRecordNotAdded()) continue;
            this.badRecordLogger.addBadRecordsToBuilder(row.getRawData(), this.logHolder.getReason());
            if (this.badRecordLogger.isDataLoadFail()) {
                String error = "Data load failed due to bad record: " + this.logHolder.getReason();
                if (!this.badRecordLogger.isBadRecordLoggerEnable()) {
                    error = error + "Please enable bad record logger to know the detail reason.";
                }
                throw new BadRecordFoundException(error);
            }
            this.logHolder.clear();
            this.logHolder.setLogged(true);
            if (!this.badRecordLogger.isBadRecordConvertNullDisable()) continue;
            return null;
        }
        row.setRawData(null);
        return row;
    }

    @Override
    public void finish() {
        for (int i = 0; i < this.fieldConverters.length; ++i) {
            this.fieldConverters[i].clear();
        }
        if (this.configuration.getUseOnePass()) {
            for (DictionaryClient client : this.dictClients) {
                if (client == null) continue;
                client.shutDown();
            }
            if (null != this.logHolder) {
                this.logHolder.finish();
            }
            if (this.executorService != null) {
                this.executorService.shutdownNow();
                this.executorService = null;
            }
        }
    }

    @Override
    public RowConverter createCopyForNewThread() {
        RowConverterImpl converter = new RowConverterImpl(this.fields, this.configuration, this.badRecordLogger, this.isConvertToBinary);
        ArrayList<FieldConverter> fieldConverterList = new ArrayList<FieldConverter>();
        DictionaryClient client = this.createDictionaryClient();
        this.dictClients.add(client);
        String nullFormat = this.configuration.getDataLoadProperty("SERIALIZATION_NULL_FORMAT").toString();
        boolean isEmptyBadRecord = Boolean.parseBoolean(this.configuration.getDataLoadProperty("IS_EMPTY_DATA_BAD_RECORD").toString());
        for (int i = 0; i < this.fields.length; ++i) {
            FieldConverter fieldConverter = null;
            try {
                fieldConverter = FieldEncoderFactory.getInstance().createFieldEncoder(this.fields[i], this.configuration.getTableIdentifier(), i, nullFormat, client, this.configuration.getUseOnePass(), this.localCaches[i], isEmptyBadRecord, this.configuration.getParentTablePath(), this.isConvertToBinary);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            fieldConverterList.add(fieldConverter);
        }
        converter.fieldConverters = fieldConverterList.toArray(new FieldConverter[fieldConverterList.size()]);
        converter.logHolder = new BadRecordLogHolder();
        return converter;
    }

    @Override
    public int[] getCardinality() {
        ArrayList<Integer> dimCardinality = new ArrayList<Integer>();
        if (this.fieldConverters != null) {
            for (int i = 0; i < this.fieldConverters.length; ++i) {
                if (!(this.fieldConverters[i] instanceof AbstractDictionaryFieldConverterImpl)) continue;
                ((AbstractDictionaryFieldConverterImpl)this.fieldConverters[i]).fillColumnCardinality(dimCardinality);
            }
        }
        int[] cardinality = new int[dimCardinality.size()];
        for (int i = 0; i < dimCardinality.size(); ++i) {
            cardinality[i] = (Integer)dimCardinality.get(i);
        }
        return cardinality;
    }

    @Override
    public FieldConverter[] getFieldConverters() {
        return this.fieldConverters;
    }
}

