/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.FieldConverter;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class MeasureFieldConverterImpl
implements FieldConverter {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)MeasureFieldConverterImpl.class.getName());
    private int index;
    private String nullformat;
    private boolean isEmptyBadRecord;
    private DataField dataField;

    public MeasureFieldConverterImpl(DataField dataField, String nullformat, int index, boolean isEmptyBadRecord) {
        this.nullformat = nullformat;
        this.index = index;
        this.isEmptyBadRecord = isEmptyBadRecord;
        this.dataField = dataField;
    }

    @Override
    public void convert(CarbonRow row, BadRecordLogHolder logHolder) throws CarbonDataLoadingException {
        String value = row.getString(this.index);
        row.update(this.convert(value, logHolder), this.index);
    }

    @Override
    public Object convert(Object value, BadRecordLogHolder logHolder) throws RuntimeException {
        String literalValue = (String)value;
        boolean isNull = "@NU#LL$!".equals(literalValue);
        if (literalValue == null || isNull) {
            String message = logHolder.getColumnMessageMap().get(this.dataField.getColumn().getColName());
            if (null == message) {
                message = CarbonDataProcessorUtil.prepareFailureReason(this.dataField.getColumn().getColName(), this.dataField.getColumn().getDataType());
                logHolder.getColumnMessageMap().put(this.dataField.getColumn().getColName(), message);
            }
            if (this.dataField.getColumn().isDimension().booleanValue()) {
                logHolder.setReason(message);
            }
            return null;
        }
        if (literalValue.length() == 0) {
            if (this.isEmptyBadRecord) {
                String message = logHolder.getColumnMessageMap().get(this.dataField.getColumn().getColName());
                if (null == message) {
                    message = CarbonDataProcessorUtil.prepareFailureReason(this.dataField.getColumn().getColName(), this.dataField.getColumn().getDataType());
                    logHolder.getColumnMessageMap().put(this.dataField.getColumn().getColName(), message);
                }
                logHolder.setReason(message);
            }
            return null;
        }
        if (literalValue.equals(this.nullformat)) {
            return null;
        }
        try {
            Object output;
            if (this.dataField.getColumn().isDimension().booleanValue()) {
                String dateFormat = null;
                if (this.dataField.getColumn().getDataType() == DataTypes.DATE) {
                    dateFormat = this.dataField.getDateFormat();
                } else if (this.dataField.getColumn().getDataType() == DataTypes.TIMESTAMP) {
                    dateFormat = this.dataField.getTimestampFormat();
                }
                output = this.dataField.isUseActualData() ? DataTypeUtil.getNoDictionaryValueBasedOnDataType((String)literalValue, (DataType)this.dataField.getColumn().getDataType(), (int)this.dataField.getColumn().getColumnSchema().getScale(), (int)this.dataField.getColumn().getColumnSchema().getPrecision(), (boolean)true, (String)dateFormat) : DataTypeUtil.getNoDictionaryValueBasedOnDataType((String)literalValue, (DataType)this.dataField.getColumn().getDataType(), (int)this.dataField.getColumn().getColumnSchema().getScale(), (int)this.dataField.getColumn().getColumnSchema().getPrecision(), (boolean)false, (String)dateFormat);
            } else {
                output = this.dataField.isUseActualData() ? DataTypeUtil.getMeasureValueBasedOnDataType((String)literalValue, (DataType)this.dataField.getColumn().getDataType(), (int)this.dataField.getColumn().getColumnSchema().getScale(), (int)this.dataField.getColumn().getColumnSchema().getPrecision(), (boolean)true) : DataTypeUtil.getMeasureValueBasedOnDataType((String)literalValue, (DataType)this.dataField.getColumn().getDataType(), (int)this.dataField.getColumn().getColumnSchema().getScale(), (int)this.dataField.getColumn().getColumnSchema().getPrecision());
            }
            return output;
        }
        catch (NumberFormatException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Cannot convert value to Numeric type value. Value considered as null.");
            }
            logHolder.setReason(CarbonDataProcessorUtil.prepareFailureReason(this.dataField.getColumn().getColName(), this.dataField.getColumn().getDataType()));
            return null;
        }
    }

    @Override
    public void clear() {
    }
}

