/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.List;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.impl.AbstractDictionaryFieldConverterImpl;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;

public class ComplexFieldConverterImpl
extends AbstractDictionaryFieldConverterImpl {
    private GenericDataType genericDataType;
    private int index;

    public ComplexFieldConverterImpl(GenericDataType genericDataType, int index) {
        this.genericDataType = genericDataType;
        this.index = index;
    }

    @Override
    public void convert(CarbonRow row, BadRecordLogHolder logHolder) {
        Object object = row.getObject(this.index);
        row.update(this.convert(object, logHolder), this.index);
    }

    @Override
    public Object convert(Object value, BadRecordLogHolder logHolder) throws RuntimeException {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArray);
        try {
            this.genericDataType.writeByteArray(value, dataOutputStream, logHolder);
            dataOutputStream.close();
            return byteArray.toByteArray();
        }
        catch (Exception e) {
            throw new CarbonDataLoadingException(value + "", e);
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public void fillColumnCardinality(List<Integer> cardinality) {
        this.genericDataType.fillCardinality(cardinality);
    }
}

