/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import org.apache.carbondata.common.CarbonIterator;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.processing.loading.AbstractDataLoadProcessorStep;
import org.apache.carbondata.processing.loading.BadRecordsLogger;
import org.apache.carbondata.processing.loading.DataLoadProcessBuilder;
import org.apache.carbondata.processing.loading.exception.BadRecordFoundException;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.exception.NoRetryException;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.util.CarbonBadRecordUtil;

public class DataLoadExecutor {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)DataLoadExecutor.class.getName());
    private AbstractDataLoadProcessorStep loadProcessorStep;
    private boolean isClosed;

    public void execute(CarbonLoadModel loadModel, String[] storeLocation, CarbonIterator<Object[]>[] inputIterators) throws Exception {
        try {
            this.loadProcessorStep = new DataLoadProcessBuilder().build(loadModel, storeLocation, inputIterators);
            this.loadProcessorStep.initialize();
            LOGGER.info("Data Loading is started for table " + loadModel.getTableName());
            this.loadProcessorStep.execute();
            if (CarbonBadRecordUtil.hasBadRecord(loadModel)) {
                LOGGER.error("Data Load is partially success for table " + loadModel.getTableName());
            } else {
                LOGGER.info("Data loading is successful for table " + loadModel.getTableName());
            }
        }
        catch (CarbonDataLoadingException e) {
            if (e instanceof BadRecordFoundException) {
                throw new NoRetryException(e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e, "Data Loading failed for table " + loadModel.getTableName());
            throw new CarbonDataLoadingException("Data Loading failed for table " + loadModel.getTableName(), e);
        }
    }

    private boolean badRecordFound(CarbonTableIdentifier carbonTableIdentifier) {
        String badRecordLoggerKey = carbonTableIdentifier.getBadRecordLoggerKey();
        boolean badRecordKeyFound = false;
        if (null != BadRecordsLogger.hasBadRecord(badRecordLoggerKey)) {
            badRecordKeyFound = true;
        }
        return badRecordKeyFound;
    }

    public void close() {
        if (!this.isClosed && this.loadProcessorStep != null) {
            this.loadProcessorStep.close();
        }
        this.isClosed = true;
    }
}

