/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.datatypes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.constants.CarbonCommonConstants;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.row.ComplexColumnInfo;
import org.apache.carbondata.core.devapi.BiDictionary;
import org.apache.carbondata.core.devapi.DictionaryGenerationException;
import org.apache.carbondata.core.dictionary.client.DictionaryClient;
import org.apache.carbondata.core.dictionary.generator.key.DictionaryMessage;
import org.apache.carbondata.core.dictionary.generator.key.DictionaryMessageType;
import org.apache.carbondata.core.keygenerator.KeyGenException;
import org.apache.carbondata.core.keygenerator.KeyGenerator;
import org.apache.carbondata.core.keygenerator.directdictionary.DirectDictionaryKeyGeneratorFactory;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.util.ByteUtil;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.dictionary.DictionaryServerClientDictionary;
import org.apache.carbondata.processing.loading.dictionary.DirectDictionary;
import org.apache.carbondata.processing.loading.dictionary.PreCreatedDictionary;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class PrimitiveDataType
implements GenericDataType<Object> {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)PrimitiveDataType.class.getName());
    private int index;
    private String name;
    private String parentname;
    private String columnId;
    private int keySize;
    private int outputArrayIndex;
    private int dataCounter;
    private BiDictionary<Integer, Object> dictionaryGenerator;
    private CarbonDimension carbonDimension;
    private boolean isDictionary;
    private boolean isEmptyBadRecord;
    private String nullformat;
    private boolean isDirectDictionary;
    private DataType dataType;

    private PrimitiveDataType(int outputArrayIndex, int dataCounter) {
        this.outputArrayIndex = outputArrayIndex;
        this.dataCounter = dataCounter;
    }

    public PrimitiveDataType(String name, DataType dataType, String parentName, String columnId, boolean isDictionary, String nullFormat, boolean isEmptyBadRecord) {
        this.name = name;
        this.parentname = parentName;
        this.columnId = columnId;
        this.isDictionary = isDictionary;
        this.nullformat = nullFormat;
        this.isEmptyBadRecord = isEmptyBadRecord;
        this.dataType = dataType;
    }

    public PrimitiveDataType(CarbonColumn carbonColumn, String parentName, String columnId, CarbonDimension carbonDimension, AbsoluteTableIdentifier absoluteTableIdentifier, DictionaryClient client, Boolean useOnePass, Map<Object, Integer> localCache, String nullFormat, Boolean isEmptyBadRecords) {
        this.name = carbonColumn.getColName();
        this.parentname = parentName;
        this.columnId = columnId;
        this.carbonDimension = carbonDimension;
        this.isDictionary = this.isDictionaryDimension(carbonDimension);
        this.nullformat = nullFormat;
        this.isEmptyBadRecord = isEmptyBadRecords;
        this.dataType = carbonColumn.getDataType();
        DictionaryColumnUniqueIdentifier identifier = new DictionaryColumnUniqueIdentifier(absoluteTableIdentifier, carbonDimension.getColumnIdentifier(), carbonDimension.getDataType());
        try {
            if (carbonDimension.hasEncoding(Encoding.DIRECT_DICTIONARY) || carbonColumn.getDataType() == DataTypes.DATE) {
                this.dictionaryGenerator = new DirectDictionary(DirectDictionaryKeyGeneratorFactory.getDirectDictionaryGenerator((DataType)carbonDimension.getDataType(), (String)this.getDateFormat(carbonDimension)));
                this.isDirectDictionary = true;
            } else if (carbonDimension.hasEncoding(Encoding.DICTIONARY)) {
                CacheProvider cacheProvider = CacheProvider.getInstance();
                Cache cache = cacheProvider.createCache(CacheType.REVERSE_DICTIONARY);
                Dictionary dictionary = null;
                if (useOnePass.booleanValue()) {
                    if (CarbonUtil.isFileExistsForGivenColumn((DictionaryColumnUniqueIdentifier)identifier)) {
                        dictionary = (Dictionary)cache.get((Object)identifier);
                    }
                    DictionaryMessage dictionaryMessage = new DictionaryMessage();
                    dictionaryMessage.setColumnName(carbonDimension.getColName());
                    dictionaryMessage.setTableUniqueId(absoluteTableIdentifier.getCarbonTableIdentifier().getTableId());
                    dictionaryMessage.setData("0");
                    dictionaryMessage.setType(DictionaryMessageType.DICT_GENERATION);
                    this.dictionaryGenerator = new DictionaryServerClientDictionary(dictionary, client, dictionaryMessage, localCache);
                } else {
                    dictionary = (Dictionary)cache.get((Object)identifier);
                    this.dictionaryGenerator = new PreCreatedDictionary(dictionary);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getDateFormat(CarbonDimension carbonDimension) {
        String dateFormat = null;
        if (this.carbonDimension.getDataType() == DataTypes.DATE) {
            dateFormat = carbonDimension.getDateFormat();
        }
        String format = dateFormat != null && !dateFormat.trim().isEmpty() ? dateFormat : CarbonUtil.getFormatFromProperty((DataType)this.dataType);
        return format;
    }

    private boolean isDictionaryDimension(CarbonDimension carbonDimension) {
        return carbonDimension.hasEncoding(Encoding.DICTIONARY);
    }

    @Override
    public void addChildren(GenericDataType children) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParentname() {
        return this.parentname;
    }

    @Override
    public String getColumnNames() {
        return this.columnId;
    }

    @Override
    public void getAllPrimitiveChildren(List<GenericDataType> primitiveChild) {
    }

    @Override
    public int getSurrogateIndex() {
        return this.index;
    }

    @Override
    public void setSurrogateIndex(int surrIndex) {
        this.index = this.carbonDimension != null && !this.carbonDimension.hasEncoding(Encoding.DICTIONARY) ? 0 : (this.carbonDimension == null && !this.isDictionary ? 0 : surrIndex);
    }

    @Override
    public boolean getIsColumnDictionary() {
        return this.isDictionary;
    }

    @Override
    public void writeByteArray(Object input, DataOutputStream dataOutputStream, BadRecordLogHolder logHolder) throws IOException, DictionaryGenerationException {
        String parsedValue = input == null ? null : DataTypeUtil.parseValue((String)input.toString(), (CarbonDimension)this.carbonDimension);
        String message = logHolder.getColumnMessageMap().get(this.carbonDimension.getColName());
        if (this.isDictionary) {
            Integer surrogateKey;
            if (null == parsedValue) {
                surrogateKey = 1;
                if (null == message) {
                    message = CarbonDataProcessorUtil.prepareFailureReason(this.carbonDimension.getColName(), this.carbonDimension.getDataType());
                    logHolder.getColumnMessageMap().put(this.carbonDimension.getColName(), message);
                    logHolder.setReason(message);
                }
            } else {
                surrogateKey = this.dictionaryGenerator instanceof DirectDictionary && input instanceof Long ? ((DirectDictionary)this.dictionaryGenerator).generateKey((Long)input) : (Integer)this.dictionaryGenerator.getOrGenerateKey((Object)parsedValue);
                if (surrogateKey == -1) {
                    surrogateKey = 1;
                    message = CarbonDataProcessorUtil.prepareFailureReason(this.carbonDimension.getColName(), this.carbonDimension.getDataType());
                    logHolder.getColumnMessageMap().put(this.carbonDimension.getColName(), message);
                    logHolder.setReason(message);
                }
            }
            dataOutputStream.writeInt(surrogateKey);
        } else if (null == parsedValue && this.carbonDimension.getDataType() != DataTypes.STRING) {
            this.updateNullValue(dataOutputStream, logHolder);
        } else if (null == parsedValue || parsedValue.equals(this.nullformat)) {
            this.updateNullValue(dataOutputStream, logHolder);
        } else {
            String dateFormat = null;
            if (this.carbonDimension.getDataType() == DataTypes.DATE) {
                dateFormat = this.carbonDimension.getDateFormat();
            } else if (this.carbonDimension.getDataType() == DataTypes.TIMESTAMP) {
                dateFormat = this.carbonDimension.getTimestampFormat();
            }
            try {
                if (!this.carbonDimension.getUseActualData()) {
                    byte[] value = null;
                    if (this.isDirectDictionary) {
                        int surrogateKey;
                        if (!(input instanceof Long)) {
                            SimpleDateFormat parser = new SimpleDateFormat(this.getDateFormat(this.carbonDimension));
                            parser.parse(parsedValue);
                        }
                        value = (surrogateKey = this.dictionaryGenerator instanceof DirectDictionary && input instanceof Long ? ((DirectDictionary)this.dictionaryGenerator).generateKey((Long)input).intValue() : ((Integer)this.dictionaryGenerator.getOrGenerateKey((Object)parsedValue)).intValue()) == -1 ? new byte[]{} : ByteUtil.toXorBytes((int)surrogateKey);
                    } else {
                        value = this.carbonDimension.getDataType().equals((Object)DataTypes.DATE) || this.carbonDimension.getDataType().equals((Object)DataTypes.TIMESTAMP) && input instanceof Long ? (this.dictionaryGenerator != null ? ByteUtil.toXorBytes((int)((DirectDictionary)this.dictionaryGenerator).generateKey((Long)input)) : ByteUtil.toXorBytes((long)Long.parseLong(parsedValue))) : DataTypeUtil.getBytesBasedOnDataTypeForNoDictionaryColumn((String)parsedValue, (DataType)this.carbonDimension.getDataType(), (String)dateFormat);
                        if (this.carbonDimension.getDataType() == DataTypes.STRING && value.length > 32000) {
                            throw new CarbonDataLoadingException("Dataload failed, String size cannot exceed 32000 bytes");
                        }
                    }
                    this.updateValueToByteStream(dataOutputStream, value);
                } else {
                    Object value = this.dictionaryGenerator instanceof DirectDictionary && input instanceof Long ? (Object)ByteUtil.toXorBytes((int)((DirectDictionary)this.dictionaryGenerator).generateKey((Long)input)) : DataTypeUtil.getDataDataTypeForNoDictionaryColumn((String)parsedValue, (DataType)this.carbonDimension.getDataType(), (String)dateFormat);
                    if (this.carbonDimension.getDataType() == DataTypes.STRING && value.toString().length() > 32000) {
                        throw new CarbonDataLoadingException("Dataload failed, String size cannot exceed 32000 bytes");
                    }
                    if (parsedValue.length() > 0) {
                        this.updateValueToByteStream(dataOutputStream, parsedValue.getBytes(Charset.forName("UTF-8")));
                    } else {
                        this.updateNullValue(dataOutputStream, logHolder);
                    }
                }
            }
            catch (NumberFormatException e) {
                this.updateNullValue(dataOutputStream, logHolder);
            }
            catch (CarbonDataLoadingException e) {
                throw e;
            }
            catch (ParseException ex) {
                this.updateNullValue(dataOutputStream, logHolder);
            }
            catch (Throwable ex) {
                throw ex;
            }
        }
    }

    private void updateValueToByteStream(DataOutputStream dataOutputStream, byte[] value) throws IOException {
        dataOutputStream.writeShort(value.length);
        dataOutputStream.write(value);
    }

    private void updateNullValue(DataOutputStream dataOutputStream, BadRecordLogHolder logHolder) throws IOException {
        if (this.carbonDimension.getDataType() == DataTypes.STRING) {
            dataOutputStream.writeShort(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY.length);
            dataOutputStream.write(CarbonCommonConstants.MEMBER_DEFAULT_VAL_ARRAY);
        } else {
            dataOutputStream.writeShort(CarbonCommonConstants.EMPTY_BYTE_ARRAY.length);
            dataOutputStream.write(CarbonCommonConstants.EMPTY_BYTE_ARRAY);
        }
        String message = logHolder.getColumnMessageMap().get(this.carbonDimension.getColName());
        if (null == message) {
            message = CarbonDataProcessorUtil.prepareFailureReason(this.carbonDimension.getColName(), this.carbonDimension.getDataType());
            logHolder.getColumnMessageMap().put(this.carbonDimension.getColName(), message);
            logHolder.setReason(message);
        }
    }

    @Override
    public void fillCardinality(List<Integer> dimCardWithComplex) {
        if (!this.carbonDimension.hasEncoding(Encoding.DICTIONARY)) {
            return;
        }
        dimCardWithComplex.add(this.dictionaryGenerator.size());
    }

    @Override
    public void parseComplexValue(ByteBuffer byteArrayInput, DataOutputStream dataOutputStream, KeyGenerator[] generator) throws IOException, KeyGenException {
        if (!this.isDictionary) {
            short sizeOfData = byteArrayInput.getShort();
            dataOutputStream.writeShort(sizeOfData);
            byte[] bb = new byte[sizeOfData];
            byteArrayInput.get(bb, 0, sizeOfData);
            dataOutputStream.write(bb);
        } else {
            int data = byteArrayInput.getInt();
            byte[] v = generator[this.index].generateKey(new int[]{data});
            dataOutputStream.write(v);
        }
    }

    @Override
    public int getColsCount() {
        return 1;
    }

    @Override
    public void setOutputArrayIndex(int outputArrayIndex) {
        this.outputArrayIndex = outputArrayIndex;
    }

    @Override
    public int getMaxOutputArrayIndex() {
        return this.outputArrayIndex;
    }

    @Override
    public void getColumnarDataForComplexType(List<ArrayList<byte[]>> columnsArray, ByteBuffer inputArray) {
        if (!this.isDictionary) {
            byte[] key = new byte[inputArray.getShort()];
            inputArray.get(key);
            columnsArray.get(this.outputArrayIndex).add(key);
        } else {
            byte[] key = new byte[this.keySize];
            inputArray.get(key);
            columnsArray.get(this.outputArrayIndex).add(key);
        }
        ++this.dataCounter;
    }

    @Override
    public int getDataCounter() {
        return this.dataCounter;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    @Override
    public void fillAggKeyBlock(List<Boolean> aggKeyBlockWithComplex, boolean[] aggKeyBlock) {
        aggKeyBlockWithComplex.add(aggKeyBlock[this.index]);
    }

    @Override
    public void fillBlockKeySize(List<Integer> blockKeySizeWithComplex, int[] primitiveBlockKeySize) {
        blockKeySizeWithComplex.add(primitiveBlockKeySize[this.index]);
        this.keySize = primitiveBlockKeySize[this.index];
    }

    @Override
    public void fillCardinalityAfterDataLoad(List<Integer> dimCardWithComplex, int[] maxSurrogateKeyArray) {
        dimCardWithComplex.add(maxSurrogateKeyArray[this.index]);
    }

    @Override
    public GenericDataType<Object> deepCopy() {
        PrimitiveDataType dataType = new PrimitiveDataType(this.outputArrayIndex, 0);
        dataType.carbonDimension = this.carbonDimension;
        dataType.isDictionary = this.isDictionary;
        dataType.parentname = this.parentname;
        dataType.columnId = this.columnId;
        dataType.dictionaryGenerator = this.dictionaryGenerator;
        dataType.isEmptyBadRecord = this.isEmptyBadRecord;
        dataType.nullformat = this.nullformat;
        dataType.setKeySize(this.keySize);
        dataType.setSurrogateIndex(this.index);
        dataType.name = this.name;
        dataType.dataType = this.dataType;
        return dataType;
    }

    @Override
    public void getComplexColumnInfo(List<ComplexColumnInfo> columnInfoList) {
        columnInfoList.add(new ComplexColumnInfo(ColumnType.COMPLEX_PRIMITIVE, this.dataType, this.name, !this.isDictionary));
    }
}

