/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.datatypes;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.carbondata.core.datastore.ColumnType;
import org.apache.carbondata.core.datastore.row.ComplexColumnInfo;
import org.apache.carbondata.core.devapi.DictionaryGenerationException;
import org.apache.carbondata.core.keygenerator.KeyGenException;
import org.apache.carbondata.core.keygenerator.KeyGenerator;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.datatypes.PrimitiveDataType;
import org.apache.carbondata.processing.loading.complexobjects.ArrayObject;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;

public class ArrayDataType
implements GenericDataType<ArrayObject> {
    private GenericDataType children;
    private String name;
    private String columnId;
    private String parentname;
    private int outputArrayIndex;
    private boolean isDictionaryColumn;
    private int dataCounter;

    private ArrayDataType(int outputArrayIndex, int dataCounter, GenericDataType children, String name) {
        this.outputArrayIndex = outputArrayIndex;
        this.dataCounter = dataCounter;
        this.children = children;
        this.name = name;
    }

    public ArrayDataType(String name, String parentname, String columnId) {
        this.name = name;
        this.parentname = parentname;
        this.columnId = columnId;
    }

    public ArrayDataType(String name, String parentname, String columnId, Boolean isDictionaryColumn) {
        this.name = name;
        this.parentname = parentname;
        this.columnId = columnId;
        this.isDictionaryColumn = isDictionaryColumn;
    }

    @Override
    public void addChildren(GenericDataType children) {
        if (this.getName().equals(children.getParentname())) {
            this.children = children;
        } else {
            this.children.addChildren(children);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getColumnNames() {
        return this.columnId;
    }

    @Override
    public String getParentname() {
        return this.parentname;
    }

    @Override
    public void getAllPrimitiveChildren(List<GenericDataType> primitiveChild) {
        if (this.children instanceof PrimitiveDataType) {
            primitiveChild.add(this.children);
        } else {
            this.children.getAllPrimitiveChildren(primitiveChild);
        }
    }

    @Override
    public int getSurrogateIndex() {
        return 0;
    }

    @Override
    public void setSurrogateIndex(int surrIndex) {
    }

    @Override
    public boolean getIsColumnDictionary() {
        return this.isDictionaryColumn;
    }

    @Override
    public void writeByteArray(ArrayObject input, DataOutputStream dataOutputStream, BadRecordLogHolder logHolder) throws IOException, DictionaryGenerationException {
        if (input == null) {
            dataOutputStream.writeInt(1);
            this.children.writeByteArray(null, dataOutputStream, logHolder);
        } else {
            Object[] data = input.getData();
            dataOutputStream.writeInt(data.length);
            for (Object eachInput : data) {
                this.children.writeByteArray(eachInput, dataOutputStream, logHolder);
            }
        }
    }

    @Override
    public void fillCardinality(List<Integer> dimCardWithComplex) {
        if (this.getIsColumnDictionary()) {
            dimCardWithComplex.add(0);
            this.children.fillCardinality(dimCardWithComplex);
        }
    }

    @Override
    public void parseComplexValue(ByteBuffer byteArrayInput, DataOutputStream dataOutputStream, KeyGenerator[] generator) throws IOException, KeyGenException {
        int dataLength = byteArrayInput.getInt();
        dataOutputStream.writeInt(dataLength);
        if (this.children instanceof PrimitiveDataType && this.children.getIsColumnDictionary()) {
            dataOutputStream.writeInt(generator[this.children.getSurrogateIndex()].getKeySizeInBytes());
        }
        for (int i = 0; i < dataLength; ++i) {
            this.children.parseComplexValue(byteArrayInput, dataOutputStream, generator);
        }
    }

    @Override
    public int getColsCount() {
        return this.children.getColsCount() + 1;
    }

    @Override
    public void setOutputArrayIndex(int outputArrayIndex) {
        this.outputArrayIndex = outputArrayIndex;
        this.children.setOutputArrayIndex(outputArrayIndex + 1);
    }

    @Override
    public int getMaxOutputArrayIndex() {
        int currentMax = this.outputArrayIndex;
        int childMax = this.children.getMaxOutputArrayIndex();
        if (childMax > currentMax) {
            currentMax = childMax;
        }
        return currentMax;
    }

    @Override
    public void getColumnarDataForComplexType(List<ArrayList<byte[]>> columnsArray, ByteBuffer inputArray) {
        PrimitiveDataType child;
        ByteBuffer b = ByteBuffer.allocate(8);
        int dataLength = inputArray.getInt();
        b.putInt(dataLength);
        if (dataLength == 0) {
            b.putInt(0);
        } else {
            b.putInt(this.children.getDataCounter());
        }
        columnsArray.get(this.outputArrayIndex).add(b.array());
        if (this.children instanceof PrimitiveDataType && (child = (PrimitiveDataType)this.children).getIsColumnDictionary()) {
            child.setKeySize(inputArray.getInt());
        }
        for (int i = 0; i < dataLength; ++i) {
            this.children.getColumnarDataForComplexType(columnsArray, inputArray);
        }
        ++this.dataCounter;
    }

    @Override
    public int getDataCounter() {
        return this.dataCounter;
    }

    @Override
    public void fillAggKeyBlock(List<Boolean> aggKeyBlockWithComplex, boolean[] aggKeyBlock) {
        aggKeyBlockWithComplex.add(false);
        this.children.fillAggKeyBlock(aggKeyBlockWithComplex, aggKeyBlock);
    }

    @Override
    public void fillBlockKeySize(List<Integer> blockKeySizeWithComplex, int[] primitiveBlockKeySize) {
        blockKeySizeWithComplex.add(8);
        this.children.fillBlockKeySize(blockKeySizeWithComplex, primitiveBlockKeySize);
    }

    @Override
    public void fillCardinalityAfterDataLoad(List<Integer> dimCardWithComplex, int[] maxSurrogateKeyArray) {
        dimCardWithComplex.add(0);
        this.children.fillCardinalityAfterDataLoad(dimCardWithComplex, maxSurrogateKeyArray);
    }

    @Override
    public GenericDataType<ArrayObject> deepCopy() {
        return new ArrayDataType(this.outputArrayIndex, this.dataCounter, this.children.deepCopy(), this.name);
    }

    @Override
    public void getComplexColumnInfo(List<ComplexColumnInfo> columnInfoList) {
        columnInfoList.add(new ComplexColumnInfo(ColumnType.COMPLEX_ARRAY, DataTypeUtil.valueOf((String)"array"), this.name, false));
        this.children.getComplexColumnInfo(columnInfoList);
    }
}

