/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.xml.bind.JAXBException;
import org.apache.camel.cdi.ApplicationScopedLiteral;
import org.apache.camel.cdi.CdiCamelContextNameStrategy;
import org.apache.camel.cdi.CdiCamelEnvironment;
import org.apache.camel.cdi.CdiCamelExtension;
import org.apache.camel.cdi.CdiSpiHelper;
import org.apache.camel.cdi.ListParameterizedType;
import org.apache.camel.cdi.NamedLiteral;
import org.apache.camel.cdi.ResourceHelper;
import org.apache.camel.cdi.SyntheticAnnotated;
import org.apache.camel.cdi.SyntheticBean;
import org.apache.camel.cdi.SyntheticInjectionTarget;
import org.apache.camel.cdi.XmlCdiJaxbContexts;
import org.apache.camel.cdi.XmlErrorHandlerFactoryBean;
import org.apache.camel.cdi.XmlFactoryBeanInjectionTarget;
import org.apache.camel.cdi.xml.ApplicationContextFactoryBean;
import org.apache.camel.cdi.xml.BeanManagerAware;
import org.apache.camel.cdi.xml.CamelContextFactoryBean;
import org.apache.camel.cdi.xml.ErrorHandlerDefinition;
import org.apache.camel.cdi.xml.ErrorHandlerType;
import org.apache.camel.cdi.xml.ImportDefinition;
import org.apache.camel.cdi.xml.RestContextDefinition;
import org.apache.camel.cdi.xml.RouteConfigurationContextDefinition;
import org.apache.camel.cdi.xml.RouteContextDefinition;
import org.apache.camel.cdi.xml.RouteTemplateContextDefinition;
import org.apache.camel.core.xml.AbstractCamelFactoryBean;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Vetoed
@Deprecated
final class XmlCdiBeanFactory {
    private final Logger logger = LoggerFactory.getLogger(XmlCdiBeanFactory.class);
    private final BeanManager manager;
    private final CdiCamelEnvironment environment;
    private final CdiCamelExtension extension;

    private XmlCdiBeanFactory(BeanManager manager, CdiCamelEnvironment environment, CdiCamelExtension extension) {
        this.manager = manager;
        this.environment = environment;
        this.extension = extension;
    }

    static XmlCdiBeanFactory with(BeanManager manager, CdiCamelEnvironment environment, CdiCamelExtension extension) {
        return new XmlCdiBeanFactory(manager, environment, extension);
    }

    Set<SyntheticBean<?>> beansFrom(String path, AnnotatedType<?> annotatedType) throws JAXBException, IOException {
        URL url = ResourceHelper.getResource(path, annotatedType.getJavaClass().getClassLoader());
        if (url == null) {
            this.logger.warn("Unable to locate resource [{}] for import!", (Object)path);
            return Collections.emptySet();
        }
        return this.beansFrom(url, annotatedType);
    }

    Set<SyntheticBean<?>> beansFrom(URL url, AnnotatedType<?> annotatedType) throws JAXBException, IOException {
        try (InputStream xml = url.openStream();){
            Object node = XmlCdiJaxbContexts.CAMEL_CDI.instance().createUnmarshaller().unmarshal(xml);
            if (node instanceof RoutesDefinition) {
                RoutesDefinition routes = (RoutesDefinition)node;
                Set<SyntheticBean<?>> set = Collections.singleton(this.routesDefinitionBean(routes, url));
                return set;
            }
            if (node instanceof ApplicationContextFactoryBean) {
                ApplicationContextFactoryBean app = (ApplicationContextFactoryBean)node;
                HashSet beans = new HashSet();
                for (CamelContextFactoryBean camelContextFactoryBean : app.getContexts()) {
                    SyntheticBean<?> bean = this.camelContextBean(camelContextFactoryBean, url, annotatedType);
                    beans.add(bean);
                    beans.addAll(this.camelContextBeans(camelContextFactoryBean, bean, url));
                }
                for (ErrorHandlerDefinition errorHandlerDefinition : app.getErrorHandlers()) {
                    beans.add(this.errorHandlerBean(errorHandlerDefinition, url));
                }
                for (ImportDefinition importDefinition : app.getImports()) {
                    String path = url.getFile().substring(0, url.getFile().lastIndexOf(47));
                    String base = url.getProtocol() + "://" + url.getHost() + path;
                    beans.addAll(this.beansFrom(base + "/" + importDefinition.getResource(), annotatedType));
                }
                for (RestContextDefinition restContextDefinition : app.getRestContexts()) {
                    beans.add(this.restContextBean(restContextDefinition, url));
                }
                for (RouteContextDefinition routeContextDefinition : app.getRouteContexts()) {
                    beans.add(this.routeContextBean(routeContextDefinition, url));
                }
                for (RouteConfigurationContextDefinition routeConfigurationContextDefinition : app.getRouteConfigurationContexts()) {
                    beans.add(this.routeConfigurationContextBean(routeConfigurationContextDefinition, url));
                }
                for (RouteTemplateContextDefinition routeTemplateContextDefinition : app.getRouteTemplateContexts()) {
                    beans.add(this.routeTemplateContextBean(routeTemplateContextDefinition, url));
                }
                for (AbstractCamelFactoryBean abstractCamelFactoryBean : app.getBeans()) {
                    if (!XmlCdiBeanFactory.hasId(abstractCamelFactoryBean)) continue;
                    beans.add(this.camelContextBean(null, abstractCamelFactoryBean, url));
                }
                HashSet<SyntheticBean<?>> hashSet = beans;
                return hashSet;
            }
            if (node instanceof CamelContextFactoryBean) {
                CamelContextFactoryBean factory = (CamelContextFactoryBean)node;
                HashSet beans = new HashSet();
                SyntheticBean<?> bean = this.camelContextBean(factory, url, annotatedType);
                beans.add(bean);
                beans.addAll(this.camelContextBeans(factory, bean, url));
                HashSet hashSet = beans;
                return hashSet;
            }
            if (node instanceof RestContextDefinition) {
                RestContextDefinition factory = (RestContextDefinition)((Object)node);
                Set<SyntheticBean<?>> set = Collections.singleton(this.restContextBean(factory, url));
                return set;
            }
            if (node instanceof RouteContextDefinition) {
                RouteContextDefinition factory = (RouteContextDefinition)((Object)node);
                Set<SyntheticBean<?>> set = Collections.singleton(this.routeContextBean(factory, url));
                return set;
            }
            if (node instanceof RouteTemplateContextDefinition) {
                RouteTemplateContextDefinition factory = (RouteTemplateContextDefinition)((Object)node);
                Set<SyntheticBean<?>> set = Collections.singleton(this.routeTemplateContextBean(factory, url));
                return set;
            }
        }
        return Collections.emptySet();
    }

    private SyntheticBean<?> camelContextBean(CamelContextFactoryBean factory, URL url, AnnotatedType annotatedType) {
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        annotations.add((Annotation)Any.Literal.INSTANCE);
        if (XmlCdiBeanFactory.hasId(factory)) {
            Collections.addAll(annotations, NamedLiteral.of(factory.getId()));
        } else {
            annotations.add((Annotation)Default.Literal.INSTANCE);
            factory.setImplicitId(true);
            factory.setId(new CdiCamelContextNameStrategy().getNextName());
        }
        annotations.add((Annotation)ApplicationScopedLiteral.APPLICATION_SCOPED);
        SyntheticAnnotated annotated = new SyntheticAnnotated(DefaultCamelContext.class, (Set<Type>)this.manager.createAnnotatedType(DefaultCamelContext.class).getTypeClosure(), annotatedType.getJavaClass(), annotations);
        return new SyntheticBean<DefaultCamelContext>(this.manager, annotated, DefaultCamelContext.class, this.environment.camelContextInjectionTarget(new SyntheticInjectionTarget<DefaultCamelContext>(() -> {
            DefaultCamelContext context = CdiSpiHelper.createCamelContextWithTCCL(DefaultCamelContext::new, annotated);
            factory.setContext(context);
            factory.setBeanManager(this.manager);
            return context;
        }, context -> {
            try {
                factory.afterPropertiesSet();
            }
            catch (Exception cause) {
                throw new CreationException((Throwable)cause);
            }
        }), annotated, this.manager, this.extension), bean -> "imported Camel context with " + (factory.isImplicitId() ? "implicit " : "") + "id [" + factory.getId() + "] from resource [" + url + "] with qualifiers " + bean.getQualifiers());
    }

    private Set<SyntheticBean<?>> camelContextBeans(CamelContextFactoryBean factory, Bean<?> context, URL url) {
        HashSet beans = new HashSet();
        if (factory.getBeansFactory() != null) {
            factory.getBeansFactory().stream().filter(XmlCdiBeanFactory::hasId).map(bean -> this.camelContextBean(context, (AbstractCamelFactoryBean<?>)bean, url)).forEach(beans::add);
        }
        if (factory.getEndpoints() != null) {
            factory.getEndpoints().stream().filter(XmlCdiBeanFactory::hasId).map(endpoint -> this.camelContextBean(context, (AbstractCamelFactoryBean<?>)endpoint, url)).forEach(beans::add);
        }
        if (factory.getErrorHandlers() != null) {
            factory.getErrorHandlers().stream().filter(XmlCdiBeanFactory::hasId).map(handler -> this.errorHandlerBean((ErrorHandlerDefinition)((Object)handler), url)).forEach(beans::add);
        }
        if (factory.getRedeliveryPolicies() != null) {
            factory.getRedeliveryPolicies().stream().filter(XmlCdiBeanFactory::hasId).map(policy -> this.camelContextBean(context, (AbstractCamelFactoryBean<?>)policy, url)).forEach(beans::add);
        }
        return beans;
    }

    private SyntheticBean<?> camelContextBean(Bean<?> context, AbstractCamelFactoryBean<?> factory, URL url) {
        if (factory instanceof BeanManagerAware) {
            ((BeanManagerAware)factory).setBeanManager(this.manager);
        }
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        annotations.add((Annotation)Any.Literal.INSTANCE);
        annotations.add((Annotation)(XmlCdiBeanFactory.hasId(factory) ? NamedLiteral.of(factory.getId()) : Default.Literal.INSTANCE));
        if (factory.isSingleton()) {
            annotations.add((Annotation)ApplicationScopedLiteral.APPLICATION_SCOPED);
        }
        return new SyntheticBean(this.manager, new SyntheticAnnotated(factory.getObjectType(), (Set<Type>)this.manager.createAnnotatedType(factory.getObjectType()).getTypeClosure(), annotations), factory.getObjectType(), new XmlFactoryBeanInjectionTarget(this.manager, factory, context), bean -> "imported bean [" + factory.getId() + "] from resource [" + url + "] with qualifiers " + bean.getQualifiers());
    }

    private SyntheticBean<?> restContextBean(RestContextDefinition definition, URL url) {
        Objects.requireNonNull(definition.getId(), () -> String.format("Missing [%s] attribute for imported bean [%s] from resource [%s]", "id", "restContext", url));
        return new SyntheticBean<List>(this.manager, new SyntheticAnnotated(List.class, Stream.of(List.class, new ListParameterizedType((Type)((Object)RestDefinition.class))).collect(Collectors.toSet()), new Annotation[]{Any.Literal.INSTANCE, NamedLiteral.of(definition.getId())}), List.class, new SyntheticInjectionTarget<List>(definition::getRests), bean -> "imported rest context with id [" + definition.getId() + "] from resource [" + url + "] with qualifiers " + bean.getQualifiers());
    }

    private SyntheticBean<?> routeTemplateContextBean(RouteTemplateContextDefinition definition, URL url) {
        Objects.requireNonNull(definition.getId(), () -> String.format("Missing [%s] attribute for imported bean [%s] from resource [%s]", "id", "routeContext", url));
        return new SyntheticBean<List>(this.manager, new SyntheticAnnotated(List.class, Stream.of(List.class, new ListParameterizedType((Type)((Object)RouteTemplateDefinition.class))).collect(Collectors.toSet()), new Annotation[]{Any.Literal.INSTANCE, NamedLiteral.of(definition.getId())}), List.class, new SyntheticInjectionTarget<List>(definition::getRouteTemplates), bean -> "imported route template context with id [" + definition.getId() + "] from resource [" + url + "] with qualifiers " + bean.getQualifiers());
    }

    private SyntheticBean<?> routeConfigurationContextBean(RouteConfigurationContextDefinition definition, URL url) {
        Objects.requireNonNull(definition.getId(), () -> String.format("Missing [%s] attribute for imported bean [%s] from resource [%s]", "id", "routeContext", url));
        return new SyntheticBean<List>(this.manager, new SyntheticAnnotated(List.class, Stream.of(List.class, new ListParameterizedType((Type)((Object)RouteConfigurationDefinition.class))).collect(Collectors.toSet()), new Annotation[]{Any.Literal.INSTANCE, NamedLiteral.of(definition.getId())}), List.class, new SyntheticInjectionTarget<List>(definition::getRouteConfigurations), bean -> "imported route configuration context with id [" + definition.getId() + "] from resource [" + url + "] with qualifiers " + bean.getQualifiers());
    }

    private SyntheticBean<?> routeContextBean(RouteContextDefinition definition, URL url) {
        Objects.requireNonNull(definition.getId(), () -> String.format("Missing [%s] attribute for imported bean [%s] from resource [%s]", "id", "routeContext", url));
        return new SyntheticBean<List>(this.manager, new SyntheticAnnotated(List.class, Stream.of(List.class, new ListParameterizedType((Type)((Object)RouteDefinition.class))).collect(Collectors.toSet()), new Annotation[]{Any.Literal.INSTANCE, NamedLiteral.of(definition.getId())}), List.class, new SyntheticInjectionTarget<List>(definition::getRoutes), bean -> "imported route context with id [" + definition.getId() + "] from resource [" + url + "] with qualifiers " + bean.getQualifiers());
    }

    private SyntheticBean<?> routesDefinitionBean(RoutesDefinition definition, URL url) {
        return new SyntheticBean<RoutesDefinition>(this.manager, new SyntheticAnnotated(RoutesDefinition.class, (Set<Type>)this.manager.createAnnotatedType(RoutesDefinition.class).getTypeClosure(), new Annotation[]{Any.Literal.INSTANCE, Default.Literal.INSTANCE}), RoutesDefinition.class, new SyntheticInjectionTarget<RoutesDefinition>(() -> definition), bean -> "imported routes definition " + (String)(XmlCdiBeanFactory.hasId(definition) ? "[" + definition.getId() + "] " : "") + "from resource [" + url + "]");
    }

    private SyntheticBean<?> errorHandlerBean(ErrorHandlerDefinition definition, URL url) {
        ErrorHandlerType type = definition.getType();
        if (ObjectHelper.isNotEmpty((Object)definition.getDeadLetterUri()) && !type.equals((Object)ErrorHandlerType.DeadLetterChannel)) {
            throw XmlCdiBeanFactory.attributeNotSupported("deadLetterUri", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getDeadLetterHandleNewException()) && !type.equals((Object)ErrorHandlerType.DeadLetterChannel)) {
            throw XmlCdiBeanFactory.attributeNotSupported("deadLetterHandleNewException", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getTransactionTemplateRef()) && !type.equals((Object)ErrorHandlerType.TransactionErrorHandler)) {
            throw XmlCdiBeanFactory.attributeNotSupported("transactionTemplateRef", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getTransactionManagerRef()) && !type.equals((Object)ErrorHandlerType.TransactionErrorHandler)) {
            throw XmlCdiBeanFactory.attributeNotSupported("transactionManagerRef", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getRollbackLoggingLevel()) && !type.equals((Object)ErrorHandlerType.TransactionErrorHandler)) {
            throw XmlCdiBeanFactory.attributeNotSupported("rollbackLoggingLevel", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getUseOriginalMessage()) && type.equals((Object)ErrorHandlerType.NoErrorHandler)) {
            throw XmlCdiBeanFactory.attributeNotSupported("useOriginalMessage", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getUseOriginalBody()) && type.equals((Object)ErrorHandlerType.NoErrorHandler)) {
            throw XmlCdiBeanFactory.attributeNotSupported("useOriginalBody", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getOnRedeliveryRef()) && type.equals((Object)ErrorHandlerType.NoErrorHandler)) {
            throw XmlCdiBeanFactory.attributeNotSupported("onRedeliveryRef", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getOnExceptionOccurredRef()) && type.equals((Object)ErrorHandlerType.NoErrorHandler)) {
            throw XmlCdiBeanFactory.attributeNotSupported("onExceptionOccurredRef", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getOnPrepareFailureRef()) && (type.equals((Object)ErrorHandlerType.TransactionErrorHandler) || type.equals((Object)ErrorHandlerType.NoErrorHandler))) {
            throw XmlCdiBeanFactory.attributeNotSupported("onPrepareFailureRef", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getRetryWhileRef()) && type.equals((Object)ErrorHandlerType.NoErrorHandler)) {
            throw XmlCdiBeanFactory.attributeNotSupported("retryWhileRef", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getOnRedeliveryRef()) && type.equals((Object)ErrorHandlerType.NoErrorHandler)) {
            throw XmlCdiBeanFactory.attributeNotSupported("redeliveryPolicyRef", type, definition.getId());
        }
        if (ObjectHelper.isNotEmpty((Object)definition.getExecutorServiceRef()) && type.equals((Object)ErrorHandlerType.NoErrorHandler)) {
            throw XmlCdiBeanFactory.attributeNotSupported("executorServiceRef", type, definition.getId());
        }
        String fqn = type.getTypeAsClass();
        Class clazz = ObjectHelper.loadClass((String)fqn);
        return new XmlErrorHandlerFactoryBean(this.manager, new SyntheticAnnotated(clazz, (Set<Type>)this.manager.createAnnotatedType(clazz).getTypeClosure(), new Annotation[]{Any.Literal.INSTANCE, NamedLiteral.of(definition.getId())}), clazz, bean -> "imported error handler with id [" + definition.getId() + "] from resource [" + url + "] with qualifiers " + bean.getQualifiers(), definition);
    }

    private static CreationException attributeNotSupported(String attribute, ErrorHandlerType type, String id) {
        return new CreationException(String.format("Attribute [%s] is not supported by error handler type [%s], in error handler with id [%s]", new Object[]{attribute, type, id}));
    }

    private static <T extends IdentifiedType> boolean hasId(T type) {
        return ObjectHelper.isNotEmpty((Object)type.getId());
    }

    private static <T extends OptionalIdentifiedDefinition<T>> boolean hasId(T type) {
        return ObjectHelper.isNotEmpty((Object)type.getId());
    }
}

