/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.remoting;

import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.FailedToCreateProducerException;
import org.apache.camel.Producer;
import org.apache.camel.component.bean.ProxyHelper;
import org.apache.camel.spring.util.CamelContextResolverHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;

public class CamelProxyFactoryBean
extends UrlBasedRemoteAccessor
implements FactoryBean<Object>,
CamelContextAware,
DisposableBean,
ApplicationContextAware {
    private String serviceRef;
    private CamelContext camelContext;
    private String camelContextId;
    private ApplicationContext applicationContext;
    private Endpoint endpoint;
    private Object serviceProxy;
    private Producer producer;

    @Override
    public void afterPropertiesSet() {
        if (this.endpoint == null) {
            if (ObjectHelper.isNotEmpty(this.camelContextId)) {
                this.camelContext = CamelContextResolverHelper.getCamelContextWithId(this.applicationContext, this.camelContextId);
            }
            if (this.camelContext == null) {
                throw new IllegalArgumentException("camelContext or camelContextId must be specified");
            }
            if (this.getServiceUrl() == null && this.getServiceRef() == null) {
                throw new IllegalArgumentException("serviceUrl or serviceRef must be specified.");
            }
            this.endpoint = this.getServiceRef() != null ? this.camelContext.getRegistry().lookupByNameAndType(this.getServiceRef(), Endpoint.class) : this.camelContext.getEndpoint(this.getServiceUrl());
            if (this.endpoint == null) {
                throw new IllegalArgumentException("Could not resolve endpoint: " + this.getServiceUrl());
            }
        }
        try {
            this.producer = this.endpoint.createProducer();
            ServiceHelper.startService(this.producer);
            this.serviceProxy = ProxyHelper.createProxy(this.endpoint, this.producer, this.getServiceInterface());
        }
        catch (Exception e) {
            throw new FailedToCreateProducerException(this.endpoint, (Throwable)e);
        }
    }

    @Override
    public void destroy() throws Exception {
        ServiceHelper.stopService(this.producer);
    }

    @Override
    public Class<?> getServiceInterface() {
        return super.getServiceInterface();
    }

    @Override
    public String getServiceUrl() {
        return super.getServiceUrl();
    }

    @Override
    public Object getObject() throws Exception {
        return this.serviceProxy;
    }

    @Override
    public Class<?> getObjectType() {
        return this.getServiceInterface();
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    public String getServiceRef() {
        return this.serviceRef;
    }

    public void setServiceRef(String serviceRef) {
        this.serviceRef = serviceRef;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public void setCamelContextId(String contextId) {
        this.camelContextId = contextId;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

