/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeExchangeException;
import org.apache.camel.WrappedFile;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExchangeHolder
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultExchangeHolder.class);
    private String exchangeId;
    private Object inBody;
    private Object outBody;
    private Boolean inFaultFlag = Boolean.FALSE;
    private Boolean outFaultFlag = Boolean.FALSE;
    private Map<String, Object> inHeaders;
    private Map<String, Object> outHeaders;
    private Map<String, Object> properties;
    private Exception exception;

    public static DefaultExchangeHolder marshal(Exchange exchange) {
        return DefaultExchangeHolder.marshal(exchange, true);
    }

    public static DefaultExchangeHolder marshal(Exchange exchange, boolean includeProperties) {
        ObjectHelper.notNull(exchange, "exchange");
        Object body = exchange.getIn().getBody();
        if (body instanceof WrappedFile || body instanceof File) {
            throw new RuntimeExchangeException("Message body of type " + body.getClass().getCanonicalName() + " is not supported by this marshaller.", exchange);
        }
        DefaultExchangeHolder payload = new DefaultExchangeHolder();
        payload.exchangeId = exchange.getExchangeId();
        payload.inBody = DefaultExchangeHolder.checkSerializableBody("in body", exchange, exchange.getIn().getBody());
        payload.safeSetInHeaders(exchange);
        if (exchange.hasOut()) {
            payload.outBody = DefaultExchangeHolder.checkSerializableBody("out body", exchange, exchange.getOut().getBody());
            payload.outFaultFlag = exchange.getOut().isFault();
            payload.safeSetOutHeaders(exchange);
        } else {
            payload.inFaultFlag = exchange.getIn().isFault();
        }
        if (includeProperties) {
            payload.safeSetProperties(exchange);
        }
        payload.exception = exchange.getException();
        return payload;
    }

    public static void unmarshal(Exchange exchange, DefaultExchangeHolder payload) {
        ObjectHelper.notNull(exchange, "exchange");
        ObjectHelper.notNull(payload, "payload");
        exchange.setExchangeId(payload.exchangeId);
        exchange.getIn().setBody(payload.inBody);
        if (payload.inHeaders != null) {
            exchange.getIn().setHeaders(payload.inHeaders);
        }
        if (payload.inFaultFlag != null) {
            exchange.getIn().setFault(payload.inFaultFlag);
        }
        if (payload.outBody != null) {
            exchange.getOut().setBody(payload.outBody);
            if (payload.outHeaders != null) {
                exchange.getOut().setHeaders(payload.outHeaders);
            }
            if (payload.outFaultFlag != null) {
                exchange.getOut().setFault(payload.outFaultFlag);
            }
        }
        if (payload.properties != null) {
            for (String key : payload.properties.keySet()) {
                exchange.setProperty(key, payload.properties.get(key));
            }
        }
        exchange.setException(payload.exception);
    }

    public static void addProperty(DefaultExchangeHolder payload, String key, Serializable property) {
        if (key == null || property == null) {
            return;
        }
        if (payload.properties == null) {
            payload.properties = new LinkedHashMap<String, Object>();
        }
        payload.properties.put(key, property);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultExchangeHolder[exchangeId=").append(this.exchangeId);
        sb.append("inBody=").append(this.inBody).append(", outBody=").append(this.outBody);
        sb.append(", inHeaders=").append(this.inHeaders).append(", outHeaders=").append(this.outHeaders);
        sb.append(", properties=").append(this.properties).append(", exception=").append(this.exception);
        return sb.append(']').toString();
    }

    private Map<String, Object> safeSetInHeaders(Exchange exchange) {
        Map<String, Object> map;
        if (exchange.getIn().hasHeaders() && (map = DefaultExchangeHolder.checkMapSerializableObjects("in headers", exchange, exchange.getIn().getHeaders())) != null && !map.isEmpty()) {
            this.inHeaders = new LinkedHashMap<String, Object>(map);
        }
        return null;
    }

    private Map<String, Object> safeSetOutHeaders(Exchange exchange) {
        Map<String, Object> map;
        if (exchange.hasOut() && exchange.getOut().hasHeaders() && (map = DefaultExchangeHolder.checkMapSerializableObjects("out headers", exchange, exchange.getOut().getHeaders())) != null && !map.isEmpty()) {
            this.outHeaders = new LinkedHashMap<String, Object>(map);
        }
        return null;
    }

    private Map<String, Object> safeSetProperties(Exchange exchange) {
        Map<String, Object> map;
        if (exchange.hasProperties() && (map = DefaultExchangeHolder.checkMapSerializableObjects("properties", exchange, exchange.getProperties())) != null && !map.isEmpty()) {
            this.properties = new LinkedHashMap<String, Object>(map);
        }
        return null;
    }

    private static Object checkSerializableBody(String type, Exchange exchange, Object object) {
        if (object == null) {
            return null;
        }
        Serializable converted = exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, object);
        if (converted != null) {
            return converted;
        }
        LOG.warn("Exchange " + type + " containing object: " + object + " of type: " + object.getClass().getCanonicalName() + " cannot be serialized, it will be excluded by the holder.");
        return null;
    }

    private static Map<String, Object> checkMapSerializableObjects(String type, Exchange exchange, Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Map valueMap;
            if (entry.getValue() == null) continue;
            Serializable converted = exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, entry.getValue());
            if (converted instanceof Collection) {
                Collection valueCol = (Collection)((Object)converted);
                if (!DefaultExchangeHolder.collectionContainsAllSerializableObjects(valueCol, exchange)) {
                    DefaultExchangeHolder.logCannotSerializeObject(type, entry.getKey(), entry.getValue());
                    continue;
                }
            } else if (converted instanceof Map && !DefaultExchangeHolder.mapContainsAllSerializableObjects(valueMap = (Map)((Object)converted), exchange)) {
                DefaultExchangeHolder.logCannotSerializeObject(type, entry.getKey(), entry.getValue());
                continue;
            }
            if (converted != null) {
                result.put(entry.getKey(), converted);
                continue;
            }
            DefaultExchangeHolder.logCannotSerializeObject(type, entry.getKey(), entry.getValue());
        }
        return result;
    }

    private static void logCannotSerializeObject(String type, String key, Object value) {
        if (key.startsWith("Camel")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exchange {} containing key: {} with object: {} of type: {} cannot be serialized, it will be excluded by the holder.", type, key, value, ObjectHelper.classCanonicalName(value));
            }
        } else {
            LOG.warn("Exchange {} containing key: {} with object: {} of type: {} cannot be serialized, it will be excluded by the holder.", type, key, value, ObjectHelper.classCanonicalName(value));
        }
    }

    private static boolean collectionContainsAllSerializableObjects(Collection<?> col, Exchange exchange) {
        for (Object value : col) {
            Serializable converted;
            if (value == null || (converted = exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, value)) != null) continue;
            return false;
        }
        return true;
    }

    private static boolean mapContainsAllSerializableObjects(Map<?, ?> map, Exchange exchange) {
        for (Object value : map.values()) {
            Serializable converted;
            if (value == null || (converted = exchange.getContext().getTypeConverter().convertTo(Serializable.class, exchange, value)) != null) continue;
            return false;
        }
        return true;
    }
}

