/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.ws.jetty9;

import java.io.IOException;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.ws.AbstractStompSocket;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StompSocket
extends AbstractStompSocket
implements WebSocketListener {
    private static final Logger LOG = LoggerFactory.getLogger(StompSocket.class);
    private Session session;

    public StompSocket(String remoteAddress) {
        super(remoteAddress);
    }

    @Override
    public void sendToStomp(StompFrame command) throws IOException {
        this.session.getRemote().sendString(command.format());
    }

    @Override
    public void handleStopped() throws IOException {
        if (this.session != null && this.session.isOpen()) {
            this.session.close();
        }
    }

    public void onWebSocketBinary(byte[] arg0, int arg1, int arg2) {
    }

    public void onWebSocketClose(int arg0, String arg1) {
        try {
            this.protocolConverter.onStompCommand(new StompFrame("DISCONNECT"));
        }
        catch (Exception e) {
            LOG.warn("Failed to close WebSocket", e);
        }
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
    }

    public void onWebSocketError(Throwable arg0) {
    }

    public void onWebSocketText(String data) {
        this.processStompFrame(data);
    }
}

