/*
 * Decompiled with CFR 0.152.
 */
package org.amqphub.spring.boot.jms.autoconfigure;

import java.util.Collections;
import java.util.List;
import org.amqphub.spring.boot.jms.autoconfigure.AMQP10JMSConnectionFactoryCustomizer;
import org.amqphub.spring.boot.jms.autoconfigure.AMQP10JMSProperties;
import org.apache.qpid.jms.JmsConnectionFactory;
import org.apache.qpid.jms.policy.JmsDefaultDeserializationPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AMQP10JMSConnectionFactoryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AMQP10JMSConnectionFactoryFactory.class);
    private final AMQP10JMSProperties properties;
    private final List<AMQP10JMSConnectionFactoryCustomizer> factoryCustomizers;

    public AMQP10JMSConnectionFactoryFactory(AMQP10JMSProperties properties) {
        this(properties, null);
    }

    public AMQP10JMSConnectionFactoryFactory(AMQP10JMSProperties properties, List<AMQP10JMSConnectionFactoryCustomizer> factoryCustomizers) {
        Assert.notNull((Object)properties, (String)"Properties must not be null");
        this.properties = properties;
        this.factoryCustomizers = factoryCustomizers != null ? factoryCustomizers : Collections.emptyList();
    }

    public JmsConnectionFactory createConnectionFactory(Class<JmsConnectionFactory> factoryClass) {
        try {
            JmsConnectionFactory factory = new JmsConnectionFactory();
            factory.setRemoteURI(this.properties.getRemoteUrl());
            if (StringUtils.hasLength((String)this.properties.getUsername())) {
                factory.setUsername(this.properties.getUsername());
            }
            if (StringUtils.hasLength((String)this.properties.getPassword())) {
                factory.setPassword(this.properties.getPassword());
            }
            if (StringUtils.hasLength((String)this.properties.getClientId())) {
                factory.setClientID(this.properties.getClientId());
            }
            factory.setReceiveLocalOnly(this.properties.isReceiveLocalOnly());
            factory.setReceiveNoWaitLocalOnly(this.properties.isReceiveNoWaitLocalOnly());
            this.configureDeserializationPolicy(this.properties, factory);
            this.customizeFactoryConfiguration(factory);
            return factory;
        }
        catch (Exception ex) {
            LOG.error("Exception while createing the AMQP 1.0 JMS Connection Factory.", (Throwable)ex);
            throw new IllegalStateException("Failed to create the AMQP 1.0 JMS ConnectionFactory, make sure the client Jar is on the Classpath.", ex);
        }
    }

    private void configureDeserializationPolicy(AMQP10JMSProperties properties, JmsConnectionFactory factory) {
        JmsDefaultDeserializationPolicy deserializationPolicy = (JmsDefaultDeserializationPolicy)factory.getDeserializationPolicy();
        if (!ObjectUtils.isEmpty(properties.getDeserializationPolicy().getWhiteList())) {
            deserializationPolicy.setWhiteList(StringUtils.collectionToCommaDelimitedString(properties.getDeserializationPolicy().getWhiteList()));
        }
        if (!ObjectUtils.isEmpty(properties.getDeserializationPolicy().getBlackList())) {
            deserializationPolicy.setBlackList(StringUtils.collectionToCommaDelimitedString(properties.getDeserializationPolicy().getBlackList()));
        }
    }

    private void customizeFactoryConfiguration(JmsConnectionFactory connectionFactory) {
        for (AMQP10JMSConnectionFactoryCustomizer factoryCustomizer : this.factoryCustomizers) {
            factoryCustomizer.customize(connectionFactory);
        }
    }
}

