/*
 * Copyright 2018 Alfresco, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.activiti.runtime.api;

import org.activiti.runtime.api.model.ProcessDefinition;
import org.activiti.runtime.api.model.ProcessInstance;
import org.activiti.runtime.api.model.payloads.*;
import org.activiti.runtime.api.query.Page;
import org.activiti.runtime.api.query.Pageable;

public interface ProcessAdminRuntime {

    /**
     * Get process definition by key or id (where the ID is autogenerated at deployment time)
     */
    ProcessDefinition processDefinition(String processDefinitionId);

    /**
     * Get all process definitions by pages
     */
    Page<ProcessDefinition> processDefinitions(Pageable pageable);

    /**
     * Get all process definitions by pages using payload filters
     */
    Page<ProcessDefinition> processDefinitions(Pageable pageable,
                                               GetProcessDefinitionsPayload getProcessDefinitionsPayload);


    /**
     * Start a new Process Instance based on the payload parameters
     */
    ProcessInstance start(StartProcessPayload startProcessPayload);

    /**
     * Get all process instances by pages
     * - Notice that only in-flight or suspended processes will be returned here
     * - For already completed process instance check at the query service
     */
    Page<ProcessInstance> processInstances(Pageable pageable);

    /**
     * Get all process instances by pages filtering by
     * - Notice that only in-flight or suspended processes will be returned here
     * - For already completed process instance check at the query service
     */
    Page<ProcessInstance> processInstances(Pageable pageable,
                                           GetProcessInstancesPayload getProcessInstancesPayload);

    /**
     * Get Process Instance by id
     */
    ProcessInstance processInstance(String processInstanceId);


    /**
     * Delete a Process Instance
     */
    ProcessInstance delete(DeleteProcessPayload deleteProcessPayload);


    /**
     * Signal
     */
    void signal(SignalPayload signalPayload);

    /**
     * Suspend a process instance
     */
    ProcessInstance suspend(SuspendProcessPayload suspendProcessPayload);


    /**
     * Resume a suspended process instance
     */
    ProcessInstance resume(ResumeProcessPayload resumeProcessPayload);


    void setVariables(SetProcessVariablesPayload setProcessVariablesPayload);

    void removeVariables(RemoveProcessVariablesPayload removeProcessVariablesPayload);
}
