/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.runtime.api.connector;

import java.util.Map;
import java.util.stream.Collectors;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.spring.process.ProcessExtensionService;
import org.activiti.spring.process.model.Mapping;
import org.activiti.spring.process.model.ProcessExtensionModel;
import org.activiti.spring.process.model.ProcessVariablesMapping;
import org.activiti.spring.process.model.VariableDefinition;

public class InboundVariableValueProvider {
    private ProcessExtensionService processExtensionService;

    public InboundVariableValueProvider(ProcessExtensionService processExtensionService) {
        this.processExtensionService = processExtensionService;
    }

    public Object calculateMappedValue(org.activiti.core.common.model.connector.VariableDefinition variableDefinition, DelegateExecution execution) {
        ProcessExtensionModel extensions = this.processExtensionService.getExtensionsForId(execution.getProcessDefinitionId());
        ProcessVariablesMapping processVariablesMapping = extensions.getExtensions().getMappingForFlowElement(execution.getCurrentActivityId());
        Mapping inputMapping = processVariablesMapping.getInputMapping(variableDefinition.getId());
        if (inputMapping != null) {
            if (Mapping.SourceMappingType.VALUE.equals((Object)inputMapping.getType())) {
                return inputMapping.getValue();
            }
            if (Mapping.SourceMappingType.VARIABLE.equals((Object)inputMapping.getType())) {
                String variableUUID = inputMapping.getValue().toString();
                VariableDefinition processVariableDefinition = extensions.getExtensions().getProperty(variableUUID);
                if (processVariableDefinition != null) {
                    return execution.getVariable(processVariableDefinition.getName());
                }
            }
        }
        return execution.getVariable(variableDefinition.getName());
    }

    public Map<String, Object> calculateStaticValues(DelegateExecution execution) {
        ProcessExtensionModel extensions = this.processExtensionService.getExtensionsForId(execution.getProcessDefinitionId());
        ProcessVariablesMapping processVariablesMapping = extensions.getExtensions().getMappingForFlowElement(execution.getCurrentActivityId());
        Map inputs = processVariablesMapping.getInputs();
        return inputs.entrySet().stream().filter(input -> Mapping.SourceMappingType.STATIC_VALUE.equals((Object)((Mapping)input.getValue()).getType())).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Mapping)entry.getValue()).getValue()));
    }
}

