/*
 * Decompiled with CFR 0.152.
 */
package no.entur.mapstruct.spi.protobuf;

import com.google.common.base.CaseFormat;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.spi.DefaultEnumMappingStrategy;

public class ProtobufEnumMappingStrategy
extends DefaultEnumMappingStrategy {
    private static final String DEFAULT_ENUM_POSTFIX = "UNSPECIFIED";
    private static final String UNPARSABLE_ENUM_CONSTANT_UNRECOGNIZED = "UNRECOGNIZED";
    private static final String PROTOBUF_ENUM_INTERFACE = "com.google.protobuf.ProtocolMessageEnum";
    private static final String PROTOBUF_LITE_ENUM_INTERFACE = "com.google.protobuf.Internal.EnumLite";
    private static final HashMap<TypeElement, Boolean> KNOWN_ENUMS = new HashMap();

    protected String getDefaultEnumConstant() {
        return DEFAULT_ENUM_POSTFIX;
    }

    public boolean isMapEnumConstantToNull(TypeElement enumType, String sourceEnumValue) {
        if (this.isProtobufEnum(enumType)) {
            if (UNPARSABLE_ENUM_CONSTANT_UNRECOGNIZED.equals(sourceEnumValue)) {
                return true;
            }
            String trimmedEnumValue = this.removeEnumNamePrefixFromConstant(enumType, sourceEnumValue);
            if (this.getDefaultEnumConstant().equals(trimmedEnumValue)) {
                return true;
            }
        }
        return false;
    }

    public String getDefaultNullEnumConstant(TypeElement enumType) {
        boolean isProtobufEnum = this.isProtobufEnum(enumType);
        if (isProtobufEnum) {
            return this.addEnumNamePrefixToConstant(enumType, this.getDefaultEnumConstant());
        }
        return null;
    }

    public String getEnumConstant(TypeElement enumType, String sourceEnumValue) {
        boolean isProtobufEnum = this.isProtobufEnum(enumType);
        if (isProtobufEnum) {
            if (this.isMapEnumConstantToNull(enumType, sourceEnumValue)) {
                return "<NULL>";
            }
            if (sourceEnumValue == null) {
                return this.getDefaultNullEnumConstant(enumType);
            }
            return this.removeEnumNamePrefixFromConstant(enumType, sourceEnumValue);
        }
        return sourceEnumValue;
    }

    private String addEnumNamePrefixToConstant(TypeElement enumType, String constant) {
        String enumName = enumType.getSimpleName().toString();
        String prefix = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, enumName);
        String constructedValue = String.format("%s_%s", prefix, constant);
        return constructedValue;
    }

    private String removeEnumNamePrefixFromConstant(TypeElement enumType, String sourceEnumValue) {
        String enumName = enumType.getSimpleName().toString();
        String prefix = CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, enumName);
        String trimmedValue = sourceEnumValue.replace(prefix + "_", "");
        return trimmedValue;
    }

    private boolean isProtobufEnum(TypeElement enumType) {
        Boolean isProtobufEnum = KNOWN_ENUMS.get(enumType);
        if (isProtobufEnum == null) {
            List<? extends TypeMirror> interfaces = enumType.getInterfaces();
            isProtobufEnum = Boolean.FALSE;
            for (TypeMirror typeMirror : interfaces) {
                String implementedInterfaceName = typeMirror.toString();
                if (!PROTOBUF_ENUM_INTERFACE.equals(implementedInterfaceName) && !PROTOBUF_LITE_ENUM_INTERFACE.equals(implementedInterfaceName)) continue;
                isProtobufEnum = Boolean.TRUE;
                break;
            }
            KNOWN_ENUMS.put(enumType, isProtobufEnum);
        }
        return isProtobufEnum;
    }
}

