/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.util.Random;
import java.util.Vector;
import junit.framework.TestCase;
import shaded.org.bouncycastle.tls.ProtocolVersion;
import shaded.org.bouncycastle.tls.SecurityParameters;
import shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import shaded.org.bouncycastle.tls.TlsServerContext;
import shaded.org.bouncycastle.tls.TlsSession;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.TlsCrypto;
import shaded.org.bouncycastle.tls.crypto.TlsNonceGenerator;

public class TlsUtilsTest
extends TestCase {
    public void testChooseSignatureAndHash() throws Exception {
        int keyExchangeAlgorithm = 19;
        TlsServerContext context = new TlsServerContext(){

            @Override
            public TlsCrypto getCrypto() {
                return null;
            }

            @Override
            public TlsNonceGenerator getNonceGenerator() {
                return null;
            }

            @Override
            public SecurityParameters getSecurityParameters() {
                return null;
            }

            @Override
            public boolean isServer() {
                return false;
            }

            @Override
            public ProtocolVersion getClientVersion() {
                return null;
            }

            @Override
            public ProtocolVersion getServerVersion() {
                return ProtocolVersion.TLSv12;
            }

            @Override
            public TlsSession getResumableSession() {
                return null;
            }

            @Override
            public TlsSession getSession() {
                return null;
            }

            @Override
            public Object getUserObject() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void setUserObject(Object userObject) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] exportChannelBinding(int channelBinding) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] exportKeyingMaterial(String asciiLabel, byte[] context_value, int length) {
                throw new UnsupportedOperationException();
            }
        };
        short signatureAlgorithm = TlsUtils.getSignatureAlgorithm(keyExchangeAlgorithm);
        Vector supportedSignatureAlgorithms = TlsUtilsTest.getSignatureAlgorithms(false);
        SignatureAndHashAlgorithm sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(context, supportedSignatureAlgorithms, signatureAlgorithm);
        TlsUtilsTest.assertEquals((short)4, (short)sigAlg.getHash());
        for (int count = 0; count < 10; ++count) {
            supportedSignatureAlgorithms = TlsUtilsTest.getSignatureAlgorithms(true);
            sigAlg = TlsUtils.chooseSignatureAndHashAlgorithm(context, supportedSignatureAlgorithms, signatureAlgorithm);
            TlsUtilsTest.assertEquals((short)4, (short)sigAlg.getHash());
        }
    }

    private static Vector getSignatureAlgorithms(boolean randomise) {
        short[] hashAlgorithms = new short[]{2, 3, 4, 5, 6, 1};
        short[] signatureAlgorithms = new short[]{1, 2, 3};
        Vector<SignatureAndHashAlgorithm> result = new Vector<SignatureAndHashAlgorithm>();
        for (int i = 0; i < signatureAlgorithms.length; ++i) {
            for (int j = 0; j < hashAlgorithms.length; ++j) {
                result.addElement(new SignatureAndHashAlgorithm(hashAlgorithms[j], signatureAlgorithms[i]));
            }
        }
        Random r = new Random();
        int count = result.size();
        for (int src = 0; src < count; ++src) {
            int dst = r.nextInt(count);
            if (src == dst) continue;
            Object a = result.elementAt(src);
            Object b = result.elementAt(dst);
            result.setElementAt((SignatureAndHashAlgorithm)a, dst);
            result.setElementAt((SignatureAndHashAlgorithm)b, src);
        }
        return result;
    }
}

