/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import shaded.org.bouncycastle.tls.TlsServerProtocol;
import shaded.org.bouncycastle.tls.test.MockTlsServer;
import shaded.org.bouncycastle.util.io.Streams;
import shaded.org.bouncycastle.util.io.TeeOutputStream;

public class TlsServerTest {
    public static void main(String[] args) throws Exception {
        InetAddress address = InetAddress.getLocalHost();
        int port = 5556;
        ServerSocket ss = new ServerSocket(port, 16, address);
        try {
            while (true) {
                Socket s = ss.accept();
                System.out.println("--------------------------------------------------------------------------------");
                System.out.println("Accepted " + s);
                ServerThread t = new ServerThread(s);
                t.start();
            }
        }
        catch (Throwable throwable) {
            ss.close();
            throw throwable;
        }
    }

    static class ServerThread
    extends Thread {
        private final Socket s;

        ServerThread(Socket s) {
            this.s = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                MockTlsServer server2332 = new MockTlsServer();
                TlsServerProtocol serverProtocol = new TlsServerProtocol(this.s.getInputStream(), this.s.getOutputStream());
                serverProtocol.accept(server2332);
                TeeOutputStream log = new TeeOutputStream(serverProtocol.getOutputStream(), System.out);
                Streams.pipeAll(serverProtocol.getInputStream(), log);
                serverProtocol.close();
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    try {
                        this.s.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        throw throwable;
                    }
                }
            }
            try {
                this.s.close();
                return;
            }
            catch (IOException server2332) {
                return;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
    }
}

