/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.SecureRandom;
import junit.framework.TestCase;
import shaded.org.bouncycastle.tls.TlsClientProtocol;
import shaded.org.bouncycastle.tls.TlsServerProtocol;
import shaded.org.bouncycastle.tls.test.MockSRPTlsClient;
import shaded.org.bouncycastle.tls.test.MockSRPTlsServer;
import shaded.org.bouncycastle.util.Arrays;
import shaded.org.bouncycastle.util.io.Streams;

public class TlsSRPProtocolTest
extends TestCase {
    public void testClientServer() throws Exception {
        SecureRandom secureRandom = new SecureRandom();
        PipedInputStream clientRead = new PipedInputStream();
        PipedInputStream serverRead = new PipedInputStream();
        PipedOutputStream clientWrite = new PipedOutputStream(serverRead);
        PipedOutputStream serverWrite = new PipedOutputStream(clientRead);
        TlsClientProtocol clientProtocol = new TlsClientProtocol(clientRead, clientWrite);
        TlsServerProtocol serverProtocol = new TlsServerProtocol(serverRead, serverWrite);
        ServerThread serverThread = new ServerThread(serverProtocol);
        serverThread.start();
        MockSRPTlsClient client = new MockSRPTlsClient(null, MockSRPTlsServer.TEST_IDENTITY, MockSRPTlsServer.TEST_PASSWORD);
        clientProtocol.connect(client);
        int length = 1000;
        byte[] data = new byte[length];
        secureRandom.nextBytes(data);
        OutputStream output = clientProtocol.getOutputStream();
        output.write(data);
        byte[] echo = new byte[data.length];
        int count = Streams.readFully(clientProtocol.getInputStream(), echo);
        TlsSRPProtocolTest.assertEquals((int)count, (int)data.length);
        TlsSRPProtocolTest.assertTrue((boolean)Arrays.areEqual(data, echo));
        output.close();
        serverThread.join();
    }

    static class ServerThread
    extends Thread {
        private final TlsServerProtocol serverProtocol;

        ServerThread(TlsServerProtocol serverProtocol) {
            this.serverProtocol = serverProtocol;
        }

        @Override
        public void run() {
            try {
                MockSRPTlsServer server = new MockSRPTlsServer();
                this.serverProtocol.accept(server);
                Streams.pipeAll(this.serverProtocol.getInputStream(), this.serverProtocol.getOutputStream());
                this.serverProtocol.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

