/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.math.BigInteger;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import shaded.org.bouncycastle.asn1.ASN1GeneralizedTime;
import shaded.org.bouncycastle.asn1.ocsp.RevokedInfo;
import shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import shaded.org.bouncycastle.asn1.x509.CRLReason;
import shaded.org.bouncycastle.asn1.x509.KeyPurposeId;
import shaded.org.bouncycastle.cert.X509CertificateHolder;
import shaded.org.bouncycastle.cert.ocsp.BasicOCSPResp;
import shaded.org.bouncycastle.cert.ocsp.CertificateID;
import shaded.org.bouncycastle.cert.ocsp.CertificateStatus;
import shaded.org.bouncycastle.cert.ocsp.OCSPReq;
import shaded.org.bouncycastle.cert.ocsp.OCSPResp;
import shaded.org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import shaded.org.bouncycastle.cert.ocsp.Req;
import shaded.org.bouncycastle.cert.ocsp.RespID;
import shaded.org.bouncycastle.cert.ocsp.RevokedStatus;
import shaded.org.bouncycastle.cert.ocsp.jcajce.JcaBasicOCSPRespBuilder;
import shaded.org.bouncycastle.operator.DigestCalculatorProvider;
import shaded.org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import shaded.org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import shaded.org.bouncycastle.pkix.PKIXIdentity;
import shaded.org.bouncycastle.tls.test.CertChainUtil;
import shaded.org.bouncycastle.util.io.Streams;

public class TestOCSPCertServer {
    private final KeyPair signKP;
    private final X509Certificate rootCert;
    private final KeyPair interKP;
    private final X509Certificate interCert;
    private final DigestCalculatorProvider digCalcProv;
    private final X509CertificateHolder[] chain;
    private final Set<BigInteger> revocations = new HashSet<BigInteger>();

    public TestOCSPCertServer() throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA");
        kpGen.initialize(2048);
        KeyPair trustKP = kpGen.generateKeyPair();
        this.interKP = kpGen.generateKeyPair();
        this.signKP = kpGen.generateKeyPair();
        this.digCalcProv = new JcaDigestCalculatorProviderBuilder().build();
        this.rootCert = CertChainUtil.createMasterCert("CN=Root Certificate", trustKP);
        this.interCert = CertChainUtil.createIntermediateCert("CN=Intermediate Certificate", this.interKP.getPublic(), trustKP.getPrivate(), this.rootCert);
        X509Certificate ocspCert = CertChainUtil.createEndEntityCert("CN=OCSP Signing Certificate", this.signKP.getPublic(), this.interKP.getPrivate(), this.interCert, KeyPurposeId.id_kp_OCSPSigning);
        this.chain = new X509CertificateHolder[]{new X509CertificateHolder(ocspCert.getEncoded()), new X509CertificateHolder(this.interCert.getEncoded())};
    }

    public X509Certificate getRootCert() {
        return this.rootCert;
    }

    public X509Certificate getCACert() {
        return this.interCert;
    }

    public PKIXIdentity issueClientCert(String subjectName, boolean markRevoked) throws Exception {
        KeyPairGenerator kpGen = KeyPairGenerator.getInstance("RSA");
        kpGen.initialize(2048);
        KeyPair eeKP = kpGen.generateKeyPair();
        X509Certificate endEntityCert = CertChainUtil.createEndEntityCert(subjectName, eeKP.getPublic(), this.interKP.getPrivate(), this.interCert);
        if (markRevoked) {
            this.revocations.add(endEntityCert.getSerialNumber());
        }
        return new PKIXIdentity(PrivateKeyInfo.getInstance(eeKP.getPrivate().getEncoded()), new X509CertificateHolder[]{new X509CertificateHolder(endEntityCert.getEncoded()), new X509CertificateHolder(this.interCert.getEncoded())});
    }

    public OCSPResp respond(OCSPReq request) throws Exception {
        JcaBasicOCSPRespBuilder respGen = new JcaBasicOCSPRespBuilder(this.signKP.getPublic(), this.digCalcProv.get(RespID.HASH_SHA1));
        Req[] requests = request.getRequestList();
        for (int i = 0; i != requests.length; ++i) {
            CertificateID id = requests[i].getCertID();
            if (this.revocations.contains(id.getSerialNumber())) {
                respGen.addResponse(id, new RevokedStatus(new RevokedInfo(new ASN1GeneralizedTime(new Date(System.currentTimeMillis() - 60000L)), CRLReason.lookup(4))));
                continue;
            }
            respGen.addResponse(id, CertificateStatus.GOOD);
        }
        BasicOCSPResp resp = respGen.build(new JcaContentSignerBuilder("SHA1withRSA").build(this.signKP.getPrivate()), this.chain, new Date());
        OCSPRespBuilder rGen = new OCSPRespBuilder();
        return rGen.build(0, resp);
    }

    public static class ServerTask
    implements Runnable {
        private final int portNo;
        private final TestOCSPCertServer server;

        public ServerTask(int portNo, TestOCSPCertServer server) {
            this.portNo = portNo;
            this.server = server;
        }

        @Override
        public void run() {
            try {
                ServerSocket ss = new ServerSocket(this.portNo);
                Socket s = ss.accept();
                OCSPReq request = new OCSPReq(Streams.readAll(s.getInputStream()));
                s.getOutputStream().write(this.server.respond(request).getEncoded());
                s.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

