/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class NetworkInputStream
extends FilterInputStream {
    boolean closed = false;

    public NetworkInputStream(InputStream input) {
        super(input);
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public int available() throws IOException {
        this.checkNotClosed();
        return this.in.available();
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int read() throws IOException {
        this.checkNotClosed();
        return this.in.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkNotClosed();
        return this.in.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkNotClosed();
        return this.in.read(b, off, len);
    }

    protected synchronized void checkNotClosed() throws IOException {
        if (this.closed) {
            throw new IOException("NetworkInputStream closed");
        }
    }
}

