/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.test;

import java.io.IOException;
import java.io.PrintStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import shaded.org.bouncycastle.asn1.x509.Certificate;
import shaded.org.bouncycastle.tls.AlertDescription;
import shaded.org.bouncycastle.tls.AlertLevel;
import shaded.org.bouncycastle.tls.CertificateRequest;
import shaded.org.bouncycastle.tls.DefaultTlsClient;
import shaded.org.bouncycastle.tls.ProtocolVersion;
import shaded.org.bouncycastle.tls.TlsAuthentication;
import shaded.org.bouncycastle.tls.TlsCredentials;
import shaded.org.bouncycastle.tls.TlsExtensionsUtils;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsServerCertificate;
import shaded.org.bouncycastle.tls.TlsSession;
import shaded.org.bouncycastle.tls.crypto.TlsCertificate;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import shaded.org.bouncycastle.tls.test.TlsTestUtils;
import shaded.org.bouncycastle.util.Arrays;
import shaded.org.bouncycastle.util.encoders.Hex;

class MockTlsClient
extends DefaultTlsClient {
    TlsSession session;

    MockTlsClient(TlsSession session) {
        super(new BcTlsCrypto(new SecureRandom()));
        this.session = session;
    }

    @Override
    public TlsSession getSessionToResume() {
        return this.session;
    }

    @Override
    public void notifyAlertRaised(short alertLevel, short alertDescription, String message, Throwable cause) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS client raised alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
        if (message != null) {
            out.println("> " + message);
        }
        if (cause != null) {
            cause.printStackTrace(out);
        }
    }

    @Override
    public void notifyAlertReceived(short alertLevel, short alertDescription) {
        PrintStream out = alertLevel == 2 ? System.err : System.out;
        out.println("TLS client received alert: " + AlertLevel.getText(alertLevel) + ", " + AlertDescription.getText(alertDescription));
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable clientExtensions = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsExtensionsUtils.addMaxFragmentLengthExtension(clientExtensions, (short)1);
        TlsExtensionsUtils.addPaddingExtension(clientExtensions, this.context.getCrypto().getSecureRandom().nextInt(16));
        TlsExtensionsUtils.addTruncatedHMacExtension(clientExtensions);
        return clientExtensions;
    }

    @Override
    public void notifyServerVersion(ProtocolVersion serverVersion) throws IOException {
        super.notifyServerVersion(serverVersion);
        System.out.println("TLS client negotiated " + serverVersion);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        return new TlsAuthentication(){

            @Override
            public void notifyServerCertificate(TlsServerCertificate serverCertificate) throws IOException {
                boolean isEmpty;
                TlsCertificate[] chain = serverCertificate.getCertificate().getCertificateList();
                System.out.println("TLS client received server certificate chain of length " + chain.length);
                for (int i = 0; i != chain.length; ++i) {
                    Certificate entry = Certificate.getInstance(chain[i].getEncoded());
                    System.out.println("    fingerprint:SHA-256 " + TlsTestUtils.fingerprint(entry) + " (" + entry.getSubject() + ")");
                }
                boolean bl = isEmpty = serverCertificate == null || serverCertificate.getCertificate() == null || serverCertificate.getCertificate().isEmpty();
                if (isEmpty || !TlsTestUtils.isCertificateOneOf(MockTlsClient.this.context.getCrypto(), chain[0], new String[]{"x509-server-dsa.pem", "x509-server-ecdsa.pem", "x509-server-rsa-sign.pem"})) {
                    throw new TlsFatalAlert(42);
                }
            }

            @Override
            public TlsCredentials getClientCredentials(CertificateRequest certificateRequest) throws IOException {
                short[] certificateTypes = certificateRequest.getCertificateTypes();
                if (certificateTypes == null || !Arrays.contains(certificateTypes, (short)1)) {
                    return null;
                }
                return TlsTestUtils.loadSignerCredentials(MockTlsClient.this.context, certificateRequest.getSupportedSignatureAlgorithms(), (short)1, "x509-client-rsa.pem", "x509-client-key-rsa.pem");
            }
        };
    }

    @Override
    public void notifyHandshakeComplete() throws IOException {
        super.notifyHandshakeComplete();
        byte[] tlsUnique = this.context.exportChannelBinding(1);
        System.out.println("'tls-unique': " + Hex.toHexString(tlsUnique));
        TlsSession newSession = this.context.getResumableSession();
        if (newSession != null) {
            byte[] newSessionID = newSession.getSessionID();
            String hex = Hex.toHexString(newSessionID);
            if (this.session != null && Arrays.areEqual(this.session.getSessionID(), newSessionID)) {
                System.out.println("Resumed session: " + hex);
            } else {
                System.out.println("Established session: " + hex);
            }
            this.session = newSession;
        }
    }
}

