/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.crypto.TlsSigner;
import shaded.org.bouncycastle.tls.crypto.TlsStreamSigner;
import shaded.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

public class JcaTlsDSSSigner
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;
    private final short algorithmType;
    private final String algorithmName;

    public JcaTlsDSSSigner(JcaTlsCrypto crypto, PrivateKey privateKey, short algorithmType, String algorithmName) {
        this.crypto = crypto;
        this.privateKey = privateKey;
        this.algorithmType = algorithmType;
        this.algorithmName = algorithmName;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        if (algorithm != null && algorithm.getSignature() != this.algorithmType) {
            throw new IllegalStateException();
        }
        try {
            Signature signer = this.crypto.getHelper().createSignature(this.algorithmName);
            signer.initSign(this.privateKey);
            if (algorithm == null) {
                signer.update(hash, 16, 20);
            } else {
                signer.update(hash, 0, hash.length);
            }
            return signer.sign();
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) {
        return null;
    }
}

