/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.DSAPublicKey;
import shaded.org.bouncycastle.jcajce.util.JcaJceHelper;
import shaded.org.bouncycastle.tls.DigitallySigned;
import shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import shaded.org.bouncycastle.tls.crypto.TlsStreamVerifier;
import shaded.org.bouncycastle.tls.crypto.TlsVerifier;

public class JcaTlsDSAVerifier
implements TlsVerifier {
    private final JcaJceHelper helper;
    private final DSAPublicKey pubKey;

    protected JcaTlsDSAVerifier(DSAPublicKey pubKey, JcaJceHelper helper) {
        if (pubKey == null) {
            throw new IllegalArgumentException("'pubKey' cannot be null");
        }
        this.pubKey = pubKey;
        this.helper = helper;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        return null;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() != 2) {
            throw new IllegalStateException();
        }
        try {
            Signature signer = this.helper.createSignature("NoneWithDSA");
            signer.initVerify(this.pubKey);
            if (algorithm == null) {
                signer.update(hash, 16, 20);
            } else {
                signer.update(hash, 0, hash.length);
            }
            return signer.verify(signedParams.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }
}

