/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import shaded.org.bouncycastle.crypto.CryptoException;
import shaded.org.bouncycastle.crypto.params.ECKeyParameters;
import shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import shaded.org.bouncycastle.crypto.signers.SM2Signer;
import shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcTlsSM2Signer
extends BcTlsSigner {
    public BcTlsSM2Signer(BcTlsCrypto crypto, ECKeyParameters privateKey) {
        super(crypto, privateKey);
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        SM2Signer signer = new SM2Signer();
        signer.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

