/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import shaded.org.bouncycastle.crypto.CryptoException;
import shaded.org.bouncycastle.crypto.Digest;
import shaded.org.bouncycastle.crypto.Signer;
import shaded.org.bouncycastle.crypto.encodings.PKCS1Encoding;
import shaded.org.bouncycastle.crypto.engines.RSABlindedEngine;
import shaded.org.bouncycastle.crypto.params.ParametersWithRandom;
import shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import shaded.org.bouncycastle.crypto.signers.GenericSigner;
import shaded.org.bouncycastle.crypto.signers.RSADigestSigner;
import shaded.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.TlsUtils;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsSigner;

public class BcTlsRSASigner
extends BcTlsSigner {
    public BcTlsRSASigner(BcTlsCrypto crypto, RSAKeyParameters privateKey) {
        super(crypto, privateKey);
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        Signer signer;
        Digest nullDigest = this.crypto.createDigest((short)0);
        if (algorithm != null) {
            if (algorithm.getSignature() != 1) {
                throw new IllegalStateException();
            }
            signer = new RSADigestSigner(nullDigest, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), nullDigest);
        }
        signer.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

