/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.math.BigInteger;
import shaded.org.bouncycastle.asn1.x9.ECNamedCurveTable;
import shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import shaded.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import shaded.org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import shaded.org.bouncycastle.crypto.ec.CustomNamedCurves;
import shaded.org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import shaded.org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import shaded.org.bouncycastle.crypto.params.ECPublicKeyParameters;
import shaded.org.bouncycastle.math.ec.ECPoint;
import shaded.org.bouncycastle.tls.NamedGroup;
import shaded.org.bouncycastle.tls.TlsFatalAlert;
import shaded.org.bouncycastle.tls.crypto.TlsAgreement;
import shaded.org.bouncycastle.tls.crypto.TlsECConfig;
import shaded.org.bouncycastle.tls.crypto.TlsECDomain;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsECDH;
import shaded.org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import shaded.org.bouncycastle.util.BigIntegers;

public class BcTlsECDomain
implements TlsECDomain {
    protected final BcTlsCrypto crypto;
    protected final TlsECConfig ecConfig;
    protected final ECDomainParameters ecDomainParameters;

    public static byte[] calculateBasicAgreement(ECPrivateKeyParameters privateKey, ECPublicKeyParameters publicKey) {
        ECDHBasicAgreement basicAgreement = new ECDHBasicAgreement();
        basicAgreement.init(privateKey);
        BigInteger agreementValue = basicAgreement.calculateAgreement(publicKey);
        return BigIntegers.asUnsignedByteArray(basicAgreement.getFieldSize(), agreementValue);
    }

    public static ECDomainParameters getDomainParameters(TlsECConfig ecConfig) {
        return BcTlsECDomain.getDomainParameters(ecConfig.getNamedGroup());
    }

    public static ECDomainParameters getDomainParameters(int namedGroup) {
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            return null;
        }
        String curveName = NamedGroup.getName(namedGroup);
        if (curveName == null) {
            return null;
        }
        X9ECParameters ecP = CustomNamedCurves.getByName(curveName);
        if (ecP == null && (ecP = ECNamedCurveTable.getByName(curveName)) == null) {
            return null;
        }
        return new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public BcTlsECDomain(BcTlsCrypto crypto, TlsECConfig ecConfig) {
        this.crypto = crypto;
        this.ecConfig = ecConfig;
        this.ecDomainParameters = BcTlsECDomain.getDomainParameters(ecConfig);
    }

    public BcTlsSecret calculateECDHAgreement(ECPrivateKeyParameters privateKey, ECPublicKeyParameters publicKey) {
        return this.crypto.adoptLocalSecret(BcTlsECDomain.calculateBasicAgreement(privateKey, publicKey));
    }

    @Override
    public TlsAgreement createECDH() {
        return new BcTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] encoding) throws IOException {
        return this.ecDomainParameters.getCurve().decodePoint(encoding);
    }

    public ECPublicKeyParameters decodePublicKey(byte[] encoding) throws IOException {
        try {
            ECPoint point = this.decodePoint(encoding);
            return new ECPublicKeyParameters(point, this.ecDomainParameters);
        }
        catch (RuntimeException e) {
            throw new TlsFatalAlert(47, (Throwable)e);
        }
    }

    public byte[] encodePoint(ECPoint point) throws IOException {
        return point.getEncoded(this.ecConfig.getPointCompression());
    }

    public byte[] encodePublicKey(ECPublicKeyParameters publicKey) throws IOException {
        return this.encodePoint(publicKey.getQ());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        ECKeyPairGenerator keyPairGenerator = new ECKeyPairGenerator();
        keyPairGenerator.init(new ECKeyGenerationParameters(this.ecDomainParameters, this.crypto.getSecureRandom()));
        return keyPairGenerator.generateKeyPair();
    }
}

